/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Specifies an exponential sequence of buckets that have a width that is proportional to the value
 * of the lower bound. Each bucket represents a constant relative uncertainty on a specific value in
 * the bucket.There are num_finite_buckets + 2 (= N) buckets. Bucket i has the following
 * boundaries:Upper bound (0 <= i < N-1): scale * (growth_factor ^ i).  Lower bound (1 <= i < N):
 * scale * (growth_factor ^ (i - 1)).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Exponential extends com.google.api.client.json.GenericJson {

  /**
   * Must be greater than 1.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double growthFactor;

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numFiniteBuckets;

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double scale;

  /**
   * Must be greater than 1.
   * @return value or {@code null} for none
   */
  public java.lang.Double getGrowthFactor() {
    return growthFactor;
  }

  /**
   * Must be greater than 1.
   * @param growthFactor growthFactor or {@code null} for none
   */
  public Exponential setGrowthFactor(java.lang.Double growthFactor) {
    this.growthFactor = growthFactor;
    return this;
  }

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumFiniteBuckets() {
    return numFiniteBuckets;
  }

  /**
   * Must be greater than 0.
   * @param numFiniteBuckets numFiniteBuckets or {@code null} for none
   */
  public Exponential setNumFiniteBuckets(java.lang.Integer numFiniteBuckets) {
    this.numFiniteBuckets = numFiniteBuckets;
    return this;
  }

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Double getScale() {
    return scale;
  }

  /**
   * Must be greater than 0.
   * @param scale scale or {@code null} for none
   */
  public Exponential setScale(java.lang.Double scale) {
    this.scale = scale;
    return this;
  }

  @Override
  public Exponential set(String fieldName, Object value) {
    return (Exponential) super.set(fieldName, value);
  }

  @Override
  public Exponential clone() {
    return (Exponential) super.clone();
  }

}
