/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * The GetNotificationChannelVerificationCode request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetNotificationChannelVerificationCodeRequest extends com.google.api.client.json.GenericJson {

  /**
   * The desired expiration time. If specified, the API will guarantee that the returned code will
   * not be valid after the specified timestamp; however, the API cannot guarantee that the returned
   * code will be valid for at least as long as the requested time (the API puts an upper bound on
   * the amount of time for which a code may be valid). If omitted, a default expiration will be
   * used, which may be less than the max permissible expiration (so specifying an expiration may
   * extend the code's lifetime over omitting an expiration, even though the API does impose an
   * upper limit on the maximum expiration that is permitted).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * The desired expiration time. If specified, the API will guarantee that the returned code will
   * not be valid after the specified timestamp; however, the API cannot guarantee that the returned
   * code will be valid for at least as long as the requested time (the API puts an upper bound on
   * the amount of time for which a code may be valid). If omitted, a default expiration will be
   * used, which may be less than the max permissible expiration (so specifying an expiration may
   * extend the code's lifetime over omitting an expiration, even though the API does impose an
   * upper limit on the maximum expiration that is permitted).
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * The desired expiration time. If specified, the API will guarantee that the returned code will
   * not be valid after the specified timestamp; however, the API cannot guarantee that the returned
   * code will be valid for at least as long as the requested time (the API puts an upper bound on
   * the amount of time for which a code may be valid). If omitted, a default expiration will be
   * used, which may be less than the max permissible expiration (so specifying an expiration may
   * extend the code's lifetime over omitting an expiration, even though the API does impose an
   * upper limit on the maximum expiration that is permitted).
   * @param expireTime expireTime or {@code null} for none
   */
  public GetNotificationChannelVerificationCodeRequest setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  @Override
  public GetNotificationChannelVerificationCodeRequest set(String fieldName, Object value) {
    return (GetNotificationChannelVerificationCodeRequest) super.set(fieldName, value);
  }

  @Override
  public GetNotificationChannelVerificationCodeRequest clone() {
    return (GetNotificationChannelVerificationCodeRequest) super.clone();
  }

}
