/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * The GetNotificationChannelVerificationCode request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetNotificationChannelVerificationCodeResponse extends com.google.api.client.json.GenericJson {

  /**
   * The verification code, which may be used to verify other channels that have an equivalent
   * identity (i.e. other channels of the same type with the same fingerprint such as other email
   * channels with the same email address or other sms channels with the same number).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String code;

  /**
   * The expiration time associated with the code that was returned. If an expiration was provided
   * in the request, this is the minimum of the requested expiration in the request and the max
   * permitted expiration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String expireTime;

  /**
   * The verification code, which may be used to verify other channels that have an equivalent
   * identity (i.e. other channels of the same type with the same fingerprint such as other email
   * channels with the same email address or other sms channels with the same number).
   * @return value or {@code null} for none
   */
  public java.lang.String getCode() {
    return code;
  }

  /**
   * The verification code, which may be used to verify other channels that have an equivalent
   * identity (i.e. other channels of the same type with the same fingerprint such as other email
   * channels with the same email address or other sms channels with the same number).
   * @param code code or {@code null} for none
   */
  public GetNotificationChannelVerificationCodeResponse setCode(java.lang.String code) {
    this.code = code;
    return this;
  }

  /**
   * The expiration time associated with the code that was returned. If an expiration was provided
   * in the request, this is the minimum of the requested expiration in the request and the max
   * permitted expiration.
   * @return value or {@code null} for none
   */
  public String getExpireTime() {
    return expireTime;
  }

  /**
   * The expiration time associated with the code that was returned. If an expiration was provided
   * in the request, this is the minimum of the requested expiration in the request and the max
   * permitted expiration.
   * @param expireTime expireTime or {@code null} for none
   */
  public GetNotificationChannelVerificationCodeResponse setExpireTime(String expireTime) {
    this.expireTime = expireTime;
    return this;
  }

  @Override
  public GetNotificationChannelVerificationCodeResponse set(String fieldName, Object value) {
    return (GetNotificationChannelVerificationCodeResponse) super.set(fieldName, value);
  }

  @Override
  public GetNotificationChannelVerificationCodeResponse clone() {
    return (GetNotificationChannelVerificationCodeResponse) super.clone();
  }

}
