/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * The description of a dynamic collection of monitored resources. Each group has a filter that is
 * matched against monitored resources and their associated metadata. If a group's filter matches an
 * available monitored resource, then that resource is a member of that group. Groups can contain
 * any number of monitored resources, and each monitored resource can be a member of any number of
 * groups.Groups can be nested in parent-child hierarchies. The parentName field identifies an
 * optional parent for each group. If a group has a parent, then the only monitored resources
 * available to be matched by the group's filter are the resources contained in the parent group. In
 * other words, a group contains the monitored resources that match its filter and the filters of
 * all the group's ancestors. A group without a parent can contain any monitored resource.For
 * example, consider an infrastructure running a set of instances with two user-defined tags:
 * "environment" and "role". A parent group has a filter, environment="production". A child of that
 * parent group has a filter, role="transcoder". The parent group contains all instances in the
 * production environment, regardless of their roles. The child group contains instances that have
 * the transcoder role and are in the production environment.The monitored resources contained in a
 * group can change at any moment, depending on what resources exist and what filters are associated
 * with the group and its ancestors.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Group extends com.google.api.client.json.GenericJson {

  /**
   * A user-assigned name for this group, used only for display purposes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The filter used to determine which monitored resources belong to this group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * If true, the members of this group are considered to be a cluster. The system can perform
   * additional analysis on groups that are clusters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isCluster;

  /**
   * Output only. The name of this group. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
   * ignored and a new name is created consisting of the project specified in the call to
   * CreateGroup and a unique {group_id} that is generated automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The name of the group's parent, if it has one. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". For groups with no parent, parentName is
   * the empty string, "".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parentName;

  /**
   * A user-assigned name for this group, used only for display purposes.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A user-assigned name for this group, used only for display purposes.
   * @param displayName displayName or {@code null} for none
   */
  public Group setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The filter used to determine which monitored resources belong to this group.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * The filter used to determine which monitored resources belong to this group.
   * @param filter filter or {@code null} for none
   */
  public Group setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * If true, the members of this group are considered to be a cluster. The system can perform
   * additional analysis on groups that are clusters.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsCluster() {
    return isCluster;
  }

  /**
   * If true, the members of this group are considered to be a cluster. The system can perform
   * additional analysis on groups that are clusters.
   * @param isCluster isCluster or {@code null} for none
   */
  public Group setIsCluster(java.lang.Boolean isCluster) {
    this.isCluster = isCluster;
    return this;
  }

  /**
   * Output only. The name of this group. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
   * ignored and a new name is created consisting of the project specified in the call to
   * CreateGroup and a unique {group_id} that is generated automatically.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The name of this group. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". When creating a group, this field is
   * ignored and a new name is created consisting of the project specified in the call to
   * CreateGroup and a unique {group_id} that is generated automatically.
   * @param name name or {@code null} for none
   */
  public Group setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The name of the group's parent, if it has one. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". For groups with no parent, parentName is
   * the empty string, "".
   * @return value or {@code null} for none
   */
  public java.lang.String getParentName() {
    return parentName;
  }

  /**
   * The name of the group's parent, if it has one. The format is
   * "projects/{project_id_or_number}/groups/{group_id}". For groups with no parent, parentName is
   * the empty string, "".
   * @param parentName parentName or {@code null} for none
   */
  public Group setParentName(java.lang.String parentName) {
    this.parentName = parentName;
    return this;
  }

  @Override
  public Group set(String fieldName, Object value) {
    return (Group) super.set(fieldName, value);
  }

  @Override
  public Group clone() {
    return (Group) super.clone();
  }

}
