/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Information involved in an HTTP/HTTPS uptime check request.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HttpCheck extends com.google.api.client.json.GenericJson {

  /**
   * The authentication information. Optional when creating an HTTP check; defaults to empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BasicAuthentication authInfo;

  /**
   * The list of headers to send as part of the uptime check request. If two headers have the same
   * key and different values, they should be entered as a single header, with the value being a
   * comma-separated list of all the desired values as described at
   * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with
   * the same key in a Create call will cause the first to be overwritten by the second. The maximum
   * number of headers allowed is 100.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> headers;

  /**
   * Boolean specifiying whether to encrypt the header information. Encryption should be specified
   * for any headers related to authentication that you do not wish to be seen when retrieving the
   * configuration. The server will be responsible for encrypting the headers. On Get/List calls, if
   * mask_headers is set to True then the headers will be obscured with ******.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean maskHeaders;

  /**
   * The path to the page to run the check against. Will be combined with the host (specified within
   * the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String path;

  /**
   * The port to the page to run the check against. Will be combined with host (specified within the
   * MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or
   * 443 with SSL).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer port;

  /**
   * If true, use HTTPS instead of HTTP to run the check.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useSsl;

  /**
   * The authentication information. Optional when creating an HTTP check; defaults to empty.
   * @return value or {@code null} for none
   */
  public BasicAuthentication getAuthInfo() {
    return authInfo;
  }

  /**
   * The authentication information. Optional when creating an HTTP check; defaults to empty.
   * @param authInfo authInfo or {@code null} for none
   */
  public HttpCheck setAuthInfo(BasicAuthentication authInfo) {
    this.authInfo = authInfo;
    return this;
  }

  /**
   * The list of headers to send as part of the uptime check request. If two headers have the same
   * key and different values, they should be entered as a single header, with the value being a
   * comma-separated list of all the desired values as described at
   * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with
   * the same key in a Create call will cause the first to be overwritten by the second. The maximum
   * number of headers allowed is 100.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getHeaders() {
    return headers;
  }

  /**
   * The list of headers to send as part of the uptime check request. If two headers have the same
   * key and different values, they should be entered as a single header, with the value being a
   * comma-separated list of all the desired values as described at
   * https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with
   * the same key in a Create call will cause the first to be overwritten by the second. The maximum
   * number of headers allowed is 100.
   * @param headers headers or {@code null} for none
   */
  public HttpCheck setHeaders(java.util.Map<String, java.lang.String> headers) {
    this.headers = headers;
    return this;
  }

  /**
   * Boolean specifiying whether to encrypt the header information. Encryption should be specified
   * for any headers related to authentication that you do not wish to be seen when retrieving the
   * configuration. The server will be responsible for encrypting the headers. On Get/List calls, if
   * mask_headers is set to True then the headers will be obscured with ******.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMaskHeaders() {
    return maskHeaders;
  }

  /**
   * Boolean specifiying whether to encrypt the header information. Encryption should be specified
   * for any headers related to authentication that you do not wish to be seen when retrieving the
   * configuration. The server will be responsible for encrypting the headers. On Get/List calls, if
   * mask_headers is set to True then the headers will be obscured with ******.
   * @param maskHeaders maskHeaders or {@code null} for none
   */
  public HttpCheck setMaskHeaders(java.lang.Boolean maskHeaders) {
    this.maskHeaders = maskHeaders;
    return this;
  }

  /**
   * The path to the page to run the check against. Will be combined with the host (specified within
   * the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
   * @return value or {@code null} for none
   */
  public java.lang.String getPath() {
    return path;
  }

  /**
   * The path to the page to run the check against. Will be combined with the host (specified within
   * the MonitoredResource) and port to construct the full URL. Optional (defaults to "/").
   * @param path path or {@code null} for none
   */
  public HttpCheck setPath(java.lang.String path) {
    this.path = path;
    return this;
  }

  /**
   * The port to the page to run the check against. Will be combined with host (specified within the
   * MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or
   * 443 with SSL).
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPort() {
    return port;
  }

  /**
   * The port to the page to run the check against. Will be combined with host (specified within the
   * MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or
   * 443 with SSL).
   * @param port port or {@code null} for none
   */
  public HttpCheck setPort(java.lang.Integer port) {
    this.port = port;
    return this;
  }

  /**
   * If true, use HTTPS instead of HTTP to run the check.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseSsl() {
    return useSsl;
  }

  /**
   * If true, use HTTPS instead of HTTP to run the check.
   * @param useSsl useSsl or {@code null} for none
   */
  public HttpCheck setUseSsl(java.lang.Boolean useSsl) {
    this.useSsl = useSsl;
    return this;
  }

  @Override
  public HttpCheck set(String fieldName, Object value) {
    return (HttpCheck) super.set(fieldName, value);
  }

  @Override
  public HttpCheck clone() {
    return (HttpCheck) super.clone();
  }

}
