/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Specifies a linear sequence of buckets that all have the same width (except overflow and
 * underflow). Each bucket represents a constant absolute uncertainty on the specific value in the
 * bucket.There are num_finite_buckets + 2 (= N) buckets. Bucket i has the following
 * boundaries:Upper bound (0 <= i < N-1): offset + (width * i).  Lower bound (1 <= i < N): offset +
 * (width * (i - 1)).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Linear extends com.google.api.client.json.GenericJson {

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numFiniteBuckets;

  /**
   * Lower bound of the first bucket.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double offset;

  /**
   * Must be greater than 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double width;

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumFiniteBuckets() {
    return numFiniteBuckets;
  }

  /**
   * Must be greater than 0.
   * @param numFiniteBuckets numFiniteBuckets or {@code null} for none
   */
  public Linear setNumFiniteBuckets(java.lang.Integer numFiniteBuckets) {
    this.numFiniteBuckets = numFiniteBuckets;
    return this;
  }

  /**
   * Lower bound of the first bucket.
   * @return value or {@code null} for none
   */
  public java.lang.Double getOffset() {
    return offset;
  }

  /**
   * Lower bound of the first bucket.
   * @param offset offset or {@code null} for none
   */
  public Linear setOffset(java.lang.Double offset) {
    this.offset = offset;
    return this;
  }

  /**
   * Must be greater than 0.
   * @return value or {@code null} for none
   */
  public java.lang.Double getWidth() {
    return width;
  }

  /**
   * Must be greater than 0.
   * @param width width or {@code null} for none
   */
  public Linear setWidth(java.lang.Double width) {
    this.width = width;
    return this;
  }

  @Override
  public Linear set(String fieldName, Object value) {
    return (Linear) super.set(fieldName, value);
  }

  @Override
  public Linear clone() {
    return (Linear) super.clone();
  }

}
