/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * The ListNotificationChannels response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListNotificationChannelsResponse extends com.google.api.client.json.GenericJson {

  /**
   * If not empty, indicates that there may be more results that match the request. Use the value in
   * the page_token field in a subsequent request to fetch the next set of results. If empty, all
   * results have been returned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The notification channels defined for the specified project.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<NotificationChannel> notificationChannels;

  static {
    // hack to force ProGuard to consider NotificationChannel used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(NotificationChannel.class);
  }

  /**
   * If not empty, indicates that there may be more results that match the request. Use the value in
   * the page_token field in a subsequent request to fetch the next set of results. If empty, all
   * results have been returned.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If not empty, indicates that there may be more results that match the request. Use the value in
   * the page_token field in a subsequent request to fetch the next set of results. If empty, all
   * results have been returned.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListNotificationChannelsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The notification channels defined for the specified project.
   * @return value or {@code null} for none
   */
  public java.util.List<NotificationChannel> getNotificationChannels() {
    return notificationChannels;
  }

  /**
   * The notification channels defined for the specified project.
   * @param notificationChannels notificationChannels or {@code null} for none
   */
  public ListNotificationChannelsResponse setNotificationChannels(java.util.List<NotificationChannel> notificationChannels) {
    this.notificationChannels = notificationChannels;
    return this;
  }

  @Override
  public ListNotificationChannelsResponse set(String fieldName, Object value) {
    return (ListNotificationChannelsResponse) super.set(fieldName, value);
  }

  @Override
  public ListNotificationChannelsResponse clone() {
    return (ListNotificationChannelsResponse) super.clone();
  }

}
