/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * The protocol for the ListUptimeCheckConfigs response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListUptimeCheckConfigsResponse extends com.google.api.client.json.GenericJson {

  /**
   * This field represents the pagination token to retrieve the next page of results. If the value
   * is empty, it means no further results for the request. To retrieve the next page of results,
   * the value of the next_page_token is passed to the subsequent List method call (in the request
   * message's page_token field).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The total number of uptime check configurations for the project, irrespective of any
   * pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * The returned uptime check configurations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<UptimeCheckConfig> uptimeCheckConfigs;

  static {
    // hack to force ProGuard to consider UptimeCheckConfig used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(UptimeCheckConfig.class);
  }

  /**
   * This field represents the pagination token to retrieve the next page of results. If the value
   * is empty, it means no further results for the request. To retrieve the next page of results,
   * the value of the next_page_token is passed to the subsequent List method call (in the request
   * message's page_token field).
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * This field represents the pagination token to retrieve the next page of results. If the value
   * is empty, it means no further results for the request. To retrieve the next page of results,
   * the value of the next_page_token is passed to the subsequent List method call (in the request
   * message's page_token field).
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListUptimeCheckConfigsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The total number of uptime check configurations for the project, irrespective of any
   * pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The total number of uptime check configurations for the project, irrespective of any
   * pagination.
   * @param totalSize totalSize or {@code null} for none
   */
  public ListUptimeCheckConfigsResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  /**
   * The returned uptime check configurations.
   * @return value or {@code null} for none
   */
  public java.util.List<UptimeCheckConfig> getUptimeCheckConfigs() {
    return uptimeCheckConfigs;
  }

  /**
   * The returned uptime check configurations.
   * @param uptimeCheckConfigs uptimeCheckConfigs or {@code null} for none
   */
  public ListUptimeCheckConfigsResponse setUptimeCheckConfigs(java.util.List<UptimeCheckConfig> uptimeCheckConfigs) {
    this.uptimeCheckConfigs = uptimeCheckConfigs;
    return this;
  }

  @Override
  public ListUptimeCheckConfigsResponse set(String fieldName, Object value) {
    return (ListUptimeCheckConfigsResponse) super.set(fieldName, value);
  }

  @Override
  public ListUptimeCheckConfigsResponse clone() {
    return (ListUptimeCheckConfigsResponse) super.clone();
  }

}
