/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * A condition type that checks that monitored resources are reporting data. The configuration
 * defines a metric and a set of monitored resources. The predicate is considered in violation when
 * a time series for the specified metric of a monitored resource does not include any data in the
 * specified duration.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MetricAbsence extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the alignment of data points in individual time series as well as how to combine the
   * retrieved time series together (such as when aggregating multiple streams on each resource to a
   * single stream for each resource or when aggregating streams across all members of a group of
   * resrouces). Multiple aggregations are applied in the order specified.This field is similar to
   * the one in the MetricService.ListTimeSeries request. It is advisable to use the ListTimeSeries
   * method when debugging this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Aggregation> aggregations;

  static {
    // hack to force ProGuard to consider Aggregation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Aggregation.class);
  }

  /**
   * The amount of time that a time series must fail to report new data to be considered failing.
   * Currently, only values that are a multiple of a minute--e.g. 60, 120, or 300 seconds--are
   * supported. If an invalid value is given, an error will be returned. The Duration.nanos field is
   * ignored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String duration;

  /**
   * A filter that identifies which time series should be compared with the threshold.The filter is
   * similar to the one that is specified in the MetricService.ListTimeSeries request (that call is
   * useful to verify the time series that will be retrieved / processed) and must specify the
   * metric type and optionally may contain restrictions on resource type, resource labels, and
   * metric labels. This field may not exceed 2048 Unicode characters in length.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String filter;

  /**
   * The number/percent of time series for which the comparison must hold in order for the condition
   * to trigger. If unspecified, then the condition will trigger if the comparison is true for any
   * of the time series that have been identified by filter and aggregations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Trigger trigger;

  /**
   * Specifies the alignment of data points in individual time series as well as how to combine the
   * retrieved time series together (such as when aggregating multiple streams on each resource to a
   * single stream for each resource or when aggregating streams across all members of a group of
   * resrouces). Multiple aggregations are applied in the order specified.This field is similar to
   * the one in the MetricService.ListTimeSeries request. It is advisable to use the ListTimeSeries
   * method when debugging this field.
   * @return value or {@code null} for none
   */
  public java.util.List<Aggregation> getAggregations() {
    return aggregations;
  }

  /**
   * Specifies the alignment of data points in individual time series as well as how to combine the
   * retrieved time series together (such as when aggregating multiple streams on each resource to a
   * single stream for each resource or when aggregating streams across all members of a group of
   * resrouces). Multiple aggregations are applied in the order specified.This field is similar to
   * the one in the MetricService.ListTimeSeries request. It is advisable to use the ListTimeSeries
   * method when debugging this field.
   * @param aggregations aggregations or {@code null} for none
   */
  public MetricAbsence setAggregations(java.util.List<Aggregation> aggregations) {
    this.aggregations = aggregations;
    return this;
  }

  /**
   * The amount of time that a time series must fail to report new data to be considered failing.
   * Currently, only values that are a multiple of a minute--e.g. 60, 120, or 300 seconds--are
   * supported. If an invalid value is given, an error will be returned. The Duration.nanos field is
   * ignored.
   * @return value or {@code null} for none
   */
  public String getDuration() {
    return duration;
  }

  /**
   * The amount of time that a time series must fail to report new data to be considered failing.
   * Currently, only values that are a multiple of a minute--e.g. 60, 120, or 300 seconds--are
   * supported. If an invalid value is given, an error will be returned. The Duration.nanos field is
   * ignored.
   * @param duration duration or {@code null} for none
   */
  public MetricAbsence setDuration(String duration) {
    this.duration = duration;
    return this;
  }

  /**
   * A filter that identifies which time series should be compared with the threshold.The filter is
   * similar to the one that is specified in the MetricService.ListTimeSeries request (that call is
   * useful to verify the time series that will be retrieved / processed) and must specify the
   * metric type and optionally may contain restrictions on resource type, resource labels, and
   * metric labels. This field may not exceed 2048 Unicode characters in length.
   * @return value or {@code null} for none
   */
  public java.lang.String getFilter() {
    return filter;
  }

  /**
   * A filter that identifies which time series should be compared with the threshold.The filter is
   * similar to the one that is specified in the MetricService.ListTimeSeries request (that call is
   * useful to verify the time series that will be retrieved / processed) and must specify the
   * metric type and optionally may contain restrictions on resource type, resource labels, and
   * metric labels. This field may not exceed 2048 Unicode characters in length.
   * @param filter filter or {@code null} for none
   */
  public MetricAbsence setFilter(java.lang.String filter) {
    this.filter = filter;
    return this;
  }

  /**
   * The number/percent of time series for which the comparison must hold in order for the condition
   * to trigger. If unspecified, then the condition will trigger if the comparison is true for any
   * of the time series that have been identified by filter and aggregations.
   * @return value or {@code null} for none
   */
  public Trigger getTrigger() {
    return trigger;
  }

  /**
   * The number/percent of time series for which the comparison must hold in order for the condition
   * to trigger. If unspecified, then the condition will trigger if the comparison is true for any
   * of the time series that have been identified by filter and aggregations.
   * @param trigger trigger or {@code null} for none
   */
  public MetricAbsence setTrigger(Trigger trigger) {
    this.trigger = trigger;
    return this;
  }

  @Override
  public MetricAbsence set(String fieldName, Object value) {
    return (MetricAbsence) super.set(fieldName, value);
  }

  @Override
  public MetricAbsence clone() {
    return (MetricAbsence) super.clone();
  }

}
