/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * A description of a notification channel. The descriptor includes the properties of the channel
 * and the set of labels or fields that must be specified to configure channels of a given type.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NotificationChannelDescriptor extends com.google.api.client.json.GenericJson {

  /**
   * A human-readable description of the notification channel type. The description may include a
   * description of the properties of the channel and pointers to external documentation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * A human-readable name for the notification channel type. This form of the name is suitable for
   * a user interface.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The set of labels that must be defined to identify a particular channel of the corresponding
   * type. Each label includes a description for how that field should be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LabelDescriptor> labels;

  static {
    // hack to force ProGuard to consider LabelDescriptor used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LabelDescriptor.class);
  }

  /**
   * The full REST resource name for this descriptor. The syntax is:
   * projects/[PROJECT_ID]/notificationChannelDescriptors/[TYPE] In the above, [TYPE] is the value
   * of the type field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The tiers that support this notification channel; the project service tier must be one of the
   * supported_tiers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> supportedTiers;

  /**
   * The type of notification channel, such as "email", "sms", etc. Notification channel types are
   * globally unique.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * A human-readable description of the notification channel type. The description may include a
   * description of the properties of the channel and pointers to external documentation.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A human-readable description of the notification channel type. The description may include a
   * description of the properties of the channel and pointers to external documentation.
   * @param description description or {@code null} for none
   */
  public NotificationChannelDescriptor setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * A human-readable name for the notification channel type. This form of the name is suitable for
   * a user interface.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * A human-readable name for the notification channel type. This form of the name is suitable for
   * a user interface.
   * @param displayName displayName or {@code null} for none
   */
  public NotificationChannelDescriptor setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The set of labels that must be defined to identify a particular channel of the corresponding
   * type. Each label includes a description for how that field should be populated.
   * @return value or {@code null} for none
   */
  public java.util.List<LabelDescriptor> getLabels() {
    return labels;
  }

  /**
   * The set of labels that must be defined to identify a particular channel of the corresponding
   * type. Each label includes a description for how that field should be populated.
   * @param labels labels or {@code null} for none
   */
  public NotificationChannelDescriptor setLabels(java.util.List<LabelDescriptor> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The full REST resource name for this descriptor. The syntax is:
   * projects/[PROJECT_ID]/notificationChannelDescriptors/[TYPE] In the above, [TYPE] is the value
   * of the type field.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The full REST resource name for this descriptor. The syntax is:
   * projects/[PROJECT_ID]/notificationChannelDescriptors/[TYPE] In the above, [TYPE] is the value
   * of the type field.
   * @param name name or {@code null} for none
   */
  public NotificationChannelDescriptor setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The tiers that support this notification channel; the project service tier must be one of the
   * supported_tiers.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSupportedTiers() {
    return supportedTiers;
  }

  /**
   * The tiers that support this notification channel; the project service tier must be one of the
   * supported_tiers.
   * @param supportedTiers supportedTiers or {@code null} for none
   */
  public NotificationChannelDescriptor setSupportedTiers(java.util.List<java.lang.String> supportedTiers) {
    this.supportedTiers = supportedTiers;
    return this;
  }

  /**
   * The type of notification channel, such as "email", "sms", etc. Notification channel types are
   * globally unique.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of notification channel, such as "email", "sms", etc. Notification channel types are
   * globally unique.
   * @param type type or {@code null} for none
   */
  public NotificationChannelDescriptor setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public NotificationChannelDescriptor set(String fieldName, Object value) {
    return (NotificationChannelDescriptor) super.set(fieldName, value);
  }

  @Override
  public NotificationChannelDescriptor clone() {
    return (NotificationChannelDescriptor) super.clone();
  }

}
