/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Specifies how many time series must fail a predicate to trigger a condition. If not specified,
 * then a {count: 1} trigger is used.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Trigger extends com.google.api.client.json.GenericJson {

  /**
   * The absolute number of time series that must fail the predicate for the condition to be
   * triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer count;

  /**
   * The percentage of time series that must fail the predicate for the condition to be triggered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double percent;

  /**
   * The absolute number of time series that must fail the predicate for the condition to be
   * triggered.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getCount() {
    return count;
  }

  /**
   * The absolute number of time series that must fail the predicate for the condition to be
   * triggered.
   * @param count count or {@code null} for none
   */
  public Trigger setCount(java.lang.Integer count) {
    this.count = count;
    return this;
  }

  /**
   * The percentage of time series that must fail the predicate for the condition to be triggered.
   * @return value or {@code null} for none
   */
  public java.lang.Double getPercent() {
    return percent;
  }

  /**
   * The percentage of time series that must fail the predicate for the condition to be triggered.
   * @param percent percent or {@code null} for none
   */
  public Trigger setPercent(java.lang.Double percent) {
    this.percent = percent;
    return this;
  }

  @Override
  public Trigger set(String fieldName, Object value) {
    return (Trigger) super.set(fieldName, value);
  }

  @Override
  public Trigger clone() {
    return (Trigger) super.clone();
  }

}
