/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-09-12 at 20:40:18 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.monitoring.v3.model;

/**
 * Contains the region, location, and list of IP addresses where checkers in the location run from.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Stackdriver Monitoring API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UptimeCheckIp extends com.google.api.client.json.GenericJson {

  /**
   * The IP address from which the uptime check originates. This is a full IP address (not an IP
   * address range). Most IP addresses, as of this publication, are in IPv4 format; however, one
   * should not rely on the IP addresses being in IPv4 format indefinitely and should support
   * interpreting this field in either IPv4 or IPv6 format.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ipAddress;

  /**
   * A more specific location within the region that typically encodes a particular city/town/metro
   * (and its containing state/province or country) within the broader umbrella region category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String location;

  /**
   * A broad region category in which the IP address is located.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String region;

  /**
   * The IP address from which the uptime check originates. This is a full IP address (not an IP
   * address range). Most IP addresses, as of this publication, are in IPv4 format; however, one
   * should not rely on the IP addresses being in IPv4 format indefinitely and should support
   * interpreting this field in either IPv4 or IPv6 format.
   * @return value or {@code null} for none
   */
  public java.lang.String getIpAddress() {
    return ipAddress;
  }

  /**
   * The IP address from which the uptime check originates. This is a full IP address (not an IP
   * address range). Most IP addresses, as of this publication, are in IPv4 format; however, one
   * should not rely on the IP addresses being in IPv4 format indefinitely and should support
   * interpreting this field in either IPv4 or IPv6 format.
   * @param ipAddress ipAddress or {@code null} for none
   */
  public UptimeCheckIp setIpAddress(java.lang.String ipAddress) {
    this.ipAddress = ipAddress;
    return this;
  }

  /**
   * A more specific location within the region that typically encodes a particular city/town/metro
   * (and its containing state/province or country) within the broader umbrella region category.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocation() {
    return location;
  }

  /**
   * A more specific location within the region that typically encodes a particular city/town/metro
   * (and its containing state/province or country) within the broader umbrella region category.
   * @param location location or {@code null} for none
   */
  public UptimeCheckIp setLocation(java.lang.String location) {
    this.location = location;
    return this;
  }

  /**
   * A broad region category in which the IP address is located.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegion() {
    return region;
  }

  /**
   * A broad region category in which the IP address is located.
   * @param region region or {@code null} for none
   */
  public UptimeCheckIp setRegion(java.lang.String region) {
    this.region = region;
    return this;
  }

  @Override
  public UptimeCheckIp set(String fieldName, Object value) {
    return (UptimeCheckIp) super.set(fieldName, value);
  }

  @Override
  public UptimeCheckIp clone() {
    return (UptimeCheckIp) super.clone();
  }

}
