/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1;

/**
 * Service definition for AIPlatformNotebooks (v1).
 *
 * <p>
 * Notebooks API is used to manage notebook resources in Google Cloud.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://cloud.google.com/notebooks/docs/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link AIPlatformNotebooksRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class AIPlatformNotebooks extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Notebooks API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://notebooks.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://notebooks.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public AIPlatformNotebooks(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  AIPlatformNotebooks(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Projects collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
   *   {@code AIPlatformNotebooks.Projects.List request = notebooks.projects().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Projects projects() {
    return new Projects();
  }

  /**
   * The "projects" collection of methods.
   */
  public class Projects {

    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
     *   {@code AIPlatformNotebooks.Locations.List request = notebooks.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Gets information about a location.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the notebooks server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name Resource name for the location.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Location> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

        /**
         * Gets information about a location.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the notebooks server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name for the location.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name for the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name for the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name for the location. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Lists information about the supported locations for this service.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the notebooks server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param name The resource that owns the locations collection, if applicable.
       * @return the request
       */
      public List list(java.lang.String name) throws java.io.IOException {
        List result = new List(name);
        initialize(result);
        return result;
      }

      public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListLocationsResponse> {

        private static final String REST_PATH = "v1/{+name}/locations";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^projects/[^/]+$");

        /**
         * Lists information about the supported locations for this service.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the notebooks server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource that owns the locations collection, if applicable.
         * @since 1.13
         */
        protected List(java.lang.String name) {
          super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource that owns the locations collection, if applicable. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource that owns the locations collection, if applicable.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource that owns the locations collection, if applicable. */
        public List setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^projects/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A filter to narrow down results to a preferred subset. The filtering language accepts strings like
       "displayName=tokyo", and is documented in more detail in [AIP-160](https://google.aip.dev/160).
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A filter to narrow down results to a preferred subset. The filtering language accepts
         * strings like "displayName=tokyo", and is documented in more detail in
         * [AIP-160](https://google.aip.dev/160).
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of results to return. If not set, the service selects a default.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /** The maximum number of results to return. If not set, the service selects a default. */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token received from the `next_page_token` field in the response. Send that page token to
       receive the subsequent page.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token received from the `next_page_token` field in the response. Send that page
         * token to receive the subsequent page.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Environments collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Environments.List request = notebooks.environments().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Environments environments() {
        return new Environments();
      }

      /**
       * The "environments" collection of methods.
       */
      public class Environments {

        /**
         * Creates a new Environment.
         *
         * Create a request for the method "environments.create".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.Environment}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Environment content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/environments";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new Environment.
           *
           * Create a request for the method "environments.create".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.Environment}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Environment content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `projects/{project_id}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Required. User-defined unique ID of this environment. The `environment_id` must be 1 to
           * 63 characters long and contain only lowercase letters, numeric characters, and dashes.
           * The first character must be a lowercase letter and the last character cannot be a dash.
           */
          @com.google.api.client.util.Key
          private java.lang.String environmentId;

          /** Required. User-defined unique ID of this environment. The `environment_id` must be 1 to 63
         characters long and contain only lowercase letters, numeric characters, and dashes. The first
         character must be a lowercase letter and the last character cannot be a dash.
           */
          public java.lang.String getEnvironmentId() {
            return environmentId;
          }

          /**
           * Required. User-defined unique ID of this environment. The `environment_id` must be 1 to
           * 63 characters long and contain only lowercase letters, numeric characters, and dashes.
           * The first character must be a lowercase letter and the last character cannot be a dash.
           */
          public Create setEnvironmentId(java.lang.String environmentId) {
            this.environmentId = environmentId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a single Environment.
         *
         * Create a request for the method "environments.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/environments/[^/]+$");

          /**
           * Deletes a single Environment.
           *
           * Create a request for the method "environments.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/environments/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/environments/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of a single Environment.
         *
         * Create a request for the method "environments.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Environment> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/environments/[^/]+$");

          /**
           * Gets details of a single Environment.
           *
           * Create a request for the method "environments.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Environment.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/environments/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/environments/{environment_id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/environments/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists environments in a project.
         *
         * Create a request for the method "environments.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `projects/{project_id}/locations/{location}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListEnvironmentsResponse> {

          private static final String REST_PATH = "v1/{+parent}/environments";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists environments in a project.
           *
           * Create a request for the method "environments.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `projects/{project_id}/locations/{location}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListEnvironmentsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `projects/{project_id}/locations/{location}` */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Maximum return size of the list call. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum return size of the list call.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum return size of the list call. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A previous returned page token that can be used to continue listing from the last result.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Executions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Executions.List request = notebooks.executions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Executions executions() {
        return new Executions();
      }

      /**
       * The "executions" collection of methods.
       */
      public class Executions {

        /**
         * Creates a new Execution in a given project and location.
         *
         * Create a request for the method "executions.create".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.Execution}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Execution content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/executions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new Execution in a given project and location.
           *
           * Create a request for the method "executions.create".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.Execution}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Execution content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. User-defined unique ID of this execution. */
          @com.google.api.client.util.Key
          private java.lang.String executionId;

          /** Required. User-defined unique ID of this execution.
           */
          public java.lang.String getExecutionId() {
            return executionId;
          }

          /** Required. User-defined unique ID of this execution. */
          public Create setExecutionId(java.lang.String executionId) {
            this.executionId = executionId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes execution
         *
         * Create a request for the method "executions.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/executions/[^/]+$");

          /**
           * Deletes execution
           *
           * Create a request for the method "executions.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/executions/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/executions/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of executions
         *
         * Create a request for the method "executions.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Execution> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/executions/[^/]+$");

          /**
           * Gets details of executions
           *
           * Create a request for the method "executions.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Execution.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/executions/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format:
           * `projects/{project_id}/locations/{location}/executions/{execution_id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/executions/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists executions in a given project and location
         *
         * Create a request for the method "executions.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListExecutionsResponse> {

          private static final String REST_PATH = "v1/{+parent}/executions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists executions in a given project and location
           *
           * Create a request for the method "executions.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListExecutionsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Filter applied to resulting executions. Currently only supports filtering executions by
           * a specified schedule_id. Format: `schedule_id=`
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Filter applied to resulting executions. Currently only supports filtering executions by a specified
         schedule_id. Format: `schedule_id=`
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * Filter applied to resulting executions. Currently only supports filtering executions by
           * a specified schedule_id. Format: `schedule_id=`
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** Sort by field. */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Sort by field.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /** Sort by field. */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /** Maximum return size of the list call. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum return size of the list call.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum return size of the list call. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A previous returned page token that can be used to continue listing from the last result.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Instances collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Instances.List request = notebooks.instances().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Instances instances() {
        return new Instances();
      }

      /**
       * The "instances" collection of methods.
       */
      public class Instances {

        /**
         * Creates a new Instance in a given project and location.
         *
         * Create a request for the method "instances.create".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.Instance}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Instance content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/instances";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new Instance in a given project and location.
           *
           * Create a request for the method "instances.create".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.Instance}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Instance content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. User-defined unique ID of this instance. */
          @com.google.api.client.util.Key
          private java.lang.String instanceId;

          /** Required. User-defined unique ID of this instance.
           */
          public java.lang.String getInstanceId() {
            return instanceId;
          }

          /** Required. User-defined unique ID of this instance. */
          public Create setInstanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a single Instance.
         *
         * Create a request for the method "instances.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Deletes a single Instance.
           *
           * Create a request for the method "instances.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of a single Instance.
         *
         * Create a request for the method "instances.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Instance> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Gets details of a single Instance.
           *
           * Create a request for the method "instances.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Instance.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "instances.getIamPolicy".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "instances.getIamPolicy".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The maximum policy version that will be used to format the policy. Valid
           * values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests
           * for policies with any conditional role bindings must specify version 3. Policies with
           * no conditional role bindings may specify any valid value or leave the field unset. The
           * policy in the response might use the policy version that you specified, or it might use
           * a lower policy version. For example, if you specify version 3, but the policy has no
           * conditional role bindings, the response uses version 1. To learn which resources
           * support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
         and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
         conditional role bindings must specify version 3. Policies with no conditional role bindings may
         specify any valid value or leave the field unset. The policy in the response might use the policy
         version that you specified, or it might use a lower policy version. For example, if you specify
         version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
         which resources support conditions in their IAM policies, see the [IAM
         documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The maximum policy version that will be used to format the policy. Valid
           * values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests
           * for policies with any conditional role bindings must specify version 3. Policies with
           * no conditional role bindings may specify any valid value or leave the field unset. The
           * policy in the response might use the policy version that you specified, or it might use
           * a lower policy version. For example, if you specify version 3, but the policy has no
           * conditional role bindings, the response uses version 1. To learn which resources
           * support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Check if a notebook instance is healthy.
         *
         * Create a request for the method "instances.getInstanceHealth".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link GetInstanceHealth#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @return the request
         */
        public GetInstanceHealth getInstanceHealth(java.lang.String name) throws java.io.IOException {
          GetInstanceHealth result = new GetInstanceHealth(name);
          initialize(result);
          return result;
        }

        public class GetInstanceHealth extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.GetInstanceHealthResponse> {

          private static final String REST_PATH = "v1/{+name}:getInstanceHealth";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Check if a notebook instance is healthy.
           *
           * Create a request for the method "instances.getInstanceHealth".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link GetInstanceHealth#execute()} method to invoke the remote
           * operation. <p> {@link GetInstanceHealth#initialize(com.google.api.client.googleapis.services.Ab
           * stractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @since 1.13
           */
          protected GetInstanceHealth(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.GetInstanceHealthResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetInstanceHealth set$Xgafv(java.lang.String $Xgafv) {
            return (GetInstanceHealth) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetInstanceHealth setAccessToken(java.lang.String accessToken) {
            return (GetInstanceHealth) super.setAccessToken(accessToken);
          }

          @Override
          public GetInstanceHealth setAlt(java.lang.String alt) {
            return (GetInstanceHealth) super.setAlt(alt);
          }

          @Override
          public GetInstanceHealth setCallback(java.lang.String callback) {
            return (GetInstanceHealth) super.setCallback(callback);
          }

          @Override
          public GetInstanceHealth setFields(java.lang.String fields) {
            return (GetInstanceHealth) super.setFields(fields);
          }

          @Override
          public GetInstanceHealth setKey(java.lang.String key) {
            return (GetInstanceHealth) super.setKey(key);
          }

          @Override
          public GetInstanceHealth setOauthToken(java.lang.String oauthToken) {
            return (GetInstanceHealth) super.setOauthToken(oauthToken);
          }

          @Override
          public GetInstanceHealth setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetInstanceHealth) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetInstanceHealth setQuotaUser(java.lang.String quotaUser) {
            return (GetInstanceHealth) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetInstanceHealth setUploadType(java.lang.String uploadType) {
            return (GetInstanceHealth) super.setUploadType(uploadType);
          }

          @Override
          public GetInstanceHealth setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetInstanceHealth) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public GetInstanceHealth setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public GetInstanceHealth set(String parameterName, Object value) {
            return (GetInstanceHealth) super.set(parameterName, value);
          }
        }
        /**
         * Check if a notebook instance is upgradable.
         *
         * Create a request for the method "instances.isUpgradeable".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link IsUpgradeable#execute()} method to invoke the remote operation.
         *
         * @param notebookInstance Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @return the request
         */
        public IsUpgradeable isUpgradeable(java.lang.String notebookInstance) throws java.io.IOException {
          IsUpgradeable result = new IsUpgradeable(notebookInstance);
          initialize(result);
          return result;
        }

        public class IsUpgradeable extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.IsInstanceUpgradeableResponse> {

          private static final String REST_PATH = "v1/{+notebookInstance}:isUpgradeable";

          private final java.util.regex.Pattern NOTEBOOK_INSTANCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Check if a notebook instance is upgradable.
           *
           * Create a request for the method "instances.isUpgradeable".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link IsUpgradeable#execute()} method to invoke the remote
           * operation. <p> {@link IsUpgradeable#initialize(com.google.api.client.googleapis.services.Abstra
           * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param notebookInstance Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @since 1.13
           */
          protected IsUpgradeable(java.lang.String notebookInstance) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.IsInstanceUpgradeableResponse.class);
            this.notebookInstance = com.google.api.client.util.Preconditions.checkNotNull(notebookInstance, "Required parameter notebookInstance must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(),
                  "Parameter notebookInstance must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public IsUpgradeable set$Xgafv(java.lang.String $Xgafv) {
            return (IsUpgradeable) super.set$Xgafv($Xgafv);
          }

          @Override
          public IsUpgradeable setAccessToken(java.lang.String accessToken) {
            return (IsUpgradeable) super.setAccessToken(accessToken);
          }

          @Override
          public IsUpgradeable setAlt(java.lang.String alt) {
            return (IsUpgradeable) super.setAlt(alt);
          }

          @Override
          public IsUpgradeable setCallback(java.lang.String callback) {
            return (IsUpgradeable) super.setCallback(callback);
          }

          @Override
          public IsUpgradeable setFields(java.lang.String fields) {
            return (IsUpgradeable) super.setFields(fields);
          }

          @Override
          public IsUpgradeable setKey(java.lang.String key) {
            return (IsUpgradeable) super.setKey(key);
          }

          @Override
          public IsUpgradeable setOauthToken(java.lang.String oauthToken) {
            return (IsUpgradeable) super.setOauthToken(oauthToken);
          }

          @Override
          public IsUpgradeable setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (IsUpgradeable) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public IsUpgradeable setQuotaUser(java.lang.String quotaUser) {
            return (IsUpgradeable) super.setQuotaUser(quotaUser);
          }

          @Override
          public IsUpgradeable setUploadType(java.lang.String uploadType) {
            return (IsUpgradeable) super.setUploadType(uploadType);
          }

          @Override
          public IsUpgradeable setUploadProtocol(java.lang.String uploadProtocol) {
            return (IsUpgradeable) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String notebookInstance;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getNotebookInstance() {
            return notebookInstance;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public IsUpgradeable setNotebookInstance(java.lang.String notebookInstance) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(),
                  "Parameter notebookInstance must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.notebookInstance = notebookInstance;
            return this;
          }

          /**
           * Optional. The optional UpgradeType. Setting this field will search for additional
           * compute images to upgrade this instance.
           */
          @com.google.api.client.util.Key
          private java.lang.String type;

          /** Optional. The optional UpgradeType. Setting this field will search for additional compute images to
         upgrade this instance.
           */
          public java.lang.String getType() {
            return type;
          }

          /**
           * Optional. The optional UpgradeType. Setting this field will search for additional
           * compute images to upgrade this instance.
           */
          public IsUpgradeable setType(java.lang.String type) {
            this.type = type;
            return this;
          }

          @Override
          public IsUpgradeable set(String parameterName, Object value) {
            return (IsUpgradeable) super.set(parameterName, value);
          }
        }
        /**
         * Lists instances in a given project and location.
         *
         * Create a request for the method "instances.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListInstancesResponse> {

          private static final String REST_PATH = "v1/{+parent}/instances";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists instances in a given project and location.
           *
           * Create a request for the method "instances.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListInstancesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Maximum return size of the list call. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum return size of the list call.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum return size of the list call. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A previous returned page token that can be used to continue listing from the last result.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Registers an existing legacy notebook instance to the Notebooks API server. Legacy instances are
         * instances created with the legacy Compute Engine calls. They are not manageable by the Notebooks
         * API out of the box. This call makes these instances manageable by the Notebooks API.
         *
         * Create a request for the method "instances.register".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Register#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.RegisterInstanceRequest}
         * @return the request
         */
        public Register register(java.lang.String parent, com.google.api.services.notebooks.v1.model.RegisterInstanceRequest content) throws java.io.IOException {
          Register result = new Register(parent, content);
          initialize(result);
          return result;
        }

        public class Register extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/instances:register";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Registers an existing legacy notebook instance to the Notebooks API server. Legacy instances
           * are instances created with the legacy Compute Engine calls. They are not manageable by the
           * Notebooks API out of the box. This call makes these instances manageable by the Notebooks API.
           *
           * Create a request for the method "instances.register".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Register#execute()} method to invoke the remote operation.
           * <p> {@link
           * Register#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.RegisterInstanceRequest}
           * @since 1.13
           */
          protected Register(java.lang.String parent, com.google.api.services.notebooks.v1.model.RegisterInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Register set$Xgafv(java.lang.String $Xgafv) {
            return (Register) super.set$Xgafv($Xgafv);
          }

          @Override
          public Register setAccessToken(java.lang.String accessToken) {
            return (Register) super.setAccessToken(accessToken);
          }

          @Override
          public Register setAlt(java.lang.String alt) {
            return (Register) super.setAlt(alt);
          }

          @Override
          public Register setCallback(java.lang.String callback) {
            return (Register) super.setCallback(callback);
          }

          @Override
          public Register setFields(java.lang.String fields) {
            return (Register) super.setFields(fields);
          }

          @Override
          public Register setKey(java.lang.String key) {
            return (Register) super.setKey(key);
          }

          @Override
          public Register setOauthToken(java.lang.String oauthToken) {
            return (Register) super.setOauthToken(oauthToken);
          }

          @Override
          public Register setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Register) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Register setQuotaUser(java.lang.String quotaUser) {
            return (Register) super.setQuotaUser(quotaUser);
          }

          @Override
          public Register setUploadType(java.lang.String uploadType) {
            return (Register) super.setUploadType(uploadType);
          }

          @Override
          public Register setUploadProtocol(java.lang.String uploadProtocol) {
            return (Register) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public Register setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Register set(String parameterName, Object value) {
            return (Register) super.set(parameterName, value);
          }
        }
        /**
         * Allows notebook instances to report their latest instance information to the Notebooks API
         * server. The server will merge the reported information to the instance metadata store. Do not use
         * this method directly.
         *
         * Create a request for the method "instances.report".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Report#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.ReportInstanceInfoRequest}
         * @return the request
         */
        public Report report(java.lang.String name, com.google.api.services.notebooks.v1.model.ReportInstanceInfoRequest content) throws java.io.IOException {
          Report result = new Report(name, content);
          initialize(result);
          return result;
        }

        public class Report extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:report";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Allows notebook instances to report their latest instance information to the Notebooks API
           * server. The server will merge the reported information to the instance metadata store. Do not
           * use this method directly.
           *
           * Create a request for the method "instances.report".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Report#execute()} method to invoke the remote operation.
           * <p> {@link
           * Report#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.ReportInstanceInfoRequest}
           * @since 1.13
           */
          protected Report(java.lang.String name, com.google.api.services.notebooks.v1.model.ReportInstanceInfoRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Report set$Xgafv(java.lang.String $Xgafv) {
            return (Report) super.set$Xgafv($Xgafv);
          }

          @Override
          public Report setAccessToken(java.lang.String accessToken) {
            return (Report) super.setAccessToken(accessToken);
          }

          @Override
          public Report setAlt(java.lang.String alt) {
            return (Report) super.setAlt(alt);
          }

          @Override
          public Report setCallback(java.lang.String callback) {
            return (Report) super.setCallback(callback);
          }

          @Override
          public Report setFields(java.lang.String fields) {
            return (Report) super.setFields(fields);
          }

          @Override
          public Report setKey(java.lang.String key) {
            return (Report) super.setKey(key);
          }

          @Override
          public Report setOauthToken(java.lang.String oauthToken) {
            return (Report) super.setOauthToken(oauthToken);
          }

          @Override
          public Report setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Report) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Report setQuotaUser(java.lang.String quotaUser) {
            return (Report) super.setQuotaUser(quotaUser);
          }

          @Override
          public Report setUploadType(java.lang.String uploadType) {
            return (Report) super.setUploadType(uploadType);
          }

          @Override
          public Report setUploadProtocol(java.lang.String uploadProtocol) {
            return (Report) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Report setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Report set(String parameterName, Object value) {
            return (Report) super.set(parameterName, value);
          }
        }
        /**
         * Resets a notebook instance.
         *
         * Create a request for the method "instances.reset".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.ResetInstanceRequest}
         * @return the request
         */
        public Reset reset(java.lang.String name, com.google.api.services.notebooks.v1.model.ResetInstanceRequest content) throws java.io.IOException {
          Reset result = new Reset(name, content);
          initialize(result);
          return result;
        }

        public class Reset extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:reset";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Resets a notebook instance.
           *
           * Create a request for the method "instances.reset".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
           * <p> {@link
           * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.ResetInstanceRequest}
           * @since 1.13
           */
          protected Reset(java.lang.String name, com.google.api.services.notebooks.v1.model.ResetInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Reset set$Xgafv(java.lang.String $Xgafv) {
            return (Reset) super.set$Xgafv($Xgafv);
          }

          @Override
          public Reset setAccessToken(java.lang.String accessToken) {
            return (Reset) super.setAccessToken(accessToken);
          }

          @Override
          public Reset setAlt(java.lang.String alt) {
            return (Reset) super.setAlt(alt);
          }

          @Override
          public Reset setCallback(java.lang.String callback) {
            return (Reset) super.setCallback(callback);
          }

          @Override
          public Reset setFields(java.lang.String fields) {
            return (Reset) super.setFields(fields);
          }

          @Override
          public Reset setKey(java.lang.String key) {
            return (Reset) super.setKey(key);
          }

          @Override
          public Reset setOauthToken(java.lang.String oauthToken) {
            return (Reset) super.setOauthToken(oauthToken);
          }

          @Override
          public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Reset) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Reset setQuotaUser(java.lang.String quotaUser) {
            return (Reset) super.setQuotaUser(quotaUser);
          }

          @Override
          public Reset setUploadType(java.lang.String uploadType) {
            return (Reset) super.setUploadType(uploadType);
          }

          @Override
          public Reset setUploadProtocol(java.lang.String uploadProtocol) {
            return (Reset) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Reset setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Reset set(String parameterName, Object value) {
            return (Reset) super.set(parameterName, value);
          }
        }
        /**
         * Rollbacks a notebook instance to the previous version.
         *
         * Create a request for the method "instances.rollback".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.RollbackInstanceRequest}
         * @return the request
         */
        public Rollback rollback(java.lang.String name, com.google.api.services.notebooks.v1.model.RollbackInstanceRequest content) throws java.io.IOException {
          Rollback result = new Rollback(name, content);
          initialize(result);
          return result;
        }

        public class Rollback extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:rollback";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Rollbacks a notebook instance to the previous version.
           *
           * Create a request for the method "instances.rollback".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Rollback#execute()} method to invoke the remote operation.
           * <p> {@link
           * Rollback#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.RollbackInstanceRequest}
           * @since 1.13
           */
          protected Rollback(java.lang.String name, com.google.api.services.notebooks.v1.model.RollbackInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Rollback set$Xgafv(java.lang.String $Xgafv) {
            return (Rollback) super.set$Xgafv($Xgafv);
          }

          @Override
          public Rollback setAccessToken(java.lang.String accessToken) {
            return (Rollback) super.setAccessToken(accessToken);
          }

          @Override
          public Rollback setAlt(java.lang.String alt) {
            return (Rollback) super.setAlt(alt);
          }

          @Override
          public Rollback setCallback(java.lang.String callback) {
            return (Rollback) super.setCallback(callback);
          }

          @Override
          public Rollback setFields(java.lang.String fields) {
            return (Rollback) super.setFields(fields);
          }

          @Override
          public Rollback setKey(java.lang.String key) {
            return (Rollback) super.setKey(key);
          }

          @Override
          public Rollback setOauthToken(java.lang.String oauthToken) {
            return (Rollback) super.setOauthToken(oauthToken);
          }

          @Override
          public Rollback setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Rollback) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Rollback setQuotaUser(java.lang.String quotaUser) {
            return (Rollback) super.setQuotaUser(quotaUser);
          }

          @Override
          public Rollback setUploadType(java.lang.String uploadType) {
            return (Rollback) super.setUploadType(uploadType);
          }

          @Override
          public Rollback setUploadProtocol(java.lang.String uploadProtocol) {
            return (Rollback) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Rollback setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Rollback set(String parameterName, Object value) {
            return (Rollback) super.set(parameterName, value);
          }
        }
        /**
         * Updates the guest accelerators of a single Instance.
         *
         * Create a request for the method "instances.setAccelerator".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link SetAccelerator#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceAcceleratorRequest}
         * @return the request
         */
        public SetAccelerator setAccelerator(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceAcceleratorRequest content) throws java.io.IOException {
          SetAccelerator result = new SetAccelerator(name, content);
          initialize(result);
          return result;
        }

        public class SetAccelerator extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setAccelerator";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Updates the guest accelerators of a single Instance.
           *
           * Create a request for the method "instances.setAccelerator".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link SetAccelerator#execute()} method to invoke the remote
           * operation. <p> {@link SetAccelerator#initialize(com.google.api.client.googleapis.services.Abstr
           * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceAcceleratorRequest}
           * @since 1.13
           */
          protected SetAccelerator(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceAcceleratorRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public SetAccelerator set$Xgafv(java.lang.String $Xgafv) {
            return (SetAccelerator) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetAccelerator setAccessToken(java.lang.String accessToken) {
            return (SetAccelerator) super.setAccessToken(accessToken);
          }

          @Override
          public SetAccelerator setAlt(java.lang.String alt) {
            return (SetAccelerator) super.setAlt(alt);
          }

          @Override
          public SetAccelerator setCallback(java.lang.String callback) {
            return (SetAccelerator) super.setCallback(callback);
          }

          @Override
          public SetAccelerator setFields(java.lang.String fields) {
            return (SetAccelerator) super.setFields(fields);
          }

          @Override
          public SetAccelerator setKey(java.lang.String key) {
            return (SetAccelerator) super.setKey(key);
          }

          @Override
          public SetAccelerator setOauthToken(java.lang.String oauthToken) {
            return (SetAccelerator) super.setOauthToken(oauthToken);
          }

          @Override
          public SetAccelerator setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetAccelerator) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetAccelerator setQuotaUser(java.lang.String quotaUser) {
            return (SetAccelerator) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetAccelerator setUploadType(java.lang.String uploadType) {
            return (SetAccelerator) super.setUploadType(uploadType);
          }

          @Override
          public SetAccelerator setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetAccelerator) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public SetAccelerator setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetAccelerator set(String parameterName, Object value) {
            return (SetAccelerator) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "instances.setIamPolicy".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.notebooks.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.notebooks.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "instances.setIamPolicy".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.notebooks.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.notebooks.v1.model.SetIamPolicyRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Replaces all the labels of an Instance.
         *
         * Create a request for the method "instances.setLabels".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link SetLabels#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceLabelsRequest}
         * @return the request
         */
        public SetLabels setLabels(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceLabelsRequest content) throws java.io.IOException {
          SetLabels result = new SetLabels(name, content);
          initialize(result);
          return result;
        }

        public class SetLabels extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setLabels";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Replaces all the labels of an Instance.
           *
           * Create a request for the method "instances.setLabels".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link SetLabels#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetLabels#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceLabelsRequest}
           * @since 1.13
           */
          protected SetLabels(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceLabelsRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public SetLabels set$Xgafv(java.lang.String $Xgafv) {
            return (SetLabels) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetLabels setAccessToken(java.lang.String accessToken) {
            return (SetLabels) super.setAccessToken(accessToken);
          }

          @Override
          public SetLabels setAlt(java.lang.String alt) {
            return (SetLabels) super.setAlt(alt);
          }

          @Override
          public SetLabels setCallback(java.lang.String callback) {
            return (SetLabels) super.setCallback(callback);
          }

          @Override
          public SetLabels setFields(java.lang.String fields) {
            return (SetLabels) super.setFields(fields);
          }

          @Override
          public SetLabels setKey(java.lang.String key) {
            return (SetLabels) super.setKey(key);
          }

          @Override
          public SetLabels setOauthToken(java.lang.String oauthToken) {
            return (SetLabels) super.setOauthToken(oauthToken);
          }

          @Override
          public SetLabels setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetLabels) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetLabels setQuotaUser(java.lang.String quotaUser) {
            return (SetLabels) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetLabels setUploadType(java.lang.String uploadType) {
            return (SetLabels) super.setUploadType(uploadType);
          }

          @Override
          public SetLabels setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetLabels) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public SetLabels setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetLabels set(String parameterName, Object value) {
            return (SetLabels) super.set(parameterName, value);
          }
        }
        /**
         * Updates the machine type of a single Instance.
         *
         * Create a request for the method "instances.setMachineType".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link SetMachineType#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceMachineTypeRequest}
         * @return the request
         */
        public SetMachineType setMachineType(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceMachineTypeRequest content) throws java.io.IOException {
          SetMachineType result = new SetMachineType(name, content);
          initialize(result);
          return result;
        }

        public class SetMachineType extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:setMachineType";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Updates the machine type of a single Instance.
           *
           * Create a request for the method "instances.setMachineType".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link SetMachineType#execute()} method to invoke the remote
           * operation. <p> {@link SetMachineType#initialize(com.google.api.client.googleapis.services.Abstr
           * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.SetInstanceMachineTypeRequest}
           * @since 1.13
           */
          protected SetMachineType(java.lang.String name, com.google.api.services.notebooks.v1.model.SetInstanceMachineTypeRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public SetMachineType set$Xgafv(java.lang.String $Xgafv) {
            return (SetMachineType) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetMachineType setAccessToken(java.lang.String accessToken) {
            return (SetMachineType) super.setAccessToken(accessToken);
          }

          @Override
          public SetMachineType setAlt(java.lang.String alt) {
            return (SetMachineType) super.setAlt(alt);
          }

          @Override
          public SetMachineType setCallback(java.lang.String callback) {
            return (SetMachineType) super.setCallback(callback);
          }

          @Override
          public SetMachineType setFields(java.lang.String fields) {
            return (SetMachineType) super.setFields(fields);
          }

          @Override
          public SetMachineType setKey(java.lang.String key) {
            return (SetMachineType) super.setKey(key);
          }

          @Override
          public SetMachineType setOauthToken(java.lang.String oauthToken) {
            return (SetMachineType) super.setOauthToken(oauthToken);
          }

          @Override
          public SetMachineType setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetMachineType) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetMachineType setQuotaUser(java.lang.String quotaUser) {
            return (SetMachineType) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetMachineType setUploadType(java.lang.String uploadType) {
            return (SetMachineType) super.setUploadType(uploadType);
          }

          @Override
          public SetMachineType setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetMachineType) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public SetMachineType setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public SetMachineType set(String parameterName, Object value) {
            return (SetMachineType) super.set(parameterName, value);
          }
        }
        /**
         * Starts a notebook instance.
         *
         * Create a request for the method "instances.start".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Start#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.StartInstanceRequest}
         * @return the request
         */
        public Start start(java.lang.String name, com.google.api.services.notebooks.v1.model.StartInstanceRequest content) throws java.io.IOException {
          Start result = new Start(name, content);
          initialize(result);
          return result;
        }

        public class Start extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:start";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Starts a notebook instance.
           *
           * Create a request for the method "instances.start".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Start#execute()} method to invoke the remote operation.
           * <p> {@link
           * Start#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.StartInstanceRequest}
           * @since 1.13
           */
          protected Start(java.lang.String name, com.google.api.services.notebooks.v1.model.StartInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Start set$Xgafv(java.lang.String $Xgafv) {
            return (Start) super.set$Xgafv($Xgafv);
          }

          @Override
          public Start setAccessToken(java.lang.String accessToken) {
            return (Start) super.setAccessToken(accessToken);
          }

          @Override
          public Start setAlt(java.lang.String alt) {
            return (Start) super.setAlt(alt);
          }

          @Override
          public Start setCallback(java.lang.String callback) {
            return (Start) super.setCallback(callback);
          }

          @Override
          public Start setFields(java.lang.String fields) {
            return (Start) super.setFields(fields);
          }

          @Override
          public Start setKey(java.lang.String key) {
            return (Start) super.setKey(key);
          }

          @Override
          public Start setOauthToken(java.lang.String oauthToken) {
            return (Start) super.setOauthToken(oauthToken);
          }

          @Override
          public Start setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Start) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Start setQuotaUser(java.lang.String quotaUser) {
            return (Start) super.setQuotaUser(quotaUser);
          }

          @Override
          public Start setUploadType(java.lang.String uploadType) {
            return (Start) super.setUploadType(uploadType);
          }

          @Override
          public Start setUploadProtocol(java.lang.String uploadProtocol) {
            return (Start) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Start setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Start set(String parameterName, Object value) {
            return (Start) super.set(parameterName, value);
          }
        }
        /**
         * Stops a notebook instance.
         *
         * Create a request for the method "instances.stop".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.StopInstanceRequest}
         * @return the request
         */
        public Stop stop(java.lang.String name, com.google.api.services.notebooks.v1.model.StopInstanceRequest content) throws java.io.IOException {
          Stop result = new Stop(name, content);
          initialize(result);
          return result;
        }

        public class Stop extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:stop";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Stops a notebook instance.
           *
           * Create a request for the method "instances.stop".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p>
           * {@link Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.StopInstanceRequest}
           * @since 1.13
           */
          protected Stop(java.lang.String name, com.google.api.services.notebooks.v1.model.StopInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Stop set$Xgafv(java.lang.String $Xgafv) {
            return (Stop) super.set$Xgafv($Xgafv);
          }

          @Override
          public Stop setAccessToken(java.lang.String accessToken) {
            return (Stop) super.setAccessToken(accessToken);
          }

          @Override
          public Stop setAlt(java.lang.String alt) {
            return (Stop) super.setAlt(alt);
          }

          @Override
          public Stop setCallback(java.lang.String callback) {
            return (Stop) super.setCallback(callback);
          }

          @Override
          public Stop setFields(java.lang.String fields) {
            return (Stop) super.setFields(fields);
          }

          @Override
          public Stop setKey(java.lang.String key) {
            return (Stop) super.setKey(key);
          }

          @Override
          public Stop setOauthToken(java.lang.String oauthToken) {
            return (Stop) super.setOauthToken(oauthToken);
          }

          @Override
          public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Stop) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Stop setQuotaUser(java.lang.String quotaUser) {
            return (Stop) super.setQuotaUser(quotaUser);
          }

          @Override
          public Stop setUploadType(java.lang.String uploadType) {
            return (Stop) super.setUploadType(uploadType);
          }

          @Override
          public Stop setUploadProtocol(java.lang.String uploadProtocol) {
            return (Stop) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Stop setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Stop set(String parameterName, Object value) {
            return (Stop) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
         * designed to be used for building permission-aware UIs and command-line tools, not for
         * authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "instances.testIamPermissions".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
           * operation is designed to be used for building permission-aware UIs and command-line tools, not
           * for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "instances.testIamPermissions".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }
        /**
         * Update Notebook Instance configurations.
         *
         * Create a request for the method "instances.updateConfig".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link UpdateConfig#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateInstanceConfigRequest}
         * @return the request
         */
        public UpdateConfig updateConfig(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateInstanceConfigRequest content) throws java.io.IOException {
          UpdateConfig result = new UpdateConfig(name, content);
          initialize(result);
          return result;
        }

        public class UpdateConfig extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:updateConfig";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Update Notebook Instance configurations.
           *
           * Create a request for the method "instances.updateConfig".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link UpdateConfig#execute()} method to invoke the remote
           * operation. <p> {@link
           * UpdateConfig#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateInstanceConfigRequest}
           * @since 1.13
           */
          protected UpdateConfig(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateInstanceConfigRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public UpdateConfig set$Xgafv(java.lang.String $Xgafv) {
            return (UpdateConfig) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpdateConfig setAccessToken(java.lang.String accessToken) {
            return (UpdateConfig) super.setAccessToken(accessToken);
          }

          @Override
          public UpdateConfig setAlt(java.lang.String alt) {
            return (UpdateConfig) super.setAlt(alt);
          }

          @Override
          public UpdateConfig setCallback(java.lang.String callback) {
            return (UpdateConfig) super.setCallback(callback);
          }

          @Override
          public UpdateConfig setFields(java.lang.String fields) {
            return (UpdateConfig) super.setFields(fields);
          }

          @Override
          public UpdateConfig setKey(java.lang.String key) {
            return (UpdateConfig) super.setKey(key);
          }

          @Override
          public UpdateConfig setOauthToken(java.lang.String oauthToken) {
            return (UpdateConfig) super.setOauthToken(oauthToken);
          }

          @Override
          public UpdateConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpdateConfig) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpdateConfig setQuotaUser(java.lang.String quotaUser) {
            return (UpdateConfig) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpdateConfig setUploadType(java.lang.String uploadType) {
            return (UpdateConfig) super.setUploadType(uploadType);
          }

          @Override
          public UpdateConfig setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpdateConfig) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public UpdateConfig setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpdateConfig set(String parameterName, Object value) {
            return (UpdateConfig) super.set(parameterName, value);
          }
        }
        /**
         * Add/update metadata items for an instance.
         *
         * Create a request for the method "instances.updateMetadataItems".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link UpdateMetadataItems#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsRequest}
         * @return the request
         */
        public UpdateMetadataItems updateMetadataItems(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsRequest content) throws java.io.IOException {
          UpdateMetadataItems result = new UpdateMetadataItems(name, content);
          initialize(result);
          return result;
        }

        public class UpdateMetadataItems extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsResponse> {

          private static final String REST_PATH = "v1/{+name}:updateMetadataItems";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Add/update metadata items for an instance.
           *
           * Create a request for the method "instances.updateMetadataItems".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link UpdateMetadataItems#execute()} method to invoke the remote
           * operation. <p> {@link UpdateMetadataItems#initialize(com.google.api.client.googleapis.services.
           * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsRequest}
           * @since 1.13
           */
          protected UpdateMetadataItems(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.UpdateInstanceMetadataItemsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public UpdateMetadataItems set$Xgafv(java.lang.String $Xgafv) {
            return (UpdateMetadataItems) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpdateMetadataItems setAccessToken(java.lang.String accessToken) {
            return (UpdateMetadataItems) super.setAccessToken(accessToken);
          }

          @Override
          public UpdateMetadataItems setAlt(java.lang.String alt) {
            return (UpdateMetadataItems) super.setAlt(alt);
          }

          @Override
          public UpdateMetadataItems setCallback(java.lang.String callback) {
            return (UpdateMetadataItems) super.setCallback(callback);
          }

          @Override
          public UpdateMetadataItems setFields(java.lang.String fields) {
            return (UpdateMetadataItems) super.setFields(fields);
          }

          @Override
          public UpdateMetadataItems setKey(java.lang.String key) {
            return (UpdateMetadataItems) super.setKey(key);
          }

          @Override
          public UpdateMetadataItems setOauthToken(java.lang.String oauthToken) {
            return (UpdateMetadataItems) super.setOauthToken(oauthToken);
          }

          @Override
          public UpdateMetadataItems setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpdateMetadataItems) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpdateMetadataItems setQuotaUser(java.lang.String quotaUser) {
            return (UpdateMetadataItems) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpdateMetadataItems setUploadType(java.lang.String uploadType) {
            return (UpdateMetadataItems) super.setUploadType(uploadType);
          }

          @Override
          public UpdateMetadataItems setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpdateMetadataItems) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public UpdateMetadataItems setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpdateMetadataItems set(String parameterName, Object value) {
            return (UpdateMetadataItems) super.set(parameterName, value);
          }
        }
        /**
         * Updates the Shielded instance configuration of a single Instance.
         *
         * Create a request for the method "instances.updateShieldedInstanceConfig".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link UpdateShieldedInstanceConfig#execute()} method to invoke the remote
         * operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateShieldedInstanceConfigRequest}
         * @return the request
         */
        public UpdateShieldedInstanceConfig updateShieldedInstanceConfig(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateShieldedInstanceConfigRequest content) throws java.io.IOException {
          UpdateShieldedInstanceConfig result = new UpdateShieldedInstanceConfig(name, content);
          initialize(result);
          return result;
        }

        public class UpdateShieldedInstanceConfig extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:updateShieldedInstanceConfig";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Updates the Shielded instance configuration of a single Instance.
           *
           * Create a request for the method "instances.updateShieldedInstanceConfig".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link UpdateShieldedInstanceConfig#execute()} method to invoke
           * the remote operation. <p> {@link UpdateShieldedInstanceConfig#initialize(com.google.api.client.
           * googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
           * immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.UpdateShieldedInstanceConfigRequest}
           * @since 1.13
           */
          protected UpdateShieldedInstanceConfig(java.lang.String name, com.google.api.services.notebooks.v1.model.UpdateShieldedInstanceConfigRequest content) {
            super(AIPlatformNotebooks.this, "PATCH", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public UpdateShieldedInstanceConfig set$Xgafv(java.lang.String $Xgafv) {
            return (UpdateShieldedInstanceConfig) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpdateShieldedInstanceConfig setAccessToken(java.lang.String accessToken) {
            return (UpdateShieldedInstanceConfig) super.setAccessToken(accessToken);
          }

          @Override
          public UpdateShieldedInstanceConfig setAlt(java.lang.String alt) {
            return (UpdateShieldedInstanceConfig) super.setAlt(alt);
          }

          @Override
          public UpdateShieldedInstanceConfig setCallback(java.lang.String callback) {
            return (UpdateShieldedInstanceConfig) super.setCallback(callback);
          }

          @Override
          public UpdateShieldedInstanceConfig setFields(java.lang.String fields) {
            return (UpdateShieldedInstanceConfig) super.setFields(fields);
          }

          @Override
          public UpdateShieldedInstanceConfig setKey(java.lang.String key) {
            return (UpdateShieldedInstanceConfig) super.setKey(key);
          }

          @Override
          public UpdateShieldedInstanceConfig setOauthToken(java.lang.String oauthToken) {
            return (UpdateShieldedInstanceConfig) super.setOauthToken(oauthToken);
          }

          @Override
          public UpdateShieldedInstanceConfig setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpdateShieldedInstanceConfig) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpdateShieldedInstanceConfig setQuotaUser(java.lang.String quotaUser) {
            return (UpdateShieldedInstanceConfig) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpdateShieldedInstanceConfig setUploadType(java.lang.String uploadType) {
            return (UpdateShieldedInstanceConfig) super.setUploadType(uploadType);
          }

          @Override
          public UpdateShieldedInstanceConfig setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpdateShieldedInstanceConfig) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public UpdateShieldedInstanceConfig setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpdateShieldedInstanceConfig set(String parameterName, Object value) {
            return (UpdateShieldedInstanceConfig) super.set(parameterName, value);
          }
        }
        /**
         * Upgrades a notebook instance to the latest version.
         *
         * Create a request for the method "instances.upgrade".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Upgrade#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.UpgradeInstanceRequest}
         * @return the request
         */
        public Upgrade upgrade(java.lang.String name, com.google.api.services.notebooks.v1.model.UpgradeInstanceRequest content) throws java.io.IOException {
          Upgrade result = new Upgrade(name, content);
          initialize(result);
          return result;
        }

        public class Upgrade extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:upgrade";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Upgrades a notebook instance to the latest version.
           *
           * Create a request for the method "instances.upgrade".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Upgrade#execute()} method to invoke the remote operation.
           * <p> {@link
           * Upgrade#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.UpgradeInstanceRequest}
           * @since 1.13
           */
          protected Upgrade(java.lang.String name, com.google.api.services.notebooks.v1.model.UpgradeInstanceRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public Upgrade set$Xgafv(java.lang.String $Xgafv) {
            return (Upgrade) super.set$Xgafv($Xgafv);
          }

          @Override
          public Upgrade setAccessToken(java.lang.String accessToken) {
            return (Upgrade) super.setAccessToken(accessToken);
          }

          @Override
          public Upgrade setAlt(java.lang.String alt) {
            return (Upgrade) super.setAlt(alt);
          }

          @Override
          public Upgrade setCallback(java.lang.String callback) {
            return (Upgrade) super.setCallback(callback);
          }

          @Override
          public Upgrade setFields(java.lang.String fields) {
            return (Upgrade) super.setFields(fields);
          }

          @Override
          public Upgrade setKey(java.lang.String key) {
            return (Upgrade) super.setKey(key);
          }

          @Override
          public Upgrade setOauthToken(java.lang.String oauthToken) {
            return (Upgrade) super.setOauthToken(oauthToken);
          }

          @Override
          public Upgrade setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Upgrade) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Upgrade setQuotaUser(java.lang.String quotaUser) {
            return (Upgrade) super.setQuotaUser(quotaUser);
          }

          @Override
          public Upgrade setUploadType(java.lang.String uploadType) {
            return (Upgrade) super.setUploadType(uploadType);
          }

          @Override
          public Upgrade setUploadProtocol(java.lang.String uploadProtocol) {
            return (Upgrade) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public Upgrade setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Upgrade set(String parameterName, Object value) {
            return (Upgrade) super.set(parameterName, value);
          }
        }
        /**
         * Allows notebook instances to call this endpoint to upgrade themselves. Do not use this method
         * directly.
         *
         * Create a request for the method "instances.upgradeInternal".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link UpgradeInternal#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.UpgradeInstanceInternalRequest}
         * @return the request
         */
        public UpgradeInternal upgradeInternal(java.lang.String name, com.google.api.services.notebooks.v1.model.UpgradeInstanceInternalRequest content) throws java.io.IOException {
          UpgradeInternal result = new UpgradeInternal(name, content);
          initialize(result);
          return result;
        }

        public class UpgradeInternal extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:upgradeInternal";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");

          /**
           * Allows notebook instances to call this endpoint to upgrade themselves. Do not use this method
           * directly.
           *
           * Create a request for the method "instances.upgradeInternal".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link UpgradeInternal#execute()} method to invoke the remote
           * operation. <p> {@link UpgradeInternal#initialize(com.google.api.client.googleapis.services.Abst
           * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.UpgradeInstanceInternalRequest}
           * @since 1.13
           */
          protected UpgradeInternal(java.lang.String name, com.google.api.services.notebooks.v1.model.UpgradeInstanceInternalRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
          }

          @Override
          public UpgradeInternal set$Xgafv(java.lang.String $Xgafv) {
            return (UpgradeInternal) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpgradeInternal setAccessToken(java.lang.String accessToken) {
            return (UpgradeInternal) super.setAccessToken(accessToken);
          }

          @Override
          public UpgradeInternal setAlt(java.lang.String alt) {
            return (UpgradeInternal) super.setAlt(alt);
          }

          @Override
          public UpgradeInternal setCallback(java.lang.String callback) {
            return (UpgradeInternal) super.setCallback(callback);
          }

          @Override
          public UpgradeInternal setFields(java.lang.String fields) {
            return (UpgradeInternal) super.setFields(fields);
          }

          @Override
          public UpgradeInternal setKey(java.lang.String key) {
            return (UpgradeInternal) super.setKey(key);
          }

          @Override
          public UpgradeInternal setOauthToken(java.lang.String oauthToken) {
            return (UpgradeInternal) super.setOauthToken(oauthToken);
          }

          @Override
          public UpgradeInternal setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpgradeInternal) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpgradeInternal setQuotaUser(java.lang.String quotaUser) {
            return (UpgradeInternal) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpgradeInternal setUploadType(java.lang.String uploadType) {
            return (UpgradeInternal) super.setUploadType(uploadType);
          }

          @Override
          public UpgradeInternal setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpgradeInternal) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
           */
          public UpgradeInternal setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpgradeInternal set(String parameterName, Object value) {
            return (UpgradeInternal) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Operations collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Operations.List request = notebooks.operations().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Operations operations() {
        return new Operations();
      }

      /**
       * The "operations" collection of methods.
       */
      public class Operations {

        /**
         * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
         * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
         * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
         * methods to check whether the cancellation succeeded or whether the operation completed despite
         * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
         * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
         * `Code.CANCELLED`.
         *
         * Create a request for the method "operations.cancel".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be cancelled.
         * @param content the {@link com.google.api.services.notebooks.v1.model.CancelOperationRequest}
         * @return the request
         */
        public Cancel cancel(java.lang.String name, com.google.api.services.notebooks.v1.model.CancelOperationRequest content) throws java.io.IOException {
          Cancel result = new Cancel(name, content);
          initialize(result);
          return result;
        }

        public class Cancel extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}:cancel";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Starts asynchronous cancellation on a long-running operation. The server makes a best effort to
           * cancel the operation, but success is not guaranteed. If the server doesn't support this method,
           * it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other
           * methods to check whether the cancellation succeeded or whether the operation completed despite
           * cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an
           * operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to
           * `Code.CANCELLED`.
           *
           * Create a request for the method "operations.cancel".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Cancel#execute()} method to invoke the remote operation.
           * <p> {@link
           * Cancel#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be cancelled.
           * @param content the {@link com.google.api.services.notebooks.v1.model.CancelOperationRequest}
           * @since 1.13
           */
          protected Cancel(java.lang.String name, com.google.api.services.notebooks.v1.model.CancelOperationRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Cancel set$Xgafv(java.lang.String $Xgafv) {
            return (Cancel) super.set$Xgafv($Xgafv);
          }

          @Override
          public Cancel setAccessToken(java.lang.String accessToken) {
            return (Cancel) super.setAccessToken(accessToken);
          }

          @Override
          public Cancel setAlt(java.lang.String alt) {
            return (Cancel) super.setAlt(alt);
          }

          @Override
          public Cancel setCallback(java.lang.String callback) {
            return (Cancel) super.setCallback(callback);
          }

          @Override
          public Cancel setFields(java.lang.String fields) {
            return (Cancel) super.setFields(fields);
          }

          @Override
          public Cancel setKey(java.lang.String key) {
            return (Cancel) super.setKey(key);
          }

          @Override
          public Cancel setOauthToken(java.lang.String oauthToken) {
            return (Cancel) super.setOauthToken(oauthToken);
          }

          @Override
          public Cancel setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Cancel) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Cancel setQuotaUser(java.lang.String quotaUser) {
            return (Cancel) super.setQuotaUser(quotaUser);
          }

          @Override
          public Cancel setUploadType(java.lang.String uploadType) {
            return (Cancel) super.setUploadType(uploadType);
          }

          @Override
          public Cancel setUploadProtocol(java.lang.String uploadProtocol) {
            return (Cancel) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be cancelled. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be cancelled.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be cancelled. */
          public Cancel setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Cancel set(String parameterName, Object value) {
            return (Cancel) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a long-running operation. This method indicates that the client is no longer interested
         * in the operation result. It does not cancel the operation. If the server doesn't support this
         * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
         *
         * Create a request for the method "operations.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Empty> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Deletes a long-running operation. This method indicates that the client is no longer interested
           * in the operation result. It does not cancel the operation. If the server doesn't support this
           * method, it returns `google.rpc.Code.UNIMPLEMENTED`.
           *
           * Create a request for the method "operations.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource to be deleted.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource to be deleted. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the latest state of a long-running operation. Clients can use this method to poll the
         * operation result at intervals as recommended by the API service.
         *
         * Create a request for the method "operations.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation resource.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");

          /**
           * Gets the latest state of a long-running operation. Clients can use this method to poll the
           * operation result at intervals as recommended by the API service.
           *
           * Create a request for the method "operations.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation resource.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation resource. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists operations that match the specified filter in the request. If the server doesn't support
         * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to override
         * the binding to use different resource name schemes, such as `users/operations`. To override the
         * binding, API services can add a binding such as `"/v1/{name=users}/operations"` to their service
         * configuration. For backwards compatibility, the default name includes the operations collection
         * id, however overriding users must ensure the name binding is the parent resource, without the
         * operations collection id.
         *
         * Create a request for the method "operations.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param name The name of the operation's parent resource.
         * @return the request
         */
        public List list(java.lang.String name) throws java.io.IOException {
          List result = new List(name);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListOperationsResponse> {

          private static final String REST_PATH = "v1/{+name}/operations";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists operations that match the specified filter in the request. If the server doesn't support
           * this method, it returns `UNIMPLEMENTED`. NOTE: the `name` binding allows API services to
           * override the binding to use different resource name schemes, such as `users/operations`. To
           * override the binding, API services can add a binding such as `"/v1/{name=users}/operations"` to
           * their service configuration. For backwards compatibility, the default name includes the
           * operations collection id, however overriding users must ensure the name binding is the parent
           * resource, without the operations collection id.
           *
           * Create a request for the method "operations.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the operation's parent resource.
           * @since 1.13
           */
          protected List(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListOperationsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the operation's parent resource. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the operation's parent resource.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the operation's parent resource. */
          public List setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /** The standard list filter. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** The standard list filter.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** The standard list filter. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** The standard list page size. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** The standard list page size.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** The standard list page size. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /** The standard list page token. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** The standard list page token.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** The standard list page token. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Runtimes collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Runtimes.List request = notebooks.runtimes().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Runtimes runtimes() {
        return new Runtimes();
      }

      /**
       * The "runtimes" collection of methods.
       */
      public class Runtimes {

        /**
         * Creates a new Runtime in a given project and location.
         *
         * Create a request for the method "runtimes.create".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.Runtime}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Runtime content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/runtimes";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new Runtime in a given project and location.
           *
           * Create a request for the method "runtimes.create".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.Runtime}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Runtime content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. User-defined unique ID of this Runtime. */
          @com.google.api.client.util.Key
          private java.lang.String runtimeId;

          /** Required. User-defined unique ID of this Runtime.
           */
          public java.lang.String getRuntimeId() {
            return runtimeId;
          }

          /** Required. User-defined unique ID of this Runtime. */
          public Create setRuntimeId(java.lang.String runtimeId) {
            this.runtimeId = runtimeId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a single Runtime.
         *
         * Create a request for the method "runtimes.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Deletes a single Runtime.
           *
           * Create a request for the method "runtimes.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of a single Runtime. The location must be a regional endpoint rather than zonal.
         *
         * Create a request for the method "runtimes.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Runtime> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Gets details of a single Runtime. The location must be a regional endpoint rather than zonal.
           *
           * Create a request for the method "runtimes.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Runtime.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Gets the access control policy for a resource. Returns an empty policy if the resource exists and
         * does not have a policy set.
         *
         * Create a request for the method "runtimes.getIamPolicy".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
         * @return the request
         */
        public GetIamPolicy getIamPolicy(java.lang.String resource) throws java.io.IOException {
          GetIamPolicy result = new GetIamPolicy(resource);
          initialize(result);
          return result;
        }

        public class GetIamPolicy extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:getIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Gets the access control policy for a resource. Returns an empty policy if the resource exists
           * and does not have a policy set.
           *
           * Create a request for the method "runtimes.getIamPolicy".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link GetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         *        the appropriate value for this field.
           * @since 1.13
           */
          protected GetIamPolicy(java.lang.String resource) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (GetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (GetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public GetIamPolicy setAlt(java.lang.String alt) {
            return (GetIamPolicy) super.setAlt(alt);
          }

          @Override
          public GetIamPolicy setCallback(java.lang.String callback) {
            return (GetIamPolicy) super.setCallback(callback);
          }

          @Override
          public GetIamPolicy setFields(java.lang.String fields) {
            return (GetIamPolicy) super.setFields(fields);
          }

          @Override
          public GetIamPolicy setKey(java.lang.String key) {
            return (GetIamPolicy) super.setKey(key);
          }

          @Override
          public GetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (GetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public GetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (GetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetIamPolicy setUploadType(java.lang.String uploadType) {
            return (GetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public GetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being requested. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being requested. See the operation
           * documentation for the appropriate value for this field.
           */
          public GetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          /**
           * Optional. The maximum policy version that will be used to format the policy. Valid
           * values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests
           * for policies with any conditional role bindings must specify version 3. Policies with
           * no conditional role bindings may specify any valid value or leave the field unset. The
           * policy in the response might use the policy version that you specified, or it might use
           * a lower policy version. For example, if you specify version 3, but the policy has no
           * conditional role bindings, the response uses version 1. To learn which resources
           * support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          @com.google.api.client.util.Key("options.requestedPolicyVersion")
          private java.lang.Integer optionsRequestedPolicyVersion;

          /** Optional. The maximum policy version that will be used to format the policy. Valid values are 0, 1,
         and 3. Requests specifying an invalid value will be rejected. Requests for policies with any
         conditional role bindings must specify version 3. Policies with no conditional role bindings may
         specify any valid value or leave the field unset. The policy in the response might use the policy
         version that you specified, or it might use a lower policy version. For example, if you specify
         version 3, but the policy has no conditional role bindings, the response uses version 1. To learn
         which resources support conditions in their IAM policies, see the [IAM
         documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public java.lang.Integer getOptionsRequestedPolicyVersion() {
            return optionsRequestedPolicyVersion;
          }

          /**
           * Optional. The maximum policy version that will be used to format the policy. Valid
           * values are 0, 1, and 3. Requests specifying an invalid value will be rejected. Requests
           * for policies with any conditional role bindings must specify version 3. Policies with
           * no conditional role bindings may specify any valid value or leave the field unset. The
           * policy in the response might use the policy version that you specified, or it might use
           * a lower policy version. For example, if you specify version 3, but the policy has no
           * conditional role bindings, the response uses version 1. To learn which resources
           * support conditions in their IAM policies, see the [IAM
           * documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
           */
          public GetIamPolicy setOptionsRequestedPolicyVersion(java.lang.Integer optionsRequestedPolicyVersion) {
            this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
            return this;
          }

          @Override
          public GetIamPolicy set(String parameterName, Object value) {
            return (GetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Lists Runtimes in a given project and location.
         *
         * Create a request for the method "runtimes.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListRuntimesResponse> {

          private static final String REST_PATH = "v1/{+parent}/runtimes";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists Runtimes in a given project and location.
           *
           * Create a request for the method "runtimes.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListRuntimesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Maximum return size of the list call. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum return size of the list call.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum return size of the list call. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A previous returned page token that can be used to continue listing from the last result.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Report and process a runtime event.
         *
         * Create a request for the method "runtimes.reportEvent".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link ReportEvent#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.ReportRuntimeEventRequest}
         * @return the request
         */
        public ReportEvent reportEvent(java.lang.String name, com.google.api.services.notebooks.v1.model.ReportRuntimeEventRequest content) throws java.io.IOException {
          ReportEvent result = new ReportEvent(name, content);
          initialize(result);
          return result;
        }

        public class ReportEvent extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:reportEvent";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Report and process a runtime event.
           *
           * Create a request for the method "runtimes.reportEvent".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link ReportEvent#execute()} method to invoke the remote
           * operation. <p> {@link
           * ReportEvent#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.ReportRuntimeEventRequest}
           * @since 1.13
           */
          protected ReportEvent(java.lang.String name, com.google.api.services.notebooks.v1.model.ReportRuntimeEventRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public ReportEvent set$Xgafv(java.lang.String $Xgafv) {
            return (ReportEvent) super.set$Xgafv($Xgafv);
          }

          @Override
          public ReportEvent setAccessToken(java.lang.String accessToken) {
            return (ReportEvent) super.setAccessToken(accessToken);
          }

          @Override
          public ReportEvent setAlt(java.lang.String alt) {
            return (ReportEvent) super.setAlt(alt);
          }

          @Override
          public ReportEvent setCallback(java.lang.String callback) {
            return (ReportEvent) super.setCallback(callback);
          }

          @Override
          public ReportEvent setFields(java.lang.String fields) {
            return (ReportEvent) super.setFields(fields);
          }

          @Override
          public ReportEvent setKey(java.lang.String key) {
            return (ReportEvent) super.setKey(key);
          }

          @Override
          public ReportEvent setOauthToken(java.lang.String oauthToken) {
            return (ReportEvent) super.setOauthToken(oauthToken);
          }

          @Override
          public ReportEvent setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ReportEvent) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ReportEvent setQuotaUser(java.lang.String quotaUser) {
            return (ReportEvent) super.setQuotaUser(quotaUser);
          }

          @Override
          public ReportEvent setUploadType(java.lang.String uploadType) {
            return (ReportEvent) super.setUploadType(uploadType);
          }

          @Override
          public ReportEvent setUploadProtocol(java.lang.String uploadProtocol) {
            return (ReportEvent) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public ReportEvent setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public ReportEvent set(String parameterName, Object value) {
            return (ReportEvent) super.set(parameterName, value);
          }
        }
        /**
         * Resets a Managed Notebook Runtime.
         *
         * Create a request for the method "runtimes.reset".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Reset#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.ResetRuntimeRequest}
         * @return the request
         */
        public Reset reset(java.lang.String name, com.google.api.services.notebooks.v1.model.ResetRuntimeRequest content) throws java.io.IOException {
          Reset result = new Reset(name, content);
          initialize(result);
          return result;
        }

        public class Reset extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:reset";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Resets a Managed Notebook Runtime.
           *
           * Create a request for the method "runtimes.reset".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Reset#execute()} method to invoke the remote operation.
           * <p> {@link
           * Reset#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.ResetRuntimeRequest}
           * @since 1.13
           */
          protected Reset(java.lang.String name, com.google.api.services.notebooks.v1.model.ResetRuntimeRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public Reset set$Xgafv(java.lang.String $Xgafv) {
            return (Reset) super.set$Xgafv($Xgafv);
          }

          @Override
          public Reset setAccessToken(java.lang.String accessToken) {
            return (Reset) super.setAccessToken(accessToken);
          }

          @Override
          public Reset setAlt(java.lang.String alt) {
            return (Reset) super.setAlt(alt);
          }

          @Override
          public Reset setCallback(java.lang.String callback) {
            return (Reset) super.setCallback(callback);
          }

          @Override
          public Reset setFields(java.lang.String fields) {
            return (Reset) super.setFields(fields);
          }

          @Override
          public Reset setKey(java.lang.String key) {
            return (Reset) super.setKey(key);
          }

          @Override
          public Reset setOauthToken(java.lang.String oauthToken) {
            return (Reset) super.setOauthToken(oauthToken);
          }

          @Override
          public Reset setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Reset) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Reset setQuotaUser(java.lang.String quotaUser) {
            return (Reset) super.setQuotaUser(quotaUser);
          }

          @Override
          public Reset setUploadType(java.lang.String uploadType) {
            return (Reset) super.setUploadType(uploadType);
          }

          @Override
          public Reset setUploadProtocol(java.lang.String uploadProtocol) {
            return (Reset) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public Reset setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Reset set(String parameterName, Object value) {
            return (Reset) super.set(parameterName, value);
          }
        }
        /**
         * Sets the access control policy on the specified resource. Replaces any existing policy. Can
         * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
         *
         * Create a request for the method "runtimes.setIamPolicy".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
         * @param content the {@link com.google.api.services.notebooks.v1.model.SetIamPolicyRequest}
         * @return the request
         */
        public SetIamPolicy setIamPolicy(java.lang.String resource, com.google.api.services.notebooks.v1.model.SetIamPolicyRequest content) throws java.io.IOException {
          SetIamPolicy result = new SetIamPolicy(resource, content);
          initialize(result);
          return result;
        }

        public class SetIamPolicy extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Policy> {

          private static final String REST_PATH = "v1/{+resource}:setIamPolicy";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Sets the access control policy on the specified resource. Replaces any existing policy. Can
           * return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.
           *
           * Create a request for the method "runtimes.setIamPolicy".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link SetIamPolicy#execute()} method to invoke the remote
           * operation. <p> {@link
           * SetIamPolicy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         *        the appropriate value for this field.
           * @param content the {@link com.google.api.services.notebooks.v1.model.SetIamPolicyRequest}
           * @since 1.13
           */
          protected SetIamPolicy(java.lang.String resource, com.google.api.services.notebooks.v1.model.SetIamPolicyRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Policy.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public SetIamPolicy set$Xgafv(java.lang.String $Xgafv) {
            return (SetIamPolicy) super.set$Xgafv($Xgafv);
          }

          @Override
          public SetIamPolicy setAccessToken(java.lang.String accessToken) {
            return (SetIamPolicy) super.setAccessToken(accessToken);
          }

          @Override
          public SetIamPolicy setAlt(java.lang.String alt) {
            return (SetIamPolicy) super.setAlt(alt);
          }

          @Override
          public SetIamPolicy setCallback(java.lang.String callback) {
            return (SetIamPolicy) super.setCallback(callback);
          }

          @Override
          public SetIamPolicy setFields(java.lang.String fields) {
            return (SetIamPolicy) super.setFields(fields);
          }

          @Override
          public SetIamPolicy setKey(java.lang.String key) {
            return (SetIamPolicy) super.setKey(key);
          }

          @Override
          public SetIamPolicy setOauthToken(java.lang.String oauthToken) {
            return (SetIamPolicy) super.setOauthToken(oauthToken);
          }

          @Override
          public SetIamPolicy setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (SetIamPolicy) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public SetIamPolicy setQuotaUser(java.lang.String quotaUser) {
            return (SetIamPolicy) super.setQuotaUser(quotaUser);
          }

          @Override
          public SetIamPolicy setUploadType(java.lang.String uploadType) {
            return (SetIamPolicy) super.setUploadType(uploadType);
          }

          @Override
          public SetIamPolicy setUploadProtocol(java.lang.String uploadProtocol) {
            return (SetIamPolicy) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy is being specified. See the operation documentation for
         the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy is being specified. See the operation
           * documentation for the appropriate value for this field.
           */
          public SetIamPolicy setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public SetIamPolicy set(String parameterName, Object value) {
            return (SetIamPolicy) super.set(parameterName, value);
          }
        }
        /**
         * Starts a Managed Notebook Runtime. Perform "Start" on GPU instances; "Resume" on CPU instances
         * See: https://cloud.google.com/compute/docs/instances/stop-start-instance
         * https://cloud.google.com/compute/docs/instances/suspend-resume-instance
         *
         * Create a request for the method "runtimes.start".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Start#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.StartRuntimeRequest}
         * @return the request
         */
        public Start start(java.lang.String name, com.google.api.services.notebooks.v1.model.StartRuntimeRequest content) throws java.io.IOException {
          Start result = new Start(name, content);
          initialize(result);
          return result;
        }

        public class Start extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:start";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Starts a Managed Notebook Runtime. Perform "Start" on GPU instances; "Resume" on CPU instances
           * See: https://cloud.google.com/compute/docs/instances/stop-start-instance
           * https://cloud.google.com/compute/docs/instances/suspend-resume-instance
           *
           * Create a request for the method "runtimes.start".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Start#execute()} method to invoke the remote operation.
           * <p> {@link
           * Start#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.StartRuntimeRequest}
           * @since 1.13
           */
          protected Start(java.lang.String name, com.google.api.services.notebooks.v1.model.StartRuntimeRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public Start set$Xgafv(java.lang.String $Xgafv) {
            return (Start) super.set$Xgafv($Xgafv);
          }

          @Override
          public Start setAccessToken(java.lang.String accessToken) {
            return (Start) super.setAccessToken(accessToken);
          }

          @Override
          public Start setAlt(java.lang.String alt) {
            return (Start) super.setAlt(alt);
          }

          @Override
          public Start setCallback(java.lang.String callback) {
            return (Start) super.setCallback(callback);
          }

          @Override
          public Start setFields(java.lang.String fields) {
            return (Start) super.setFields(fields);
          }

          @Override
          public Start setKey(java.lang.String key) {
            return (Start) super.setKey(key);
          }

          @Override
          public Start setOauthToken(java.lang.String oauthToken) {
            return (Start) super.setOauthToken(oauthToken);
          }

          @Override
          public Start setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Start) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Start setQuotaUser(java.lang.String quotaUser) {
            return (Start) super.setQuotaUser(quotaUser);
          }

          @Override
          public Start setUploadType(java.lang.String uploadType) {
            return (Start) super.setUploadType(uploadType);
          }

          @Override
          public Start setUploadProtocol(java.lang.String uploadProtocol) {
            return (Start) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public Start setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Start set(String parameterName, Object value) {
            return (Start) super.set(parameterName, value);
          }
        }
        /**
         * Stops a Managed Notebook Runtime. Perform "Stop" on GPU instances; "Suspend" on CPU instances
         * See: https://cloud.google.com/compute/docs/instances/stop-start-instance
         * https://cloud.google.com/compute/docs/instances/suspend-resume-instance
         *
         * Create a request for the method "runtimes.stop".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.StopRuntimeRequest}
         * @return the request
         */
        public Stop stop(java.lang.String name, com.google.api.services.notebooks.v1.model.StopRuntimeRequest content) throws java.io.IOException {
          Stop result = new Stop(name, content);
          initialize(result);
          return result;
        }

        public class Stop extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:stop";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Stops a Managed Notebook Runtime. Perform "Stop" on GPU instances; "Suspend" on CPU instances
           * See: https://cloud.google.com/compute/docs/instances/stop-start-instance
           * https://cloud.google.com/compute/docs/instances/suspend-resume-instance
           *
           * Create a request for the method "runtimes.stop".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p>
           * {@link Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.StopRuntimeRequest}
           * @since 1.13
           */
          protected Stop(java.lang.String name, com.google.api.services.notebooks.v1.model.StopRuntimeRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public Stop set$Xgafv(java.lang.String $Xgafv) {
            return (Stop) super.set$Xgafv($Xgafv);
          }

          @Override
          public Stop setAccessToken(java.lang.String accessToken) {
            return (Stop) super.setAccessToken(accessToken);
          }

          @Override
          public Stop setAlt(java.lang.String alt) {
            return (Stop) super.setAlt(alt);
          }

          @Override
          public Stop setCallback(java.lang.String callback) {
            return (Stop) super.setCallback(callback);
          }

          @Override
          public Stop setFields(java.lang.String fields) {
            return (Stop) super.setFields(fields);
          }

          @Override
          public Stop setKey(java.lang.String key) {
            return (Stop) super.setKey(key);
          }

          @Override
          public Stop setOauthToken(java.lang.String oauthToken) {
            return (Stop) super.setOauthToken(oauthToken);
          }

          @Override
          public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Stop) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Stop setQuotaUser(java.lang.String quotaUser) {
            return (Stop) super.setQuotaUser(quotaUser);
          }

          @Override
          public Stop setUploadType(java.lang.String uploadType) {
            return (Stop) super.setUploadType(uploadType);
          }

          @Override
          public Stop setUploadProtocol(java.lang.String uploadProtocol) {
            return (Stop) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public Stop setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Stop set(String parameterName, Object value) {
            return (Stop) super.set(parameterName, value);
          }
        }
        /**
         * Switch a Managed Notebook Runtime.
         *
         * Create a request for the method "runtimes.switch".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link AIPlatformNotebooksSwitch#execute()} method to invoke the remote
         * operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.SwitchRuntimeRequest}
         * @return the request
         */
        public AIPlatformNotebooksSwitch notebooksSwitch(java.lang.String name, com.google.api.services.notebooks.v1.model.SwitchRuntimeRequest content) throws java.io.IOException {
          AIPlatformNotebooksSwitch result = new AIPlatformNotebooksSwitch(name, content);
          initialize(result);
          return result;
        }

        public class AIPlatformNotebooksSwitch extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:switch";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Switch a Managed Notebook Runtime.
           *
           * Create a request for the method "runtimes.switch".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link AIPlatformNotebooksSwitch#execute()} method to invoke the
           * remote operation. <p> {@link AIPlatformNotebooksSwitch#initialize(com.google.api.client.googlea
           * pis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
           * immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.SwitchRuntimeRequest}
           * @since 1.13
           */
          protected AIPlatformNotebooksSwitch(java.lang.String name, com.google.api.services.notebooks.v1.model.SwitchRuntimeRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public AIPlatformNotebooksSwitch set$Xgafv(java.lang.String $Xgafv) {
            return (AIPlatformNotebooksSwitch) super.set$Xgafv($Xgafv);
          }

          @Override
          public AIPlatformNotebooksSwitch setAccessToken(java.lang.String accessToken) {
            return (AIPlatformNotebooksSwitch) super.setAccessToken(accessToken);
          }

          @Override
          public AIPlatformNotebooksSwitch setAlt(java.lang.String alt) {
            return (AIPlatformNotebooksSwitch) super.setAlt(alt);
          }

          @Override
          public AIPlatformNotebooksSwitch setCallback(java.lang.String callback) {
            return (AIPlatformNotebooksSwitch) super.setCallback(callback);
          }

          @Override
          public AIPlatformNotebooksSwitch setFields(java.lang.String fields) {
            return (AIPlatformNotebooksSwitch) super.setFields(fields);
          }

          @Override
          public AIPlatformNotebooksSwitch setKey(java.lang.String key) {
            return (AIPlatformNotebooksSwitch) super.setKey(key);
          }

          @Override
          public AIPlatformNotebooksSwitch setOauthToken(java.lang.String oauthToken) {
            return (AIPlatformNotebooksSwitch) super.setOauthToken(oauthToken);
          }

          @Override
          public AIPlatformNotebooksSwitch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (AIPlatformNotebooksSwitch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public AIPlatformNotebooksSwitch setQuotaUser(java.lang.String quotaUser) {
            return (AIPlatformNotebooksSwitch) super.setQuotaUser(quotaUser);
          }

          @Override
          public AIPlatformNotebooksSwitch setUploadType(java.lang.String uploadType) {
            return (AIPlatformNotebooksSwitch) super.setUploadType(uploadType);
          }

          @Override
          public AIPlatformNotebooksSwitch setUploadProtocol(java.lang.String uploadProtocol) {
            return (AIPlatformNotebooksSwitch) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/runtimes/{runtime_id}`
           */
          public AIPlatformNotebooksSwitch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public AIPlatformNotebooksSwitch set(String parameterName, Object value) {
            return (AIPlatformNotebooksSwitch) super.set(parameterName, value);
          }
        }
        /**
         * Returns permissions that a caller has on the specified resource. If the resource does not exist,
         * this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is
         * designed to be used for building permission-aware UIs and command-line tools, not for
         * authorization checking. This operation may "fail open" without warning.
         *
         * Create a request for the method "runtimes.testIamPermissions".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote operation.
         *
         * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
         * @param content the {@link com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest}
         * @return the request
         */
        public TestIamPermissions testIamPermissions(java.lang.String resource, com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest content) throws java.io.IOException {
          TestIamPermissions result = new TestIamPermissions(resource, content);
          initialize(result);
          return result;
        }

        public class TestIamPermissions extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.TestIamPermissionsResponse> {

          private static final String REST_PATH = "v1/{+resource}:testIamPermissions";

          private final java.util.regex.Pattern RESOURCE_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");

          /**
           * Returns permissions that a caller has on the specified resource. If the resource does not
           * exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This
           * operation is designed to be used for building permission-aware UIs and command-line tools, not
           * for authorization checking. This operation may "fail open" without warning.
           *
           * Create a request for the method "runtimes.testIamPermissions".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link TestIamPermissions#execute()} method to invoke the remote
           * operation. <p> {@link TestIamPermissions#initialize(com.google.api.client.googleapis.services.A
           * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param resource REQUIRED: The resource for which the policy detail is being requested. See the operation
         *        documentation for the appropriate value for this field.
           * @param content the {@link com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest}
           * @since 1.13
           */
          protected TestIamPermissions(java.lang.String resource, com.google.api.services.notebooks.v1.model.TestIamPermissionsRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.TestIamPermissionsResponse.class);
            this.resource = com.google.api.client.util.Preconditions.checkNotNull(resource, "Required parameter resource must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
          }

          @Override
          public TestIamPermissions set$Xgafv(java.lang.String $Xgafv) {
            return (TestIamPermissions) super.set$Xgafv($Xgafv);
          }

          @Override
          public TestIamPermissions setAccessToken(java.lang.String accessToken) {
            return (TestIamPermissions) super.setAccessToken(accessToken);
          }

          @Override
          public TestIamPermissions setAlt(java.lang.String alt) {
            return (TestIamPermissions) super.setAlt(alt);
          }

          @Override
          public TestIamPermissions setCallback(java.lang.String callback) {
            return (TestIamPermissions) super.setCallback(callback);
          }

          @Override
          public TestIamPermissions setFields(java.lang.String fields) {
            return (TestIamPermissions) super.setFields(fields);
          }

          @Override
          public TestIamPermissions setKey(java.lang.String key) {
            return (TestIamPermissions) super.setKey(key);
          }

          @Override
          public TestIamPermissions setOauthToken(java.lang.String oauthToken) {
            return (TestIamPermissions) super.setOauthToken(oauthToken);
          }

          @Override
          public TestIamPermissions setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (TestIamPermissions) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public TestIamPermissions setQuotaUser(java.lang.String quotaUser) {
            return (TestIamPermissions) super.setQuotaUser(quotaUser);
          }

          @Override
          public TestIamPermissions setUploadType(java.lang.String uploadType) {
            return (TestIamPermissions) super.setUploadType(uploadType);
          }

          @Override
          public TestIamPermissions setUploadProtocol(java.lang.String uploadProtocol) {
            return (TestIamPermissions) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          @com.google.api.client.util.Key
          private java.lang.String resource;

          /** REQUIRED: The resource for which the policy detail is being requested. See the operation
         documentation for the appropriate value for this field.
           */
          public java.lang.String getResource() {
            return resource;
          }

          /**
           * REQUIRED: The resource for which the policy detail is being requested. See the
           * operation documentation for the appropriate value for this field.
           */
          public TestIamPermissions setResource(java.lang.String resource) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(RESOURCE_PATTERN.matcher(resource).matches(),
                  "Parameter resource must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/runtimes/[^/]+$");
            }
            this.resource = resource;
            return this;
          }

          @Override
          public TestIamPermissions set(String parameterName, Object value) {
            return (TestIamPermissions) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Schedules collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code AIPlatformNotebooks notebooks = new AIPlatformNotebooks(...);}
       *   {@code AIPlatformNotebooks.Schedules.List request = notebooks.schedules().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Schedules schedules() {
        return new Schedules();
      }

      /**
       * The "schedules" collection of methods.
       */
      public class Schedules {

        /**
         * Creates a new Scheduled Notebook in a given project and location.
         *
         * Create a request for the method "schedules.create".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.Schedule}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Schedule content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+parent}/schedules";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Creates a new Scheduled Notebook in a given project and location.
           *
           * Create a request for the method "schedules.create".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.Schedule}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.notebooks.v1.model.Schedule content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Required. User-defined unique ID of this schedule. */
          @com.google.api.client.util.Key
          private java.lang.String scheduleId;

          /** Required. User-defined unique ID of this schedule.
           */
          public java.lang.String getScheduleId() {
            return scheduleId;
          }

          /** Required. User-defined unique ID of this schedule. */
          public Create setScheduleId(java.lang.String scheduleId) {
            this.scheduleId = scheduleId;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes schedule and all underlying jobs
         *
         * Create a request for the method "schedules.delete".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");

          /**
           * Deletes schedule and all underlying jobs
           *
           * Create a request for the method "schedules.delete".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets details of schedule
         *
         * Create a request for the method "schedules.get".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Schedule> {

          private static final String REST_PATH = "v1/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");

          /**
           * Gets details of schedule
           *
           * Create a request for the method "schedules.get".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.Schedule.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format: `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Lists schedules in a given project and location.
         *
         * Create a request for the method "schedules.list".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.ListSchedulesResponse> {

          private static final String REST_PATH = "v1/{+parent}/schedules";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+$");

          /**
           * Lists schedules in a given project and location.
           *
           * Create a request for the method "schedules.list".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. Format: `parent=projects/{project_id}/locations/{location}`
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(AIPlatformNotebooks.this, "GET", REST_PATH, null, com.google.api.services.notebooks.v1.model.ListSchedulesResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}`
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Required. Format: `parent=projects/{project_id}/locations/{location}` */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** Filter applied to resulting schedules. */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** Filter applied to resulting schedules.
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /** Filter applied to resulting schedules. */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /** Field to order results by. */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Field to order results by.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /** Field to order results by. */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /** Maximum return size of the list call. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** Maximum return size of the list call.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** Maximum return size of the list call. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** A previous returned page token that can be used to continue listing from the last result.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /**
           * A previous returned page token that can be used to continue listing from the last
           * result.
           */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Triggers execution of an existing schedule.
         *
         * Create a request for the method "schedules.trigger".
         *
         * This request holds the parameters needed by the notebooks server.  After setting any optional
         * parameters, call the {@link Trigger#execute()} method to invoke the remote operation.
         *
         * @param name Required. Format: `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
         * @param content the {@link com.google.api.services.notebooks.v1.model.TriggerScheduleRequest}
         * @return the request
         */
        public Trigger trigger(java.lang.String name, com.google.api.services.notebooks.v1.model.TriggerScheduleRequest content) throws java.io.IOException {
          Trigger result = new Trigger(name, content);
          initialize(result);
          return result;
        }

        public class Trigger extends AIPlatformNotebooksRequest<com.google.api.services.notebooks.v1.model.Operation> {

          private static final String REST_PATH = "v1/{+name}:trigger";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");

          /**
           * Triggers execution of an existing schedule.
           *
           * Create a request for the method "schedules.trigger".
           *
           * This request holds the parameters needed by the the notebooks server.  After setting any
           * optional parameters, call the {@link Trigger#execute()} method to invoke the remote operation.
           * <p> {@link
           * Trigger#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Required. Format: `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           * @param content the {@link com.google.api.services.notebooks.v1.model.TriggerScheduleRequest}
           * @since 1.13
           */
          protected Trigger(java.lang.String name, com.google.api.services.notebooks.v1.model.TriggerScheduleRequest content) {
            super(AIPlatformNotebooks.this, "POST", REST_PATH, content, com.google.api.services.notebooks.v1.model.Operation.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
          }

          @Override
          public Trigger set$Xgafv(java.lang.String $Xgafv) {
            return (Trigger) super.set$Xgafv($Xgafv);
          }

          @Override
          public Trigger setAccessToken(java.lang.String accessToken) {
            return (Trigger) super.setAccessToken(accessToken);
          }

          @Override
          public Trigger setAlt(java.lang.String alt) {
            return (Trigger) super.setAlt(alt);
          }

          @Override
          public Trigger setCallback(java.lang.String callback) {
            return (Trigger) super.setCallback(callback);
          }

          @Override
          public Trigger setFields(java.lang.String fields) {
            return (Trigger) super.setFields(fields);
          }

          @Override
          public Trigger setKey(java.lang.String key) {
            return (Trigger) super.setKey(key);
          }

          @Override
          public Trigger setOauthToken(java.lang.String oauthToken) {
            return (Trigger) super.setOauthToken(oauthToken);
          }

          @Override
          public Trigger setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Trigger) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Trigger setQuotaUser(java.lang.String quotaUser) {
            return (Trigger) super.setQuotaUser(quotaUser);
          }

          @Override
          public Trigger setUploadType(java.lang.String uploadType) {
            return (Trigger) super.setUploadType(uploadType);
          }

          @Override
          public Trigger setUploadProtocol(java.lang.String uploadProtocol) {
            return (Trigger) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Format:
           * `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Format: `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Format:
           * `parent=projects/{project_id}/locations/{location}/schedules/{schedule_id}`
           */
          public Trigger setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^projects/[^/]+/locations/[^/]+/schedules/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Trigger set(String parameterName, Object value) {
            return (Trigger) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * Builder for {@link AIPlatformNotebooks}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link AIPlatformNotebooks}. */
    @Override
    public AIPlatformNotebooks build() {
      return new AIPlatformNotebooks(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link AIPlatformNotebooksRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setAIPlatformNotebooksRequestInitializer(
        AIPlatformNotebooksRequestInitializer aiplatformnotebooksRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(aiplatformnotebooksRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
