/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * An instance-attached disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Disk extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoDelete;

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean boot;

  /**
   * Indicates a unique device name of your choice that is reflected into the /dev/disk/by-
   * id/google-* tree of a Linux operating system running within the instance. This name can be used
   * to reference the device for mounting, resizing, and so on, from within the instance. If not
   * specified, the server chooses a default device name to apply to this disk, in the form
   * persistent-disk-x, where x is a number assigned by Google Compute Engine.This field is only
   * applicable for persistent disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceName;

  /**
   * Indicates the size of the disk in base-2 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskSizeGb;

  /**
   * Indicates a list of features to enable on the guest operating system. Applicable only for
   * bootable images. Read Enabling guest operating system features to see a list of available
   * options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<GuestOsFeature> guestOsFeatures;

  /**
   * A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks
   * attached to an instance, each disk would have a unique index number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long index;

  /**
   * Indicates the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * NVME * SCSI
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("interface")
  private java.lang.String interface__;

  /**
   * Type of the resource. Always compute#attachedDisk for attached disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A list of publicly visible licenses. Reserved for Google's use. A License represents billing
   * and aggregate usage data for public and marketplace images.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> licenses;

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Indicates a valid partial or full URL to an existing Persistent Disk resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * Indicates the type of the disk, either SCRATCH or PERSISTENT. Valid values: * PERSISTENT *
   * SCRATCH
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Indicates whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoDelete() {
    return autoDelete;
  }

  /**
   * Indicates whether the disk will be auto-deleted when the instance is deleted (but not when the
   * disk is detached from the instance).
   * @param autoDelete autoDelete or {@code null} for none
   */
  public Disk setAutoDelete(java.lang.Boolean autoDelete) {
    this.autoDelete = autoDelete;
    return this;
  }

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBoot() {
    return boot;
  }

  /**
   * Indicates that this is a boot disk. The virtual machine will use the first partition of the
   * disk for its root filesystem.
   * @param boot boot or {@code null} for none
   */
  public Disk setBoot(java.lang.Boolean boot) {
    this.boot = boot;
    return this;
  }

  /**
   * Indicates a unique device name of your choice that is reflected into the /dev/disk/by-
   * id/google-* tree of a Linux operating system running within the instance. This name can be used
   * to reference the device for mounting, resizing, and so on, from within the instance. If not
   * specified, the server chooses a default device name to apply to this disk, in the form
   * persistent-disk-x, where x is a number assigned by Google Compute Engine.This field is only
   * applicable for persistent disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceName() {
    return deviceName;
  }

  /**
   * Indicates a unique device name of your choice that is reflected into the /dev/disk/by-
   * id/google-* tree of a Linux operating system running within the instance. This name can be used
   * to reference the device for mounting, resizing, and so on, from within the instance. If not
   * specified, the server chooses a default device name to apply to this disk, in the form
   * persistent-disk-x, where x is a number assigned by Google Compute Engine.This field is only
   * applicable for persistent disks.
   * @param deviceName deviceName or {@code null} for none
   */
  public Disk setDeviceName(java.lang.String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

  /**
   * Indicates the size of the disk in base-2 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Indicates the size of the disk in base-2 GB.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public Disk setDiskSizeGb(java.lang.Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * Indicates a list of features to enable on the guest operating system. Applicable only for
   * bootable images. Read Enabling guest operating system features to see a list of available
   * options.
   * @return value or {@code null} for none
   */
  public java.util.List<GuestOsFeature> getGuestOsFeatures() {
    return guestOsFeatures;
  }

  /**
   * Indicates a list of features to enable on the guest operating system. Applicable only for
   * bootable images. Read Enabling guest operating system features to see a list of available
   * options.
   * @param guestOsFeatures guestOsFeatures or {@code null} for none
   */
  public Disk setGuestOsFeatures(java.util.List<GuestOsFeature> guestOsFeatures) {
    this.guestOsFeatures = guestOsFeatures;
    return this;
  }

  /**
   * A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks
   * attached to an instance, each disk would have a unique index number.
   * @return value or {@code null} for none
   */
  public java.lang.Long getIndex() {
    return index;
  }

  /**
   * A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks
   * attached to an instance, each disk would have a unique index number.
   * @param index index or {@code null} for none
   */
  public Disk setIndex(java.lang.Long index) {
    this.index = index;
    return this;
  }

  /**
   * Indicates the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * NVME * SCSI
   * @return value or {@code null} for none
   */
  public java.lang.String getInterface() {
    return interface__;
  }

  /**
   * Indicates the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * NVME * SCSI
   * @param interface__ interface__ or {@code null} for none
   */
  public Disk setInterface(java.lang.String interface__) {
    this.interface__ = interface__;
    return this;
  }

  /**
   * Type of the resource. Always compute#attachedDisk for attached disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource. Always compute#attachedDisk for attached disks.
   * @param kind kind or {@code null} for none
   */
  public Disk setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A list of publicly visible licenses. Reserved for Google's use. A License represents billing
   * and aggregate usage data for public and marketplace images.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLicenses() {
    return licenses;
  }

  /**
   * A list of publicly visible licenses. Reserved for Google's use. A License represents billing
   * and aggregate usage data for public and marketplace images.
   * @param licenses licenses or {@code null} for none
   */
  public Disk setLicenses(java.util.List<java.lang.String> licenses) {
    this.licenses = licenses;
    return this;
  }

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the
   * default is to attach the disk in READ_WRITE mode. Valid values: * READ_ONLY * READ_WRITE
   * @param mode mode or {@code null} for none
   */
  public Disk setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Indicates a valid partial or full URL to an existing Persistent Disk resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * Indicates a valid partial or full URL to an existing Persistent Disk resource.
   * @param source source or {@code null} for none
   */
  public Disk setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * Indicates the type of the disk, either SCRATCH or PERSISTENT. Valid values: * PERSISTENT *
   * SCRATCH
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Indicates the type of the disk, either SCRATCH or PERSISTENT. Valid values: * PERSISTENT *
   * SCRATCH
   * @param type type or {@code null} for none
   */
  public Disk setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Disk set(String fieldName, Object value) {
    return (Disk) super.set(fieldName, value);
  }

  @Override
  public Disk clone() {
    return (Disk) super.clone();
  }

}
