/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Definition of a software environment that is used to start a notebook instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Environment extends com.google.api.client.json.GenericJson {

  /**
   * Use a container image to start the notebook instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContainerImage containerImage;

  /**
   * Output only. The time at which this environment was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * A brief description of this environment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Display name of this environment for the UI.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. Name of this environment. Format:
   * `projects/{project_id}/locations/{location}/environments/{environment_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Path to a Bash script that automatically runs after a notebook instance fully boots up. The
   * path must be a URL or Cloud Storage path. Example: `"gs://path-to-file/file-name"`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postStartupScript;

  /**
   * Use a Compute Engine VM image to start the notebook instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VmImage vmImage;

  /**
   * Use a container image to start the notebook instance.
   * @return value or {@code null} for none
   */
  public ContainerImage getContainerImage() {
    return containerImage;
  }

  /**
   * Use a container image to start the notebook instance.
   * @param containerImage containerImage or {@code null} for none
   */
  public Environment setContainerImage(ContainerImage containerImage) {
    this.containerImage = containerImage;
    return this;
  }

  /**
   * Output only. The time at which this environment was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. The time at which this environment was created.
   * @param createTime createTime or {@code null} for none
   */
  public Environment setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * A brief description of this environment.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A brief description of this environment.
   * @param description description or {@code null} for none
   */
  public Environment setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Display name of this environment for the UI.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Display name of this environment for the UI.
   * @param displayName displayName or {@code null} for none
   */
  public Environment setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. Name of this environment. Format:
   * `projects/{project_id}/locations/{location}/environments/{environment_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. Name of this environment. Format:
   * `projects/{project_id}/locations/{location}/environments/{environment_id}`
   * @param name name or {@code null} for none
   */
  public Environment setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Path to a Bash script that automatically runs after a notebook instance fully boots up. The
   * path must be a URL or Cloud Storage path. Example: `"gs://path-to-file/file-name"`
   * @return value or {@code null} for none
   */
  public java.lang.String getPostStartupScript() {
    return postStartupScript;
  }

  /**
   * Path to a Bash script that automatically runs after a notebook instance fully boots up. The
   * path must be a URL or Cloud Storage path. Example: `"gs://path-to-file/file-name"`
   * @param postStartupScript postStartupScript or {@code null} for none
   */
  public Environment setPostStartupScript(java.lang.String postStartupScript) {
    this.postStartupScript = postStartupScript;
    return this;
  }

  /**
   * Use a Compute Engine VM image to start the notebook instance.
   * @return value or {@code null} for none
   */
  public VmImage getVmImage() {
    return vmImage;
  }

  /**
   * Use a Compute Engine VM image to start the notebook instance.
   * @param vmImage vmImage or {@code null} for none
   */
  public Environment setVmImage(VmImage vmImage) {
    this.vmImage = vmImage;
    return this;
  }

  @Override
  public Environment set(String fieldName, Object value) {
    return (Environment) super.set(fieldName, value);
  }

  @Override
  public Environment clone() {
    return (Environment) super.clone();
  }

}
