/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * The definition of an Event for a managed / semi-managed notebook instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Event extends com.google.api.client.json.GenericJson {

  /**
   * Event report time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String reportTime;

  /**
   * Event type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Event report time.
   * @return value or {@code null} for none
   */
  public String getReportTime() {
    return reportTime;
  }

  /**
   * Event report time.
   * @param reportTime reportTime or {@code null} for none
   */
  public Event setReportTime(String reportTime) {
    this.reportTime = reportTime;
    return this;
  }

  /**
   * Event type.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Event type.
   * @param type type or {@code null} for none
   */
  public Event setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Event set(String fieldName, Object value) {
    return (Event) super.set(fieldName, value);
  }

  @Override
  public Event clone() {
    return (Event) super.clone();
  }

}
