/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Response for checking if a notebook instance is healthy.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GetInstanceHealthResponse extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Additional information about instance health. Example: healthInfo": {
   * "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status": "-1",
   * "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> healthInfo;

  /**
   * Output only. Runtime health_state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthState;

  /**
   * Output only. Additional information about instance health. Example: healthInfo": {
   * "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status": "-1",
   * "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getHealthInfo() {
    return healthInfo;
  }

  /**
   * Output only. Additional information about instance health. Example: healthInfo": {
   * "docker_proxy_agent_status": "1", "docker_status": "1", "jupyterlab_api_status": "-1",
   * "jupyterlab_status": "-1", "updated": "2020-10-18 09:40:03.573409" }
   * @param healthInfo healthInfo or {@code null} for none
   */
  public GetInstanceHealthResponse setHealthInfo(java.util.Map<String, java.lang.String> healthInfo) {
    this.healthInfo = healthInfo;
    return this;
  }

  /**
   * Output only. Runtime health_state.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthState() {
    return healthState;
  }

  /**
   * Output only. Runtime health_state.
   * @param healthState healthState or {@code null} for none
   */
  public GetInstanceHealthResponse setHealthState(java.lang.String healthState) {
    this.healthState = healthState;
    return this;
  }

  @Override
  public GetInstanceHealthResponse set(String fieldName, Object value) {
    return (GetInstanceHealthResponse) super.set(fieldName, value);
  }

  @Override
  public GetInstanceHealthResponse clone() {
    return (GetInstanceHealthResponse) super.clone();
  }

}
