/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Notebook instance configurations that can be updated.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class InstanceConfig extends com.google.api.client.json.GenericJson {

  /**
   * Verifies core internal services are running.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableHealthMonitoring;

  /**
   * Cron expression in UTC timezone, used to schedule instance auto upgrade. Please follow the
   * [cron format](https://en.wikipedia.org/wiki/Cron).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String notebookUpgradeSchedule;

  /**
   * Verifies core internal services are running.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableHealthMonitoring() {
    return enableHealthMonitoring;
  }

  /**
   * Verifies core internal services are running.
   * @param enableHealthMonitoring enableHealthMonitoring or {@code null} for none
   */
  public InstanceConfig setEnableHealthMonitoring(java.lang.Boolean enableHealthMonitoring) {
    this.enableHealthMonitoring = enableHealthMonitoring;
    return this;
  }

  /**
   * Cron expression in UTC timezone, used to schedule instance auto upgrade. Please follow the
   * [cron format](https://en.wikipedia.org/wiki/Cron).
   * @return value or {@code null} for none
   */
  public java.lang.String getNotebookUpgradeSchedule() {
    return notebookUpgradeSchedule;
  }

  /**
   * Cron expression in UTC timezone, used to schedule instance auto upgrade. Please follow the
   * [cron format](https://en.wikipedia.org/wiki/Cron).
   * @param notebookUpgradeSchedule notebookUpgradeSchedule or {@code null} for none
   */
  public InstanceConfig setNotebookUpgradeSchedule(java.lang.String notebookUpgradeSchedule) {
    this.notebookUpgradeSchedule = notebookUpgradeSchedule;
    return this;
  }

  @Override
  public InstanceConfig set(String fieldName, Object value) {
    return (InstanceConfig) super.set(fieldName, value);
  }

  @Override
  public InstanceConfig clone() {
    return (InstanceConfig) super.clone();
  }

}
