/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Response for listing scheduled notebook job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListSchedulesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A list of returned instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Schedule> schedules;

  /**
   * Schedules that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/schedules/monthly_digest',
   * 'projects/{project_id}/location/{location}/schedules/weekly_sentiment']
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> unreachable;

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListSchedulesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A list of returned instances.
   * @return value or {@code null} for none
   */
  public java.util.List<Schedule> getSchedules() {
    return schedules;
  }

  /**
   * A list of returned instances.
   * @param schedules schedules or {@code null} for none
   */
  public ListSchedulesResponse setSchedules(java.util.List<Schedule> schedules) {
    this.schedules = schedules;
    return this;
  }

  /**
   * Schedules that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/schedules/monthly_digest',
   * 'projects/{project_id}/location/{location}/schedules/weekly_sentiment']
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUnreachable() {
    return unreachable;
  }

  /**
   * Schedules that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/schedules/monthly_digest',
   * 'projects/{project_id}/location/{location}/schedules/weekly_sentiment']
   * @param unreachable unreachable or {@code null} for none
   */
  public ListSchedulesResponse setUnreachable(java.util.List<java.lang.String> unreachable) {
    this.unreachable = unreachable;
    return this;
  }

  @Override
  public ListSchedulesResponse set(String fieldName, Object value) {
    return (ListSchedulesResponse) super.set(fieldName, value);
  }

  @Override
  public ListSchedulesResponse clone() {
    return (ListSchedulesResponse) super.clone();
  }

}
