/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Request for registering a notebook instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RegisterInstanceRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. User defined unique ID of this instance. The `instance_id` must be 1 to 63 characters
   * long and contain only lowercase letters, numeric characters, and dashes. The first character
   * must be a lowercase letter and the last character cannot be a dash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String instanceId;

  /**
   * Required. User defined unique ID of this instance. The `instance_id` must be 1 to 63 characters
   * long and contain only lowercase letters, numeric characters, and dashes. The first character
   * must be a lowercase letter and the last character cannot be a dash.
   * @return value or {@code null} for none
   */
  public java.lang.String getInstanceId() {
    return instanceId;
  }

  /**
   * Required. User defined unique ID of this instance. The `instance_id` must be 1 to 63 characters
   * long and contain only lowercase letters, numeric characters, and dashes. The first character
   * must be a lowercase letter and the last character cannot be a dash.
   * @param instanceId instanceId or {@code null} for none
   */
  public RegisterInstanceRequest setInstanceId(java.lang.String instanceId) {
    this.instanceId = instanceId;
    return this;
  }

  @Override
  public RegisterInstanceRequest set(String fieldName, Object value) {
    return (RegisterInstanceRequest) super.set(fieldName, value);
  }

  @Override
  public RegisterInstanceRequest clone() {
    return (RegisterInstanceRequest) super.clone();
  }

}
