/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * The definition of a Runtime for a managed notebook instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Runtime extends com.google.api.client.json.GenericJson {

  /**
   * The config settings for accessing runtime.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeAccessConfig accessConfig;

  /**
   * Output only. Runtime creation time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. Runtime health_state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String healthState;

  /**
   * Output only. Contains Runtime daemon metrics such as Service status and JupyterLab stats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeMetrics metrics;

  /**
   * Output only. The resource name of the runtime. Format:
   * `projects/{project}/locations/{location}/runtimes/{runtimeId}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The config settings for software inside the runtime.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RuntimeSoftwareConfig softwareConfig;

  /**
   * Output only. Runtime state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Output only. Runtime update time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Use a Compute Engine VM image to start the managed notebook instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VirtualMachine virtualMachine;

  /**
   * The config settings for accessing runtime.
   * @return value or {@code null} for none
   */
  public RuntimeAccessConfig getAccessConfig() {
    return accessConfig;
  }

  /**
   * The config settings for accessing runtime.
   * @param accessConfig accessConfig or {@code null} for none
   */
  public Runtime setAccessConfig(RuntimeAccessConfig accessConfig) {
    this.accessConfig = accessConfig;
    return this;
  }

  /**
   * Output only. Runtime creation time.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Runtime creation time.
   * @param createTime createTime or {@code null} for none
   */
  public Runtime setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. Runtime health_state.
   * @return value or {@code null} for none
   */
  public java.lang.String getHealthState() {
    return healthState;
  }

  /**
   * Output only. Runtime health_state.
   * @param healthState healthState or {@code null} for none
   */
  public Runtime setHealthState(java.lang.String healthState) {
    this.healthState = healthState;
    return this;
  }

  /**
   * Output only. Contains Runtime daemon metrics such as Service status and JupyterLab stats.
   * @return value or {@code null} for none
   */
  public RuntimeMetrics getMetrics() {
    return metrics;
  }

  /**
   * Output only. Contains Runtime daemon metrics such as Service status and JupyterLab stats.
   * @param metrics metrics or {@code null} for none
   */
  public Runtime setMetrics(RuntimeMetrics metrics) {
    this.metrics = metrics;
    return this;
  }

  /**
   * Output only. The resource name of the runtime. Format:
   * `projects/{project}/locations/{location}/runtimes/{runtimeId}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The resource name of the runtime. Format:
   * `projects/{project}/locations/{location}/runtimes/{runtimeId}`
   * @param name name or {@code null} for none
   */
  public Runtime setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The config settings for software inside the runtime.
   * @return value or {@code null} for none
   */
  public RuntimeSoftwareConfig getSoftwareConfig() {
    return softwareConfig;
  }

  /**
   * The config settings for software inside the runtime.
   * @param softwareConfig softwareConfig or {@code null} for none
   */
  public Runtime setSoftwareConfig(RuntimeSoftwareConfig softwareConfig) {
    this.softwareConfig = softwareConfig;
    return this;
  }

  /**
   * Output only. Runtime state.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * Output only. Runtime state.
   * @param state state or {@code null} for none
   */
  public Runtime setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. Runtime update time.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Runtime update time.
   * @param updateTime updateTime or {@code null} for none
   */
  public Runtime setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  /**
   * Use a Compute Engine VM image to start the managed notebook instance.
   * @return value or {@code null} for none
   */
  public VirtualMachine getVirtualMachine() {
    return virtualMachine;
  }

  /**
   * Use a Compute Engine VM image to start the managed notebook instance.
   * @param virtualMachine virtualMachine or {@code null} for none
   */
  public Runtime setVirtualMachine(VirtualMachine virtualMachine) {
    this.virtualMachine = virtualMachine;
    return this;
  }

  @Override
  public Runtime set(String fieldName, Object value) {
    return (Runtime) super.set(fieldName, value);
  }

  @Override
  public Runtime clone() {
    return (Runtime) super.clone();
  }

}
