/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * The definition of a schedule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Schedule extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Time the schedule was created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Cron-tab formatted schedule by which the job will execute. Format: minute, hour, day of month,
   * month, day of week, e.g. 0 0 * * WED = every Wednesday More examples:
   * https://crontab.guru/examples.html
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String cronSchedule;

  /**
   * A brief description of this environment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. Display name used for UI purposes. Name can only contain alphanumeric characters,
   * hyphens '-', and underscores '_'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Notebook Execution Template corresponding to this schedule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ExecutionTemplate executionTemplate;

  /**
   * Output only. The name of this schedule. Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The most recent execution names triggered from this schedule and their
   * corresponding states.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Execution> recentExecutions;

  static {
    // hack to force ProGuard to consider Execution used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Execution.class);
  }

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Timezone on which the cron_schedule. The value of this field must be a time zone name from the
   * tz database. TZ Database: https://en.wikipedia.org/wiki/List_of_tz_database_time_zones Note
   * that some time zones include a provision for daylight savings time. The rules for daylight
   * saving time are determined by the chosen tz. For UTC use the string "utc". If a time zone is
   * not specified, the default will be in UTC (also known as GMT).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Output only. Time the schedule was last updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateTime;

  /**
   * Output only. Time the schedule was created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Time the schedule was created.
   * @param createTime createTime or {@code null} for none
   */
  public Schedule setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Cron-tab formatted schedule by which the job will execute. Format: minute, hour, day of month,
   * month, day of week, e.g. 0 0 * * WED = every Wednesday More examples:
   * https://crontab.guru/examples.html
   * @return value or {@code null} for none
   */
  public java.lang.String getCronSchedule() {
    return cronSchedule;
  }

  /**
   * Cron-tab formatted schedule by which the job will execute. Format: minute, hour, day of month,
   * month, day of week, e.g. 0 0 * * WED = every Wednesday More examples:
   * https://crontab.guru/examples.html
   * @param cronSchedule cronSchedule or {@code null} for none
   */
  public Schedule setCronSchedule(java.lang.String cronSchedule) {
    this.cronSchedule = cronSchedule;
    return this;
  }

  /**
   * A brief description of this environment.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A brief description of this environment.
   * @param description description or {@code null} for none
   */
  public Schedule setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. Display name used for UI purposes. Name can only contain alphanumeric characters,
   * hyphens '-', and underscores '_'.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * Output only. Display name used for UI purposes. Name can only contain alphanumeric characters,
   * hyphens '-', and underscores '_'.
   * @param displayName displayName or {@code null} for none
   */
  public Schedule setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Notebook Execution Template corresponding to this schedule.
   * @return value or {@code null} for none
   */
  public ExecutionTemplate getExecutionTemplate() {
    return executionTemplate;
  }

  /**
   * Notebook Execution Template corresponding to this schedule.
   * @param executionTemplate executionTemplate or {@code null} for none
   */
  public Schedule setExecutionTemplate(ExecutionTemplate executionTemplate) {
    this.executionTemplate = executionTemplate;
    return this;
  }

  /**
   * Output only. The name of this schedule. Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Output only. The name of this schedule. Format:
   * `projects/{project_id}/locations/{location}/schedules/{schedule_id}`
   * @param name name or {@code null} for none
   */
  public Schedule setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The most recent execution names triggered from this schedule and their
   * corresponding states.
   * @return value or {@code null} for none
   */
  public java.util.List<Execution> getRecentExecutions() {
    return recentExecutions;
  }

  /**
   * Output only. The most recent execution names triggered from this schedule and their
   * corresponding states.
   * @param recentExecutions recentExecutions or {@code null} for none
   */
  public Schedule setRecentExecutions(java.util.List<Execution> recentExecutions) {
    this.recentExecutions = recentExecutions;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * @param state state or {@code null} for none
   */
  public Schedule setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Timezone on which the cron_schedule. The value of this field must be a time zone name from the
   * tz database. TZ Database: https://en.wikipedia.org/wiki/List_of_tz_database_time_zones Note
   * that some time zones include a provision for daylight savings time. The rules for daylight
   * saving time are determined by the chosen tz. For UTC use the string "utc". If a time zone is
   * not specified, the default will be in UTC (also known as GMT).
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Timezone on which the cron_schedule. The value of this field must be a time zone name from the
   * tz database. TZ Database: https://en.wikipedia.org/wiki/List_of_tz_database_time_zones Note
   * that some time zones include a provision for daylight savings time. The rules for daylight
   * saving time are determined by the chosen tz. For UTC use the string "utc". If a time zone is
   * not specified, the default will be in UTC (also known as GMT).
   * @param timeZone timeZone or {@code null} for none
   */
  public Schedule setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Output only. Time the schedule was last updated.
   * @return value or {@code null} for none
   */
  public String getUpdateTime() {
    return updateTime;
  }

  /**
   * Output only. Time the schedule was last updated.
   * @param updateTime updateTime or {@code null} for none
   */
  public Schedule setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

  @Override
  public Schedule set(String fieldName, Object value) {
    return (Schedule) super.set(fieldName, value);
  }

  @Override
  public Schedule clone() {
    return (Schedule) super.clone();
  }

}
