/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Request for setting instance accelerator.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class SetInstanceAcceleratorRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Count of cores of this accelerator. Note that not all combinations of `type` and
   * `core_count` are valid. Check [GPUs on Compute
   * Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a valid combination.
   * TPUs are not supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long coreCount;

  /**
   * Required. Type of this accelerator.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Required. Count of cores of this accelerator. Note that not all combinations of `type` and
   * `core_count` are valid. Check [GPUs on Compute
   * Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a valid combination.
   * TPUs are not supported.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCoreCount() {
    return coreCount;
  }

  /**
   * Required. Count of cores of this accelerator. Note that not all combinations of `type` and
   * `core_count` are valid. Check [GPUs on Compute
   * Engine](https://cloud.google.com/compute/docs/gpus/#gpus-list) to find a valid combination.
   * TPUs are not supported.
   * @param coreCount coreCount or {@code null} for none
   */
  public SetInstanceAcceleratorRequest setCoreCount(java.lang.Long coreCount) {
    this.coreCount = coreCount;
    return this;
  }

  /**
   * Required. Type of this accelerator.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Type of this accelerator.
   * @param type type or {@code null} for none
   */
  public SetInstanceAcceleratorRequest setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public SetInstanceAcceleratorRequest set(String fieldName, Object value) {
    return (SetInstanceAcceleratorRequest) super.set(fieldName, value);
  }

  @Override
  public SetInstanceAcceleratorRequest clone() {
    return (SetInstanceAcceleratorRequest) super.clone();
  }

}
