/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Definition of a container image for starting a notebook instance with the environment installed
 * in a container.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContainerImage extends com.google.api.client.json.GenericJson {

  /**
   * Required. The path to the container image repository. For example:
   * `gcr.io/{project_id}/{image_name}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String repository;

  /**
   * The tag of the container image. If not specified, this defaults to the latest tag.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tag;

  /**
   * Required. The path to the container image repository. For example:
   * `gcr.io/{project_id}/{image_name}`
   * @return value or {@code null} for none
   */
  public java.lang.String getRepository() {
    return repository;
  }

  /**
   * Required. The path to the container image repository. For example:
   * `gcr.io/{project_id}/{image_name}`
   * @param repository repository or {@code null} for none
   */
  public ContainerImage setRepository(java.lang.String repository) {
    this.repository = repository;
    return this;
  }

  /**
   * The tag of the container image. If not specified, this defaults to the latest tag.
   * @return value or {@code null} for none
   */
  public java.lang.String getTag() {
    return tag;
  }

  /**
   * The tag of the container image. If not specified, this defaults to the latest tag.
   * @param tag tag or {@code null} for none
   */
  public ContainerImage setTag(java.lang.String tag) {
    this.tag = tag;
    return this;
  }

  @Override
  public ContainerImage set(String fieldName, Object value) {
    return (ContainerImage) super.set(fieldName, value);
  }

  @Override
  public ContainerImage clone() {
    return (ContainerImage) super.clone();
  }

}
