/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Request for creating a notebook instance diagnostic file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiagnoseRuntimeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. Defines flags that are used to run the diagnostic tool
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DiagnosticConfig diagnosticConfig;

  /**
   * Optional. Maximum amount of time in minutes before the operation times out.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer timeoutMinutes;

  /**
   * Required. Defines flags that are used to run the diagnostic tool
   * @return value or {@code null} for none
   */
  public DiagnosticConfig getDiagnosticConfig() {
    return diagnosticConfig;
  }

  /**
   * Required. Defines flags that are used to run the diagnostic tool
   * @param diagnosticConfig diagnosticConfig or {@code null} for none
   */
  public DiagnoseRuntimeRequest setDiagnosticConfig(DiagnosticConfig diagnosticConfig) {
    this.diagnosticConfig = diagnosticConfig;
    return this;
  }

  /**
   * Optional. Maximum amount of time in minutes before the operation times out.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTimeoutMinutes() {
    return timeoutMinutes;
  }

  /**
   * Optional. Maximum amount of time in minutes before the operation times out.
   * @param timeoutMinutes timeoutMinutes or {@code null} for none
   */
  public DiagnoseRuntimeRequest setTimeoutMinutes(java.lang.Integer timeoutMinutes) {
    this.timeoutMinutes = timeoutMinutes;
    return this;
  }

  @Override
  public DiagnoseRuntimeRequest set(String fieldName, Object value) {
    return (DiagnoseRuntimeRequest) super.set(fieldName, value);
  }

  @Override
  public DiagnoseRuntimeRequest clone() {
    return (DiagnoseRuntimeRequest) super.clone();
  }

}
