/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Defines flags that are used to run the diagnostic tool
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DiagnosticConfig extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Enables flag to copy all `/home/jupyter` folder contents
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copyHomeFilesFlagEnabled;

  /**
   * Required. User Cloud Storage bucket location (REQUIRED). Must be formatted with path prefix
   * (`gs://$GCS_BUCKET`). Permissions: User Managed Notebooks: - storage.buckets.writer: Must be
   * given to the project's service account attached to VM. Google Managed Notebooks: -
   * storage.buckets.writer: Must be given to the project's service account or user credentials
   * attached to VM depending on authentication mode. Cloud Storage bucket Log file will be written
   * to `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gcsBucket;

  /**
   * Optional. Enables flag to capture packets from the instance for 30 seconds
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean packetCaptureFlagEnabled;

  /**
   * Optional. Defines the relative storage path in the Cloud Storage bucket where the diagnostic
   * logs will be written: Default path will be the root directory of the Cloud Storage bucket
   * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file will be written:
   * `gs://$GCS_BUCKET/$RELATIVE_PATH/`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String relativePath;

  /**
   * Optional. Enables flag to repair service for instance
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean repairFlagEnabled;

  /**
   * Optional. Enables flag to copy all `/home/jupyter` folder contents
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopyHomeFilesFlagEnabled() {
    return copyHomeFilesFlagEnabled;
  }

  /**
   * Optional. Enables flag to copy all `/home/jupyter` folder contents
   * @param copyHomeFilesFlagEnabled copyHomeFilesFlagEnabled or {@code null} for none
   */
  public DiagnosticConfig setCopyHomeFilesFlagEnabled(java.lang.Boolean copyHomeFilesFlagEnabled) {
    this.copyHomeFilesFlagEnabled = copyHomeFilesFlagEnabled;
    return this;
  }

  /**
   * Required. User Cloud Storage bucket location (REQUIRED). Must be formatted with path prefix
   * (`gs://$GCS_BUCKET`). Permissions: User Managed Notebooks: - storage.buckets.writer: Must be
   * given to the project's service account attached to VM. Google Managed Notebooks: -
   * storage.buckets.writer: Must be given to the project's service account or user credentials
   * attached to VM depending on authentication mode. Cloud Storage bucket Log file will be written
   * to `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
   * @return value or {@code null} for none
   */
  public java.lang.String getGcsBucket() {
    return gcsBucket;
  }

  /**
   * Required. User Cloud Storage bucket location (REQUIRED). Must be formatted with path prefix
   * (`gs://$GCS_BUCKET`). Permissions: User Managed Notebooks: - storage.buckets.writer: Must be
   * given to the project's service account attached to VM. Google Managed Notebooks: -
   * storage.buckets.writer: Must be given to the project's service account or user credentials
   * attached to VM depending on authentication mode. Cloud Storage bucket Log file will be written
   * to `gs://$GCS_BUCKET/$RELATIVE_PATH/$VM_DATE_$TIME.tar.gz`
   * @param gcsBucket gcsBucket or {@code null} for none
   */
  public DiagnosticConfig setGcsBucket(java.lang.String gcsBucket) {
    this.gcsBucket = gcsBucket;
    return this;
  }

  /**
   * Optional. Enables flag to capture packets from the instance for 30 seconds
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPacketCaptureFlagEnabled() {
    return packetCaptureFlagEnabled;
  }

  /**
   * Optional. Enables flag to capture packets from the instance for 30 seconds
   * @param packetCaptureFlagEnabled packetCaptureFlagEnabled or {@code null} for none
   */
  public DiagnosticConfig setPacketCaptureFlagEnabled(java.lang.Boolean packetCaptureFlagEnabled) {
    this.packetCaptureFlagEnabled = packetCaptureFlagEnabled;
    return this;
  }

  /**
   * Optional. Defines the relative storage path in the Cloud Storage bucket where the diagnostic
   * logs will be written: Default path will be the root directory of the Cloud Storage bucket
   * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file will be written:
   * `gs://$GCS_BUCKET/$RELATIVE_PATH/`
   * @return value or {@code null} for none
   */
  public java.lang.String getRelativePath() {
    return relativePath;
  }

  /**
   * Optional. Defines the relative storage path in the Cloud Storage bucket where the diagnostic
   * logs will be written: Default path will be the root directory of the Cloud Storage bucket
   * (`gs://$GCS_BUCKET/$DATE_$TIME.tar.gz`) Example of full path where Log file will be written:
   * `gs://$GCS_BUCKET/$RELATIVE_PATH/`
   * @param relativePath relativePath or {@code null} for none
   */
  public DiagnosticConfig setRelativePath(java.lang.String relativePath) {
    this.relativePath = relativePath;
    return this;
  }

  /**
   * Optional. Enables flag to repair service for instance
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRepairFlagEnabled() {
    return repairFlagEnabled;
  }

  /**
   * Optional. Enables flag to repair service for instance
   * @param repairFlagEnabled repairFlagEnabled or {@code null} for none
   */
  public DiagnosticConfig setRepairFlagEnabled(java.lang.Boolean repairFlagEnabled) {
    this.repairFlagEnabled = repairFlagEnabled;
    return this;
  }

  @Override
  public DiagnosticConfig set(String fieldName, Object value) {
    return (DiagnosticConfig) super.set(fieldName, value);
  }

  @Override
  public DiagnosticConfig clone() {
    return (DiagnosticConfig) super.clone();
  }

}
