/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * The description a notebook execution workload.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ExecutionTemplate extends com.google.api.client.json.GenericJson {

  /**
   * Configuration (count and accelerator type) for hardware running notebook execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SchedulerAcceleratorConfig acceleratorConfig;

  /**
   * Container Image URI to a DLVM Example: 'gcr.io/deeplearning-platform-release/base-cu100' More
   * examples can be found at: https://cloud.google.com/ai-platform/deep-learning-
   * containers/docs/choosing-container
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String containerImageUri;

  /**
   * Parameters used in Dataproc JobType executions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataprocParameters dataprocParameters;

  /**
   * Path to the notebook file to execute. Must be in a Google Cloud Storage bucket. Format:
   * `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String inputNotebookFile;

  /**
   * The type of Job to be used on this execution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String jobType;

  /**
   * Name of the kernel spec to use. This must be specified if the kernel spec name on the execution
   * target does not match the name in the input notebook file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kernelSpec;

  /**
   * Labels for execution. If execution is scheduled, a field included will be 'nbs-scheduled'.
   * Otherwise, it is an immediate execution, and an included field will be 'nbs-immediate'. Use
   * fields to efficiently index between various types of executions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Specifies the type of virtual machine to use for your training job's master worker. You must
   * specify this field when `scaleTier` is set to `CUSTOM`. You can use certain Compute Engine
   * machine types directly in this field. The following types are supported: - `n1-standard-4` -
   * `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` - `n1-standard-96` -
   * `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` -
   * `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` -
   * `n1-highcpu-96` Alternatively, you can use the following legacy machine types: - `standard` -
   * `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l` - `standard_gpu` -
   * `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` - `complex_model_m_p100` -
   * `standard_v100` - `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100` Finally,
   * if you want to use a TPU for training, specify `cloud_tpu` in this field. Learn more about the
   * [special configuration options for training with TPU](https://cloud.google.com/ai-
   * platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String masterType;

  /**
   * Path to the notebook folder to write to. Must be in a Google Cloud Storage bucket path. Format:
   * `gs://{bucket_name}/{folder}` Ex: `gs://notebook_user/scheduled_notebooks`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String outputNotebookFolder;

  /**
   * Parameters used within the 'input_notebook_file' notebook.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parameters;

  /**
   * Parameters to be overridden in the notebook during execution. Ref
   * https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to specifying
   * parameters in the input notebook and pass them here in an YAML file. Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String paramsYamlFile;

  /**
   * Required. Scale tier of the hardware used for notebook execution. DEPRECATED Will be
   * discontinued. As right now only CUSTOM is supported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scaleTier;

  /**
   * The email address of a service account to use when running the execution. You must have the
   * `iam.serviceAccounts.actAs` permission for the specified service account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceAccount;

  /**
   * The name of a Vertex AI [Tensorboard] resource to which this execution will upload Tensorboard
   * logs. Format: `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tensorboard;

  /**
   * Parameters used in Vertex AI JobType executions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VertexAIParameters vertexAiParameters;

  /**
   * Configuration (count and accelerator type) for hardware running notebook execution.
   * @return value or {@code null} for none
   */
  public SchedulerAcceleratorConfig getAcceleratorConfig() {
    return acceleratorConfig;
  }

  /**
   * Configuration (count and accelerator type) for hardware running notebook execution.
   * @param acceleratorConfig acceleratorConfig or {@code null} for none
   */
  public ExecutionTemplate setAcceleratorConfig(SchedulerAcceleratorConfig acceleratorConfig) {
    this.acceleratorConfig = acceleratorConfig;
    return this;
  }

  /**
   * Container Image URI to a DLVM Example: 'gcr.io/deeplearning-platform-release/base-cu100' More
   * examples can be found at: https://cloud.google.com/ai-platform/deep-learning-
   * containers/docs/choosing-container
   * @return value or {@code null} for none
   */
  public java.lang.String getContainerImageUri() {
    return containerImageUri;
  }

  /**
   * Container Image URI to a DLVM Example: 'gcr.io/deeplearning-platform-release/base-cu100' More
   * examples can be found at: https://cloud.google.com/ai-platform/deep-learning-
   * containers/docs/choosing-container
   * @param containerImageUri containerImageUri or {@code null} for none
   */
  public ExecutionTemplate setContainerImageUri(java.lang.String containerImageUri) {
    this.containerImageUri = containerImageUri;
    return this;
  }

  /**
   * Parameters used in Dataproc JobType executions.
   * @return value or {@code null} for none
   */
  public DataprocParameters getDataprocParameters() {
    return dataprocParameters;
  }

  /**
   * Parameters used in Dataproc JobType executions.
   * @param dataprocParameters dataprocParameters or {@code null} for none
   */
  public ExecutionTemplate setDataprocParameters(DataprocParameters dataprocParameters) {
    this.dataprocParameters = dataprocParameters;
    return this;
  }

  /**
   * Path to the notebook file to execute. Must be in a Google Cloud Storage bucket. Format:
   * `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
   * @return value or {@code null} for none
   */
  public java.lang.String getInputNotebookFile() {
    return inputNotebookFile;
  }

  /**
   * Path to the notebook file to execute. Must be in a Google Cloud Storage bucket. Format:
   * `gs://{bucket_name}/{folder}/{notebook_file_name}` Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook.ipynb`
   * @param inputNotebookFile inputNotebookFile or {@code null} for none
   */
  public ExecutionTemplate setInputNotebookFile(java.lang.String inputNotebookFile) {
    this.inputNotebookFile = inputNotebookFile;
    return this;
  }

  /**
   * The type of Job to be used on this execution.
   * @return value or {@code null} for none
   */
  public java.lang.String getJobType() {
    return jobType;
  }

  /**
   * The type of Job to be used on this execution.
   * @param jobType jobType or {@code null} for none
   */
  public ExecutionTemplate setJobType(java.lang.String jobType) {
    this.jobType = jobType;
    return this;
  }

  /**
   * Name of the kernel spec to use. This must be specified if the kernel spec name on the execution
   * target does not match the name in the input notebook file.
   * @return value or {@code null} for none
   */
  public java.lang.String getKernelSpec() {
    return kernelSpec;
  }

  /**
   * Name of the kernel spec to use. This must be specified if the kernel spec name on the execution
   * target does not match the name in the input notebook file.
   * @param kernelSpec kernelSpec or {@code null} for none
   */
  public ExecutionTemplate setKernelSpec(java.lang.String kernelSpec) {
    this.kernelSpec = kernelSpec;
    return this;
  }

  /**
   * Labels for execution. If execution is scheduled, a field included will be 'nbs-scheduled'.
   * Otherwise, it is an immediate execution, and an included field will be 'nbs-immediate'. Use
   * fields to efficiently index between various types of executions.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Labels for execution. If execution is scheduled, a field included will be 'nbs-scheduled'.
   * Otherwise, it is an immediate execution, and an included field will be 'nbs-immediate'. Use
   * fields to efficiently index between various types of executions.
   * @param labels labels or {@code null} for none
   */
  public ExecutionTemplate setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Specifies the type of virtual machine to use for your training job's master worker. You must
   * specify this field when `scaleTier` is set to `CUSTOM`. You can use certain Compute Engine
   * machine types directly in this field. The following types are supported: - `n1-standard-4` -
   * `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` - `n1-standard-96` -
   * `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` -
   * `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` -
   * `n1-highcpu-96` Alternatively, you can use the following legacy machine types: - `standard` -
   * `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l` - `standard_gpu` -
   * `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` - `complex_model_m_p100` -
   * `standard_v100` - `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100` Finally,
   * if you want to use a TPU for training, specify `cloud_tpu` in this field. Learn more about the
   * [special configuration options for training with TPU](https://cloud.google.com/ai-
   * platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
   * @return value or {@code null} for none
   */
  public java.lang.String getMasterType() {
    return masterType;
  }

  /**
   * Specifies the type of virtual machine to use for your training job's master worker. You must
   * specify this field when `scaleTier` is set to `CUSTOM`. You can use certain Compute Engine
   * machine types directly in this field. The following types are supported: - `n1-standard-4` -
   * `n1-standard-8` - `n1-standard-16` - `n1-standard-32` - `n1-standard-64` - `n1-standard-96` -
   * `n1-highmem-2` - `n1-highmem-4` - `n1-highmem-8` - `n1-highmem-16` - `n1-highmem-32` -
   * `n1-highmem-64` - `n1-highmem-96` - `n1-highcpu-16` - `n1-highcpu-32` - `n1-highcpu-64` -
   * `n1-highcpu-96` Alternatively, you can use the following legacy machine types: - `standard` -
   * `large_model` - `complex_model_s` - `complex_model_m` - `complex_model_l` - `standard_gpu` -
   * `complex_model_m_gpu` - `complex_model_l_gpu` - `standard_p100` - `complex_model_m_p100` -
   * `standard_v100` - `large_model_v100` - `complex_model_m_v100` - `complex_model_l_v100` Finally,
   * if you want to use a TPU for training, specify `cloud_tpu` in this field. Learn more about the
   * [special configuration options for training with TPU](https://cloud.google.com/ai-
   * platform/training/docs/using-tpus#configuring_a_custom_tpu_machine).
   * @param masterType masterType or {@code null} for none
   */
  public ExecutionTemplate setMasterType(java.lang.String masterType) {
    this.masterType = masterType;
    return this;
  }

  /**
   * Path to the notebook folder to write to. Must be in a Google Cloud Storage bucket path. Format:
   * `gs://{bucket_name}/{folder}` Ex: `gs://notebook_user/scheduled_notebooks`
   * @return value or {@code null} for none
   */
  public java.lang.String getOutputNotebookFolder() {
    return outputNotebookFolder;
  }

  /**
   * Path to the notebook folder to write to. Must be in a Google Cloud Storage bucket path. Format:
   * `gs://{bucket_name}/{folder}` Ex: `gs://notebook_user/scheduled_notebooks`
   * @param outputNotebookFolder outputNotebookFolder or {@code null} for none
   */
  public ExecutionTemplate setOutputNotebookFolder(java.lang.String outputNotebookFolder) {
    this.outputNotebookFolder = outputNotebookFolder;
    return this;
  }

  /**
   * Parameters used within the 'input_notebook_file' notebook.
   * @return value or {@code null} for none
   */
  public java.lang.String getParameters() {
    return parameters;
  }

  /**
   * Parameters used within the 'input_notebook_file' notebook.
   * @param parameters parameters or {@code null} for none
   */
  public ExecutionTemplate setParameters(java.lang.String parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Parameters to be overridden in the notebook during execution. Ref
   * https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to specifying
   * parameters in the input notebook and pass them here in an YAML file. Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
   * @return value or {@code null} for none
   */
  public java.lang.String getParamsYamlFile() {
    return paramsYamlFile;
  }

  /**
   * Parameters to be overridden in the notebook during execution. Ref
   * https://papermill.readthedocs.io/en/latest/usage-parameterize.html on how to specifying
   * parameters in the input notebook and pass them here in an YAML file. Ex:
   * `gs://notebook_user/scheduled_notebooks/sentiment_notebook_params.yaml`
   * @param paramsYamlFile paramsYamlFile or {@code null} for none
   */
  public ExecutionTemplate setParamsYamlFile(java.lang.String paramsYamlFile) {
    this.paramsYamlFile = paramsYamlFile;
    return this;
  }

  /**
   * Required. Scale tier of the hardware used for notebook execution. DEPRECATED Will be
   * discontinued. As right now only CUSTOM is supported.
   * @return value or {@code null} for none
   */
  public java.lang.String getScaleTier() {
    return scaleTier;
  }

  /**
   * Required. Scale tier of the hardware used for notebook execution. DEPRECATED Will be
   * discontinued. As right now only CUSTOM is supported.
   * @param scaleTier scaleTier or {@code null} for none
   */
  public ExecutionTemplate setScaleTier(java.lang.String scaleTier) {
    this.scaleTier = scaleTier;
    return this;
  }

  /**
   * The email address of a service account to use when running the execution. You must have the
   * `iam.serviceAccounts.actAs` permission for the specified service account.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceAccount() {
    return serviceAccount;
  }

  /**
   * The email address of a service account to use when running the execution. You must have the
   * `iam.serviceAccounts.actAs` permission for the specified service account.
   * @param serviceAccount serviceAccount or {@code null} for none
   */
  public ExecutionTemplate setServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

  /**
   * The name of a Vertex AI [Tensorboard] resource to which this execution will upload Tensorboard
   * logs. Format: `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * @return value or {@code null} for none
   */
  public java.lang.String getTensorboard() {
    return tensorboard;
  }

  /**
   * The name of a Vertex AI [Tensorboard] resource to which this execution will upload Tensorboard
   * logs. Format: `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
   * @param tensorboard tensorboard or {@code null} for none
   */
  public ExecutionTemplate setTensorboard(java.lang.String tensorboard) {
    this.tensorboard = tensorboard;
    return this;
  }

  /**
   * Parameters used in Vertex AI JobType executions.
   * @return value or {@code null} for none
   */
  public VertexAIParameters getVertexAiParameters() {
    return vertexAiParameters;
  }

  /**
   * Parameters used in Vertex AI JobType executions.
   * @param vertexAiParameters vertexAiParameters or {@code null} for none
   */
  public ExecutionTemplate setVertexAiParameters(VertexAIParameters vertexAiParameters) {
    this.vertexAiParameters = vertexAiParameters;
    return this;
  }

  @Override
  public ExecutionTemplate set(String fieldName, Object value) {
    return (ExecutionTemplate) super.set(fieldName, value);
  }

  @Override
  public ExecutionTemplate clone() {
    return (ExecutionTemplate) super.clone();
  }

}
