/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Response for checking if a notebook instance is upgradeable.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class IsInstanceUpgradeableResponse extends com.google.api.client.json.GenericJson {

  /**
   * The new image self link this instance will be upgraded to if calling the upgrade endpoint. This
   * field will only be populated if field upgradeable is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String upgradeImage;

  /**
   * Additional information about upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String upgradeInfo;

  /**
   * The version this instance will be upgraded to if calling the upgrade endpoint. This field will
   * only be populated if field upgradeable is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String upgradeVersion;

  /**
   * If an instance is upgradeable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean upgradeable;

  /**
   * The new image self link this instance will be upgraded to if calling the upgrade endpoint. This
   * field will only be populated if field upgradeable is true.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpgradeImage() {
    return upgradeImage;
  }

  /**
   * The new image self link this instance will be upgraded to if calling the upgrade endpoint. This
   * field will only be populated if field upgradeable is true.
   * @param upgradeImage upgradeImage or {@code null} for none
   */
  public IsInstanceUpgradeableResponse setUpgradeImage(java.lang.String upgradeImage) {
    this.upgradeImage = upgradeImage;
    return this;
  }

  /**
   * Additional information about upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpgradeInfo() {
    return upgradeInfo;
  }

  /**
   * Additional information about upgrade.
   * @param upgradeInfo upgradeInfo or {@code null} for none
   */
  public IsInstanceUpgradeableResponse setUpgradeInfo(java.lang.String upgradeInfo) {
    this.upgradeInfo = upgradeInfo;
    return this;
  }

  /**
   * The version this instance will be upgraded to if calling the upgrade endpoint. This field will
   * only be populated if field upgradeable is true.
   * @return value or {@code null} for none
   */
  public java.lang.String getUpgradeVersion() {
    return upgradeVersion;
  }

  /**
   * The version this instance will be upgraded to if calling the upgrade endpoint. This field will
   * only be populated if field upgradeable is true.
   * @param upgradeVersion upgradeVersion or {@code null} for none
   */
  public IsInstanceUpgradeableResponse setUpgradeVersion(java.lang.String upgradeVersion) {
    this.upgradeVersion = upgradeVersion;
    return this;
  }

  /**
   * If an instance is upgradeable.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUpgradeable() {
    return upgradeable;
  }

  /**
   * If an instance is upgradeable.
   * @param upgradeable upgradeable or {@code null} for none
   */
  public IsInstanceUpgradeableResponse setUpgradeable(java.lang.Boolean upgradeable) {
    this.upgradeable = upgradeable;
    return this;
  }

  @Override
  public IsInstanceUpgradeableResponse set(String fieldName, Object value) {
    return (IsInstanceUpgradeableResponse) super.set(fieldName, value);
  }

  @Override
  public IsInstanceUpgradeableResponse clone() {
    return (IsInstanceUpgradeableResponse) super.clone();
  }

}
