/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Response for listing scheduled notebook executions
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListExecutionsResponse extends com.google.api.client.json.GenericJson {

  /**
   * A list of returned instances.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Execution> executions;

  static {
    // hack to force ProGuard to consider Execution used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Execution.class);
  }

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Executions IDs that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/executions/imagenet_test1',
   * 'projects/{project_id}/location/{location}/executions/classifier_train1']
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> unreachable;

  /**
   * A list of returned instances.
   * @return value or {@code null} for none
   */
  public java.util.List<Execution> getExecutions() {
    return executions;
  }

  /**
   * A list of returned instances.
   * @param executions executions or {@code null} for none
   */
  public ListExecutionsResponse setExecutions(java.util.List<Execution> executions) {
    this.executions = executions;
    return this;
  }

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListExecutionsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * Executions IDs that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/executions/imagenet_test1',
   * 'projects/{project_id}/location/{location}/executions/classifier_train1']
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUnreachable() {
    return unreachable;
  }

  /**
   * Executions IDs that could not be reached. For example:
   * ['projects/{project_id}/location/{location}/executions/imagenet_test1',
   * 'projects/{project_id}/location/{location}/executions/classifier_train1']
   * @param unreachable unreachable or {@code null} for none
   */
  public ListExecutionsResponse setUnreachable(java.util.List<java.lang.String> unreachable) {
    this.unreachable = unreachable;
    return this;
  }

  @Override
  public ListExecutionsResponse set(String fieldName, Object value) {
    return (ListExecutionsResponse) super.set(fieldName, value);
  }

  @Override
  public ListExecutionsResponse clone() {
    return (ListExecutionsResponse) super.clone();
  }

}
