/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Response for listing Managed Notebook Runtimes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListRuntimesResponse extends com.google.api.client.json.GenericJson {

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A list of returned Runtimes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Runtime> runtimes;

  /**
   * Locations that could not be reached. For example, `['us-west1', 'us-central1']`. A
   * ListRuntimesResponse will only contain either runtimes or unreachables,
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> unreachable;

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * Page token that can be used to continue listing from the last result in the next list call.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListRuntimesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A list of returned Runtimes.
   * @return value or {@code null} for none
   */
  public java.util.List<Runtime> getRuntimes() {
    return runtimes;
  }

  /**
   * A list of returned Runtimes.
   * @param runtimes runtimes or {@code null} for none
   */
  public ListRuntimesResponse setRuntimes(java.util.List<Runtime> runtimes) {
    this.runtimes = runtimes;
    return this;
  }

  /**
   * Locations that could not be reached. For example, `['us-west1', 'us-central1']`. A
   * ListRuntimesResponse will only contain either runtimes or unreachables,
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getUnreachable() {
    return unreachable;
  }

  /**
   * Locations that could not be reached. For example, `['us-west1', 'us-central1']`. A
   * ListRuntimesResponse will only contain either runtimes or unreachables,
   * @param unreachable unreachable or {@code null} for none
   */
  public ListRuntimesResponse setUnreachable(java.util.List<java.lang.String> unreachable) {
    this.unreachable = unreachable;
    return this;
  }

  @Override
  public ListRuntimesResponse set(String fieldName, Object value) {
    return (ListRuntimesResponse) super.set(fieldName, value);
  }

  @Override
  public ListRuntimesResponse clone() {
    return (ListRuntimesResponse) super.clone();
  }

}
