/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * A Local attached disk resource.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalDisk extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Output only. Specifies whether the disk will be auto-deleted when the instance is
   * deleted (but not when the disk is detached from the instance).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean autoDelete;

  /**
   * Optional. Output only. Indicates that this is a boot disk. The virtual machine will use the
   * first partition of the disk for its root filesystem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean boot;

  /**
   * Optional. Output only. Specifies a unique device name of your choice that is reflected into the
   * `/dev/disk/by-id/google-*` tree of a Linux operating system running within the instance. This
   * name can be used to reference the device for mounting, resizing, and so on, from within the
   * instance. If not specified, the server chooses a default device name to apply to this disk, in
   * the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field
   * is only applicable for persistent disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String deviceName;

  /**
   * Output only. Indicates a list of features to enable on the guest operating system. Applicable
   * only for bootable images. Read Enabling guest operating system features to see a list of
   * available options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<RuntimeGuestOsFeature> guestOsFeatures;

  /**
   * Output only. A zero-based index to this disk, where 0 is reserved for the boot disk. If you
   * have many disks attached to an instance, each disk would have a unique index number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer index;

  /**
   * Input only. Specifies the parameters for a new disk that will be created alongside the new
   * instance. Use initialization parameters to create boot disks or local SSDs attached to the new
   * instance. This property is mutually exclusive with the source property; you can only define one
   * or the other, but not both.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocalDiskInitializeParams initializeParams;

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * `NVME` * `SCSI`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("interface")
  private java.lang.String interface__;

  /**
   * Output only. Type of the resource. Always compute#attachedDisk for attached disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Output only. Any valid publicly visible licenses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> licenses;

  /**
   * The mode in which to attach this disk, either `READ_WRITE` or `READ_ONLY`. If not specified,
   * the default is to attach the disk in `READ_WRITE` mode. Valid values: * `READ_ONLY` *
   * `READ_WRITE`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mode;

  /**
   * Specifies a valid partial or full URL to an existing Persistent Disk resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String source;

  /**
   * Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If not specified, the default
   * is `PERSISTENT`. Valid values: * `PERSISTENT` * `SCRATCH`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Optional. Output only. Specifies whether the disk will be auto-deleted when the instance is
   * deleted (but not when the disk is detached from the instance).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAutoDelete() {
    return autoDelete;
  }

  /**
   * Optional. Output only. Specifies whether the disk will be auto-deleted when the instance is
   * deleted (but not when the disk is detached from the instance).
   * @param autoDelete autoDelete or {@code null} for none
   */
  public LocalDisk setAutoDelete(java.lang.Boolean autoDelete) {
    this.autoDelete = autoDelete;
    return this;
  }

  /**
   * Optional. Output only. Indicates that this is a boot disk. The virtual machine will use the
   * first partition of the disk for its root filesystem.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBoot() {
    return boot;
  }

  /**
   * Optional. Output only. Indicates that this is a boot disk. The virtual machine will use the
   * first partition of the disk for its root filesystem.
   * @param boot boot or {@code null} for none
   */
  public LocalDisk setBoot(java.lang.Boolean boot) {
    this.boot = boot;
    return this;
  }

  /**
   * Optional. Output only. Specifies a unique device name of your choice that is reflected into the
   * `/dev/disk/by-id/google-*` tree of a Linux operating system running within the instance. This
   * name can be used to reference the device for mounting, resizing, and so on, from within the
   * instance. If not specified, the server chooses a default device name to apply to this disk, in
   * the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field
   * is only applicable for persistent disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getDeviceName() {
    return deviceName;
  }

  /**
   * Optional. Output only. Specifies a unique device name of your choice that is reflected into the
   * `/dev/disk/by-id/google-*` tree of a Linux operating system running within the instance. This
   * name can be used to reference the device for mounting, resizing, and so on, from within the
   * instance. If not specified, the server chooses a default device name to apply to this disk, in
   * the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field
   * is only applicable for persistent disks.
   * @param deviceName deviceName or {@code null} for none
   */
  public LocalDisk setDeviceName(java.lang.String deviceName) {
    this.deviceName = deviceName;
    return this;
  }

  /**
   * Output only. Indicates a list of features to enable on the guest operating system. Applicable
   * only for bootable images. Read Enabling guest operating system features to see a list of
   * available options.
   * @return value or {@code null} for none
   */
  public java.util.List<RuntimeGuestOsFeature> getGuestOsFeatures() {
    return guestOsFeatures;
  }

  /**
   * Output only. Indicates a list of features to enable on the guest operating system. Applicable
   * only for bootable images. Read Enabling guest operating system features to see a list of
   * available options.
   * @param guestOsFeatures guestOsFeatures or {@code null} for none
   */
  public LocalDisk setGuestOsFeatures(java.util.List<RuntimeGuestOsFeature> guestOsFeatures) {
    this.guestOsFeatures = guestOsFeatures;
    return this;
  }

  /**
   * Output only. A zero-based index to this disk, where 0 is reserved for the boot disk. If you
   * have many disks attached to an instance, each disk would have a unique index number.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIndex() {
    return index;
  }

  /**
   * Output only. A zero-based index to this disk, where 0 is reserved for the boot disk. If you
   * have many disks attached to an instance, each disk would have a unique index number.
   * @param index index or {@code null} for none
   */
  public LocalDisk setIndex(java.lang.Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Input only. Specifies the parameters for a new disk that will be created alongside the new
   * instance. Use initialization parameters to create boot disks or local SSDs attached to the new
   * instance. This property is mutually exclusive with the source property; you can only define one
   * or the other, but not both.
   * @return value or {@code null} for none
   */
  public LocalDiskInitializeParams getInitializeParams() {
    return initializeParams;
  }

  /**
   * Input only. Specifies the parameters for a new disk that will be created alongside the new
   * instance. Use initialization parameters to create boot disks or local SSDs attached to the new
   * instance. This property is mutually exclusive with the source property; you can only define one
   * or the other, but not both.
   * @param initializeParams initializeParams or {@code null} for none
   */
  public LocalDisk setInitializeParams(LocalDiskInitializeParams initializeParams) {
    this.initializeParams = initializeParams;
    return this;
  }

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * `NVME` * `SCSI`
   * @return value or {@code null} for none
   */
  public java.lang.String getInterface() {
    return interface__;
  }

  /**
   * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The
   * default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt
   * to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or
   * SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance. Valid
   * values: * `NVME` * `SCSI`
   * @param interface__ interface__ or {@code null} for none
   */
  public LocalDisk setInterface(java.lang.String interface__) {
    this.interface__ = interface__;
    return this;
  }

  /**
   * Output only. Type of the resource. Always compute#attachedDisk for attached disks.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. Type of the resource. Always compute#attachedDisk for attached disks.
   * @param kind kind or {@code null} for none
   */
  public LocalDisk setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Output only. Any valid publicly visible licenses.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLicenses() {
    return licenses;
  }

  /**
   * Output only. Any valid publicly visible licenses.
   * @param licenses licenses or {@code null} for none
   */
  public LocalDisk setLicenses(java.util.List<java.lang.String> licenses) {
    this.licenses = licenses;
    return this;
  }

  /**
   * The mode in which to attach this disk, either `READ_WRITE` or `READ_ONLY`. If not specified,
   * the default is to attach the disk in `READ_WRITE` mode. Valid values: * `READ_ONLY` *
   * `READ_WRITE`
   * @return value or {@code null} for none
   */
  public java.lang.String getMode() {
    return mode;
  }

  /**
   * The mode in which to attach this disk, either `READ_WRITE` or `READ_ONLY`. If not specified,
   * the default is to attach the disk in `READ_WRITE` mode. Valid values: * `READ_ONLY` *
   * `READ_WRITE`
   * @param mode mode or {@code null} for none
   */
  public LocalDisk setMode(java.lang.String mode) {
    this.mode = mode;
    return this;
  }

  /**
   * Specifies a valid partial or full URL to an existing Persistent Disk resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getSource() {
    return source;
  }

  /**
   * Specifies a valid partial or full URL to an existing Persistent Disk resource.
   * @param source source or {@code null} for none
   */
  public LocalDisk setSource(java.lang.String source) {
    this.source = source;
    return this;
  }

  /**
   * Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If not specified, the default
   * is `PERSISTENT`. Valid values: * `PERSISTENT` * `SCRATCH`
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Specifies the type of the disk, either `SCRATCH` or `PERSISTENT`. If not specified, the default
   * is `PERSISTENT`. Valid values: * `PERSISTENT` * `SCRATCH`
   * @param type type or {@code null} for none
   */
  public LocalDisk setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public LocalDisk set(String fieldName, Object value) {
    return (LocalDisk) super.set(fieldName, value);
  }

  @Override
  public LocalDisk clone() {
    return (LocalDisk) super.clone();
  }

}
