/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Input only. Specifies the parameters for a new disk that will be created alongside the new
 * instance. Use initialization parameters to create boot disks or local SSDs attached to the new
 * runtime. This property is mutually exclusive with the source property; you can only define one or
 * the other, but not both.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocalDiskInitializeParams extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Provide this property when creating the disk.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Optional. Specifies the disk name. If not specified, the default is to use the name of the
   * instance. If the disk with the instance name exists already in the given zone/region, a new
   * name will be automatically generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskName;

  /**
   * Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk will be the
   * same size as the image (usually 10GB). If specified, the size must be equal to or larger than
   * 10GB. Default 100 GB.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long diskSizeGb;

  /**
   * Input only. The type of the boot disk attached to this instance, defaults to standard
   * persistent disk (`PD_STANDARD`).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String diskType;

  /**
   * Optional. Labels to apply to this disk. These can be later modified by the disks.setLabels
   * method. This field is only applicable for persistent disks.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> labels;

  /**
   * Optional. Provide this property when creating the disk.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. Provide this property when creating the disk.
   * @param description description or {@code null} for none
   */
  public LocalDiskInitializeParams setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Optional. Specifies the disk name. If not specified, the default is to use the name of the
   * instance. If the disk with the instance name exists already in the given zone/region, a new
   * name will be automatically generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskName() {
    return diskName;
  }

  /**
   * Optional. Specifies the disk name. If not specified, the default is to use the name of the
   * instance. If the disk with the instance name exists already in the given zone/region, a new
   * name will be automatically generated.
   * @param diskName diskName or {@code null} for none
   */
  public LocalDiskInitializeParams setDiskName(java.lang.String diskName) {
    this.diskName = diskName;
    return this;
  }

  /**
   * Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk will be the
   * same size as the image (usually 10GB). If specified, the size must be equal to or larger than
   * 10GB. Default 100 GB.
   * @return value or {@code null} for none
   */
  public java.lang.Long getDiskSizeGb() {
    return diskSizeGb;
  }

  /**
   * Optional. Specifies the size of the disk in base-2 GB. If not specified, the disk will be the
   * same size as the image (usually 10GB). If specified, the size must be equal to or larger than
   * 10GB. Default 100 GB.
   * @param diskSizeGb diskSizeGb or {@code null} for none
   */
  public LocalDiskInitializeParams setDiskSizeGb(java.lang.Long diskSizeGb) {
    this.diskSizeGb = diskSizeGb;
    return this;
  }

  /**
   * Input only. The type of the boot disk attached to this instance, defaults to standard
   * persistent disk (`PD_STANDARD`).
   * @return value or {@code null} for none
   */
  public java.lang.String getDiskType() {
    return diskType;
  }

  /**
   * Input only. The type of the boot disk attached to this instance, defaults to standard
   * persistent disk (`PD_STANDARD`).
   * @param diskType diskType or {@code null} for none
   */
  public LocalDiskInitializeParams setDiskType(java.lang.String diskType) {
    this.diskType = diskType;
    return this;
  }

  /**
   * Optional. Labels to apply to this disk. These can be later modified by the disks.setLabels
   * method. This field is only applicable for persistent disks.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getLabels() {
    return labels;
  }

  /**
   * Optional. Labels to apply to this disk. These can be later modified by the disks.setLabels
   * method. This field is only applicable for persistent disks.
   * @param labels labels or {@code null} for none
   */
  public LocalDiskInitializeParams setLabels(java.util.Map<String, java.lang.String> labels) {
    this.labels = labels;
    return this;
  }

  @Override
  public LocalDiskInitializeParams set(String fieldName, Object value) {
    return (LocalDiskInitializeParams) super.set(fieldName, value);
  }

  @Override
  public LocalDiskInitializeParams clone() {
    return (LocalDiskInitializeParams) super.clone();
  }

}
