/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Request for migrating a Runtime to a Workbench Instance.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MigrateRuntimeRequest extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Name of the VPC that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same VPC,
   * and this field must be empty. Format: `projects/{project_id}/global/networks/{network_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Optional. Specifies the behavior of post startup script during migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String postStartupScriptOption;

  /**
   * Optional. Idempotent request UUID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * Optional. The service account to be included in the Compute Engine instance of the new
   * Workbench Instance when the Runtime uses "single user only" mode for permission. If not
   * specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. When the Runtime uses service account mode for permission, it will reuse the same
   * service account, and this field must be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String serviceAccount;

  /**
   * Optional. Name of the subnet that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same
   * subnet, and this field must be empty. Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String subnet;

  /**
   * Optional. Name of the VPC that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same VPC,
   * and this field must be empty. Format: `projects/{project_id}/global/networks/{network_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * Optional. Name of the VPC that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same VPC,
   * and this field must be empty. Format: `projects/{project_id}/global/networks/{network_id}`
   * @param network network or {@code null} for none
   */
  public MigrateRuntimeRequest setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  /**
   * Optional. Specifies the behavior of post startup script during migration.
   * @return value or {@code null} for none
   */
  public java.lang.String getPostStartupScriptOption() {
    return postStartupScriptOption;
  }

  /**
   * Optional. Specifies the behavior of post startup script during migration.
   * @param postStartupScriptOption postStartupScriptOption or {@code null} for none
   */
  public MigrateRuntimeRequest setPostStartupScriptOption(java.lang.String postStartupScriptOption) {
    this.postStartupScriptOption = postStartupScriptOption;
    return this;
  }

  /**
   * Optional. Idempotent request UUID.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * Optional. Idempotent request UUID.
   * @param requestId requestId or {@code null} for none
   */
  public MigrateRuntimeRequest setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * Optional. The service account to be included in the Compute Engine instance of the new
   * Workbench Instance when the Runtime uses "single user only" mode for permission. If not
   * specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. When the Runtime uses service account mode for permission, it will reuse the same
   * service account, and this field must be empty.
   * @return value or {@code null} for none
   */
  public java.lang.String getServiceAccount() {
    return serviceAccount;
  }

  /**
   * Optional. The service account to be included in the Compute Engine instance of the new
   * Workbench Instance when the Runtime uses "single user only" mode for permission. If not
   * specified, the [Compute Engine default service
   * account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
   * is used. When the Runtime uses service account mode for permission, it will reuse the same
   * service account, and this field must be empty.
   * @param serviceAccount serviceAccount or {@code null} for none
   */
  public MigrateRuntimeRequest setServiceAccount(java.lang.String serviceAccount) {
    this.serviceAccount = serviceAccount;
    return this;
  }

  /**
   * Optional. Name of the subnet that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same
   * subnet, and this field must be empty. Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * @return value or {@code null} for none
   */
  public java.lang.String getSubnet() {
    return subnet;
  }

  /**
   * Optional. Name of the subnet that the new Instance is in. This is required if the Runtime uses
   * google-managed network. If the Runtime uses customer-owned network, it will reuse the same
   * subnet, and this field must be empty. Format:
   * `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
   * @param subnet subnet or {@code null} for none
   */
  public MigrateRuntimeRequest setSubnet(java.lang.String subnet) {
    this.subnet = subnet;
    return this;
  }

  @Override
  public MigrateRuntimeRequest set(String fieldName, Object value) {
    return (MigrateRuntimeRequest) super.set(fieldName, value);
  }

  @Override
  public MigrateRuntimeRequest clone() {
    return (MigrateRuntimeRequest) super.clone();
  }

}
