/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Request for reporting a Managed Notebook Event.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReportInstanceEventRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The Event to be reported.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Event event;

  /**
   * Required. The VM hardware token for authenticating the VM.
   * https://cloud.google.com/compute/docs/instances/verifying-instance-identity
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmId;

  /**
   * Required. The Event to be reported.
   * @return value or {@code null} for none
   */
  public Event getEvent() {
    return event;
  }

  /**
   * Required. The Event to be reported.
   * @param event event or {@code null} for none
   */
  public ReportInstanceEventRequest setEvent(Event event) {
    this.event = event;
    return this;
  }

  /**
   * Required. The VM hardware token for authenticating the VM.
   * https://cloud.google.com/compute/docs/instances/verifying-instance-identity
   * @return value or {@code null} for none
   */
  public java.lang.String getVmId() {
    return vmId;
  }

  /**
   * Required. The VM hardware token for authenticating the VM.
   * https://cloud.google.com/compute/docs/instances/verifying-instance-identity
   * @param vmId vmId or {@code null} for none
   */
  public ReportInstanceEventRequest setVmId(java.lang.String vmId) {
    this.vmId = vmId;
    return this;
  }

  @Override
  public ReportInstanceEventRequest set(String fieldName, Object value) {
    return (ReportInstanceEventRequest) super.set(fieldName, value);
  }

  @Override
  public ReportInstanceEventRequest clone() {
    return (ReportInstanceEventRequest) super.clone();
  }

}
