/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Specifies the login configuration for Runtime
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RuntimeAccessConfig extends com.google.api.client.json.GenericJson {

  /**
   * The type of access mode this instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accessType;

  /**
   * Output only. The proxy endpoint that is used to access the runtime.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String proxyUri;

  /**
   * The owner of this runtime after creation. Format: `alias@example.com` Currently supports one
   * owner only.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String runtimeOwner;

  /**
   * The type of access mode this instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessType() {
    return accessType;
  }

  /**
   * The type of access mode this instance.
   * @param accessType accessType or {@code null} for none
   */
  public RuntimeAccessConfig setAccessType(java.lang.String accessType) {
    this.accessType = accessType;
    return this;
  }

  /**
   * Output only. The proxy endpoint that is used to access the runtime.
   * @return value or {@code null} for none
   */
  public java.lang.String getProxyUri() {
    return proxyUri;
  }

  /**
   * Output only. The proxy endpoint that is used to access the runtime.
   * @param proxyUri proxyUri or {@code null} for none
   */
  public RuntimeAccessConfig setProxyUri(java.lang.String proxyUri) {
    this.proxyUri = proxyUri;
    return this;
  }

  /**
   * The owner of this runtime after creation. Format: `alias@example.com` Currently supports one
   * owner only.
   * @return value or {@code null} for none
   */
  public java.lang.String getRuntimeOwner() {
    return runtimeOwner;
  }

  /**
   * The owner of this runtime after creation. Format: `alias@example.com` Currently supports one
   * owner only.
   * @param runtimeOwner runtimeOwner or {@code null} for none
   */
  public RuntimeAccessConfig setRuntimeOwner(java.lang.String runtimeOwner) {
    this.runtimeOwner = runtimeOwner;
    return this;
  }

  @Override
  public RuntimeAccessConfig set(String fieldName, Object value) {
    return (RuntimeAccessConfig) super.set(fieldName, value);
  }

  @Override
  public RuntimeAccessConfig clone() {
    return (RuntimeAccessConfig) super.clone();
  }

}
