/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * RuntimeMigrationEligibility represents the feasibility information of a migration from GmN to
 * WbI.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RuntimeMigrationEligibility extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Certain configurations make the GmN ineligible for an automatic migration. A
   * manual migration is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> errors;

  /**
   * Output only. Certain configurations will be defaulted during the migration.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> warnings;

  /**
   * Output only. Certain configurations make the GmN ineligible for an automatic migration. A
   * manual migration is required.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getErrors() {
    return errors;
  }

  /**
   * Output only. Certain configurations make the GmN ineligible for an automatic migration. A
   * manual migration is required.
   * @param errors errors or {@code null} for none
   */
  public RuntimeMigrationEligibility setErrors(java.util.List<java.lang.String> errors) {
    this.errors = errors;
    return this;
  }

  /**
   * Output only. Certain configurations will be defaulted during the migration.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getWarnings() {
    return warnings;
  }

  /**
   * Output only. Certain configurations will be defaulted during the migration.
   * @param warnings warnings or {@code null} for none
   */
  public RuntimeMigrationEligibility setWarnings(java.util.List<java.lang.String> warnings) {
    this.warnings = warnings;
    return this;
  }

  @Override
  public RuntimeMigrationEligibility set(String fieldName, Object value) {
    return (RuntimeMigrationEligibility) super.set(fieldName, value);
  }

  @Override
  public RuntimeMigrationEligibility clone() {
    return (RuntimeMigrationEligibility) super.clone();
  }

}
