/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * The entry of VM image upgrade history.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpgradeHistoryEntry extends com.google.api.client.json.GenericJson {

  /**
   * Action. Rolloback or Upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * The container image before this instance upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String containerImage;

  /**
   * The time that this instance upgrade history entry is created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * The framework of this notebook instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String framework;

  /**
   * The snapshot of the boot disk of this notebook instance before upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String snapshot;

  /**
   * The state of this instance upgrade history entry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String state;

  /**
   * Target VM Image. Format: `ainotebooks-vm/project/image-name/name`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetImage;

  /**
   * Target VM Version, like m63.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetVersion;

  /**
   * The version of the notebook instance before this upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String version;

  /**
   * The VM image before this instance upgrade.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vmImage;

  /**
   * Action. Rolloback or Upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * Action. Rolloback or Upgrade.
   * @param action action or {@code null} for none
   */
  public UpgradeHistoryEntry setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * The container image before this instance upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getContainerImage() {
    return containerImage;
  }

  /**
   * The container image before this instance upgrade.
   * @param containerImage containerImage or {@code null} for none
   */
  public UpgradeHistoryEntry setContainerImage(java.lang.String containerImage) {
    this.containerImage = containerImage;
    return this;
  }

  /**
   * The time that this instance upgrade history entry is created.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * The time that this instance upgrade history entry is created.
   * @param createTime createTime or {@code null} for none
   */
  public UpgradeHistoryEntry setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * The framework of this notebook instance.
   * @return value or {@code null} for none
   */
  public java.lang.String getFramework() {
    return framework;
  }

  /**
   * The framework of this notebook instance.
   * @param framework framework or {@code null} for none
   */
  public UpgradeHistoryEntry setFramework(java.lang.String framework) {
    this.framework = framework;
    return this;
  }

  /**
   * The snapshot of the boot disk of this notebook instance before upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getSnapshot() {
    return snapshot;
  }

  /**
   * The snapshot of the boot disk of this notebook instance before upgrade.
   * @param snapshot snapshot or {@code null} for none
   */
  public UpgradeHistoryEntry setSnapshot(java.lang.String snapshot) {
    this.snapshot = snapshot;
    return this;
  }

  /**
   * The state of this instance upgrade history entry.
   * @return value or {@code null} for none
   */
  public java.lang.String getState() {
    return state;
  }

  /**
   * The state of this instance upgrade history entry.
   * @param state state or {@code null} for none
   */
  public UpgradeHistoryEntry setState(java.lang.String state) {
    this.state = state;
    return this;
  }

  /**
   * Target VM Image. Format: `ainotebooks-vm/project/image-name/name`.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetImage() {
    return targetImage;
  }

  /**
   * Target VM Image. Format: `ainotebooks-vm/project/image-name/name`.
   * @param targetImage targetImage or {@code null} for none
   */
  public UpgradeHistoryEntry setTargetImage(java.lang.String targetImage) {
    this.targetImage = targetImage;
    return this;
  }

  /**
   * Target VM Version, like m63.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetVersion() {
    return targetVersion;
  }

  /**
   * Target VM Version, like m63.
   * @param targetVersion targetVersion or {@code null} for none
   */
  public UpgradeHistoryEntry setTargetVersion(java.lang.String targetVersion) {
    this.targetVersion = targetVersion;
    return this;
  }

  /**
   * The version of the notebook instance before this upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getVersion() {
    return version;
  }

  /**
   * The version of the notebook instance before this upgrade.
   * @param version version or {@code null} for none
   */
  public UpgradeHistoryEntry setVersion(java.lang.String version) {
    this.version = version;
    return this;
  }

  /**
   * The VM image before this instance upgrade.
   * @return value or {@code null} for none
   */
  public java.lang.String getVmImage() {
    return vmImage;
  }

  /**
   * The VM image before this instance upgrade.
   * @param vmImage vmImage or {@code null} for none
   */
  public UpgradeHistoryEntry setVmImage(java.lang.String vmImage) {
    this.vmImage = vmImage;
    return this;
  }

  @Override
  public UpgradeHistoryEntry set(String fieldName, Object value) {
    return (UpgradeHistoryEntry) super.set(fieldName, value);
  }

  @Override
  public UpgradeHistoryEntry clone() {
    return (UpgradeHistoryEntry) super.clone();
  }

}
