/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.notebooks.v1.model;

/**
 * Parameters used in Vertex AI JobType executions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Notebooks API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VertexAIParameters extends com.google.api.client.json.GenericJson {

  /**
   * Environment variables. At most 100 environment variables can be specified and unique. Example:
   * `GCP_BUCKET=gs://my-bucket/samples/`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> env;

  /**
   * The full name of the Compute Engine [network](https://cloud.google.com/compute/docs/networks-
   * and-firewalls#networks) to which the Job should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is of the
   * form `projects/{project}/global/networks/{network}`. Where `{project}` is a project number, as
   * in `12345`, and `{network}` is a network name. Private services access must already be
   * configured for the network. If left unspecified, the job is not peered with any network.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String network;

  /**
   * Environment variables. At most 100 environment variables can be specified and unique. Example:
   * `GCP_BUCKET=gs://my-bucket/samples/`
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getEnv() {
    return env;
  }

  /**
   * Environment variables. At most 100 environment variables can be specified and unique. Example:
   * `GCP_BUCKET=gs://my-bucket/samples/`
   * @param env env or {@code null} for none
   */
  public VertexAIParameters setEnv(java.util.Map<String, java.lang.String> env) {
    this.env = env;
    return this;
  }

  /**
   * The full name of the Compute Engine [network](https://cloud.google.com/compute/docs/networks-
   * and-firewalls#networks) to which the Job should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is of the
   * form `projects/{project}/global/networks/{network}`. Where `{project}` is a project number, as
   * in `12345`, and `{network}` is a network name. Private services access must already be
   * configured for the network. If left unspecified, the job is not peered with any network.
   * @return value or {@code null} for none
   */
  public java.lang.String getNetwork() {
    return network;
  }

  /**
   * The full name of the Compute Engine [network](https://cloud.google.com/compute/docs/networks-
   * and-firewalls#networks) to which the Job should be peered. For example,
   * `projects/12345/global/networks/myVPC`.
   * [Format](https://cloud.google.com/compute/docs/reference/rest/v1/networks/insert) is of the
   * form `projects/{project}/global/networks/{network}`. Where `{project}` is a project number, as
   * in `12345`, and `{network}` is a network name. Private services access must already be
   * configured for the network. If left unspecified, the job is not peered with any network.
   * @param network network or {@code null} for none
   */
  public VertexAIParameters setNetwork(java.lang.String network) {
    this.network = network;
    return this;
  }

  @Override
  public VertexAIParameters set(String fieldName, Object value) {
    return (VertexAIParameters) super.set(fieldName, value);
  }

  @Override
  public VertexAIParameters clone() {
    return (VertexAIParameters) super.clone();
  }

}
