/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.notebooks.v2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.notebooks.v2.AIPlatformNotebooksRequest;
import com.google.api.services.notebooks.v2.AIPlatformNotebooksRequestInitializer;
import com.google.api.services.notebooks.v2.model.CancelOperationRequest;
import com.google.api.services.notebooks.v2.model.CheckInstanceUpgradabilityResponse;
import com.google.api.services.notebooks.v2.model.Config;
import com.google.api.services.notebooks.v2.model.DiagnoseInstanceRequest;
import com.google.api.services.notebooks.v2.model.Empty;
import com.google.api.services.notebooks.v2.model.Instance;
import com.google.api.services.notebooks.v2.model.ListInstancesResponse;
import com.google.api.services.notebooks.v2.model.ListLocationsResponse;
import com.google.api.services.notebooks.v2.model.ListOperationsResponse;
import com.google.api.services.notebooks.v2.model.Location;
import com.google.api.services.notebooks.v2.model.Operation;
import com.google.api.services.notebooks.v2.model.Policy;
import com.google.api.services.notebooks.v2.model.ReportInstanceInfoSystemRequest;
import com.google.api.services.notebooks.v2.model.ResetInstanceRequest;
import com.google.api.services.notebooks.v2.model.ResizeDiskRequest;
import com.google.api.services.notebooks.v2.model.RollbackInstanceRequest;
import com.google.api.services.notebooks.v2.model.SetIamPolicyRequest;
import com.google.api.services.notebooks.v2.model.StartInstanceRequest;
import com.google.api.services.notebooks.v2.model.StopInstanceRequest;
import com.google.api.services.notebooks.v2.model.TestIamPermissionsRequest;
import com.google.api.services.notebooks.v2.model.TestIamPermissionsResponse;
import com.google.api.services.notebooks.v2.model.UpgradeInstanceRequest;
import com.google.api.services.notebooks.v2.model.UpgradeInstanceSystemRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class AIPlatformNotebooks
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://notebooks.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://notebooks.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://notebooks.googleapis.com/";

    public AIPlatformNotebooks(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    AIPlatformNotebooks(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Notebooks API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return AIPlatformNotebooks.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://notebooks.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), AIPlatformNotebooks.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(AIPlatformNotebooks.DEFAULT_BATCH_PATH);
        }

        public AIPlatformNotebooks build() {
            return new AIPlatformNotebooks(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setAIPlatformNotebooksRequestInitializer(AIPlatformNotebooksRequestInitializer aiplatformnotebooksRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)aiplatformnotebooksRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class Projects {
        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Get get(String name) throws IOException {
                Get result = new Get(name);
                AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String name) throws IOException {
                List result = new List(name);
                AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Instances instances() {
                return new Instances();
            }

            public Operations operations() {
                return new Operations();
            }

            public class Operations {
                public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
                    Cancel result = new Cancel(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String name) throws IOException {
                    List result = new List(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends AIPlatformNotebooksRequest<ListOperationsResponse> {
                    private static final String REST_PATH = "v2/{+name}/operations";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String filter;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String name) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends AIPlatformNotebooksRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Cancel
                extends AIPlatformNotebooksRequest<Empty> {
                    private static final String REST_PATH = "v2/{+name}:cancel";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Cancel(String name, CancelOperationRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public Cancel set$Xgafv(String $Xgafv) {
                        return (Cancel)super.set$Xgafv($Xgafv);
                    }

                    public Cancel setAccessToken(String accessToken) {
                        return (Cancel)super.setAccessToken(accessToken);
                    }

                    public Cancel setAlt(String alt) {
                        return (Cancel)super.setAlt(alt);
                    }

                    public Cancel setCallback(String callback) {
                        return (Cancel)super.setCallback(callback);
                    }

                    public Cancel setFields(String fields) {
                        return (Cancel)super.setFields(fields);
                    }

                    public Cancel setKey(String key) {
                        return (Cancel)super.setKey(key);
                    }

                    public Cancel setOauthToken(String oauthToken) {
                        return (Cancel)super.setOauthToken(oauthToken);
                    }

                    public Cancel setPrettyPrint(Boolean prettyPrint) {
                        return (Cancel)super.setPrettyPrint(prettyPrint);
                    }

                    public Cancel setQuotaUser(String quotaUser) {
                        return (Cancel)super.setQuotaUser(quotaUser);
                    }

                    public Cancel setUploadType(String uploadType) {
                        return (Cancel)super.setUploadType(uploadType);
                    }

                    public Cancel setUploadProtocol(String uploadProtocol) {
                        return (Cancel)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Cancel setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Cancel set(String parameterName, Object value) {
                        return (Cancel)super.set(parameterName, value);
                    }
                }
            }

            public class Instances {
                public CheckUpgradability checkUpgradability(String notebookInstance) throws IOException {
                    CheckUpgradability result = new CheckUpgradability(notebookInstance);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Create create(String parent, Instance content) throws IOException {
                    Create result = new Create(parent, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Diagnose diagnose(String name, DiagnoseInstanceRequest content) throws IOException {
                    Diagnose result = new Diagnose(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetConfig getConfig(String name) throws IOException {
                    GetConfig result = new GetConfig(name);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public GetIamPolicy getIamPolicy(String resource) throws IOException {
                    GetIamPolicy result = new GetIamPolicy(resource);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Instance content) throws IOException {
                    Patch result = new Patch(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ReportInfoSystem reportInfoSystem(String name, ReportInstanceInfoSystemRequest content) throws IOException {
                    ReportInfoSystem result = new ReportInfoSystem(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Reset reset(String name, ResetInstanceRequest content) throws IOException {
                    Reset result = new Reset(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ResizeDisk resizeDisk(String notebookInstance, ResizeDiskRequest content) throws IOException {
                    ResizeDisk result = new ResizeDisk(notebookInstance, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Rollback rollback(String name, RollbackInstanceRequest content) throws IOException {
                    Rollback result = new Rollback(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
                    SetIamPolicy result = new SetIamPolicy(resource, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Start start(String name, StartInstanceRequest content) throws IOException {
                    Start result = new Start(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Stop stop(String name, StopInstanceRequest content) throws IOException {
                    Stop result = new Stop(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
                    TestIamPermissions result = new TestIamPermissions(resource, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Upgrade upgrade(String name, UpgradeInstanceRequest content) throws IOException {
                    Upgrade result = new Upgrade(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public UpgradeSystem upgradeSystem(String name, UpgradeInstanceSystemRequest content) throws IOException {
                    UpgradeSystem result = new UpgradeSystem(name, content);
                    AIPlatformNotebooks.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class UpgradeSystem
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:upgradeSystem";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected UpgradeSystem(String name, UpgradeInstanceSystemRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public UpgradeSystem set$Xgafv(String $Xgafv) {
                        return (UpgradeSystem)super.set$Xgafv($Xgafv);
                    }

                    public UpgradeSystem setAccessToken(String accessToken) {
                        return (UpgradeSystem)super.setAccessToken(accessToken);
                    }

                    public UpgradeSystem setAlt(String alt) {
                        return (UpgradeSystem)super.setAlt(alt);
                    }

                    public UpgradeSystem setCallback(String callback) {
                        return (UpgradeSystem)super.setCallback(callback);
                    }

                    public UpgradeSystem setFields(String fields) {
                        return (UpgradeSystem)super.setFields(fields);
                    }

                    public UpgradeSystem setKey(String key) {
                        return (UpgradeSystem)super.setKey(key);
                    }

                    public UpgradeSystem setOauthToken(String oauthToken) {
                        return (UpgradeSystem)super.setOauthToken(oauthToken);
                    }

                    public UpgradeSystem setPrettyPrint(Boolean prettyPrint) {
                        return (UpgradeSystem)super.setPrettyPrint(prettyPrint);
                    }

                    public UpgradeSystem setQuotaUser(String quotaUser) {
                        return (UpgradeSystem)super.setQuotaUser(quotaUser);
                    }

                    public UpgradeSystem setUploadType(String uploadType) {
                        return (UpgradeSystem)super.setUploadType(uploadType);
                    }

                    public UpgradeSystem setUploadProtocol(String uploadProtocol) {
                        return (UpgradeSystem)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public UpgradeSystem setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public UpgradeSystem set(String parameterName, Object value) {
                        return (UpgradeSystem)super.set(parameterName, value);
                    }
                }

                public class Upgrade
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:upgrade";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Upgrade(String name, UpgradeInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Upgrade set$Xgafv(String $Xgafv) {
                        return (Upgrade)super.set$Xgafv($Xgafv);
                    }

                    public Upgrade setAccessToken(String accessToken) {
                        return (Upgrade)super.setAccessToken(accessToken);
                    }

                    public Upgrade setAlt(String alt) {
                        return (Upgrade)super.setAlt(alt);
                    }

                    public Upgrade setCallback(String callback) {
                        return (Upgrade)super.setCallback(callback);
                    }

                    public Upgrade setFields(String fields) {
                        return (Upgrade)super.setFields(fields);
                    }

                    public Upgrade setKey(String key) {
                        return (Upgrade)super.setKey(key);
                    }

                    public Upgrade setOauthToken(String oauthToken) {
                        return (Upgrade)super.setOauthToken(oauthToken);
                    }

                    public Upgrade setPrettyPrint(Boolean prettyPrint) {
                        return (Upgrade)super.setPrettyPrint(prettyPrint);
                    }

                    public Upgrade setQuotaUser(String quotaUser) {
                        return (Upgrade)super.setQuotaUser(quotaUser);
                    }

                    public Upgrade setUploadType(String uploadType) {
                        return (Upgrade)super.setUploadType(uploadType);
                    }

                    public Upgrade setUploadProtocol(String uploadProtocol) {
                        return (Upgrade)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Upgrade setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Upgrade set(String parameterName, Object value) {
                        return (Upgrade)super.set(parameterName, value);
                    }
                }

                public class TestIamPermissions
                extends AIPlatformNotebooksRequest<TestIamPermissionsResponse> {
                    private static final String REST_PATH = "v2/{+resource}:testIamPermissions";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public TestIamPermissions set$Xgafv(String $Xgafv) {
                        return (TestIamPermissions)super.set$Xgafv($Xgafv);
                    }

                    public TestIamPermissions setAccessToken(String accessToken) {
                        return (TestIamPermissions)super.setAccessToken(accessToken);
                    }

                    public TestIamPermissions setAlt(String alt) {
                        return (TestIamPermissions)super.setAlt(alt);
                    }

                    public TestIamPermissions setCallback(String callback) {
                        return (TestIamPermissions)super.setCallback(callback);
                    }

                    public TestIamPermissions setFields(String fields) {
                        return (TestIamPermissions)super.setFields(fields);
                    }

                    public TestIamPermissions setKey(String key) {
                        return (TestIamPermissions)super.setKey(key);
                    }

                    public TestIamPermissions setOauthToken(String oauthToken) {
                        return (TestIamPermissions)super.setOauthToken(oauthToken);
                    }

                    public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                        return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
                    }

                    public TestIamPermissions setQuotaUser(String quotaUser) {
                        return (TestIamPermissions)super.setQuotaUser(quotaUser);
                    }

                    public TestIamPermissions setUploadType(String uploadType) {
                        return (TestIamPermissions)super.setUploadType(uploadType);
                    }

                    public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                        return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public TestIamPermissions setResource(String resource) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public TestIamPermissions set(String parameterName, Object value) {
                        return (TestIamPermissions)super.set(parameterName, value);
                    }
                }

                public class Stop
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:stop";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Stop(String name, StopInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Stop set$Xgafv(String $Xgafv) {
                        return (Stop)super.set$Xgafv($Xgafv);
                    }

                    public Stop setAccessToken(String accessToken) {
                        return (Stop)super.setAccessToken(accessToken);
                    }

                    public Stop setAlt(String alt) {
                        return (Stop)super.setAlt(alt);
                    }

                    public Stop setCallback(String callback) {
                        return (Stop)super.setCallback(callback);
                    }

                    public Stop setFields(String fields) {
                        return (Stop)super.setFields(fields);
                    }

                    public Stop setKey(String key) {
                        return (Stop)super.setKey(key);
                    }

                    public Stop setOauthToken(String oauthToken) {
                        return (Stop)super.setOauthToken(oauthToken);
                    }

                    public Stop setPrettyPrint(Boolean prettyPrint) {
                        return (Stop)super.setPrettyPrint(prettyPrint);
                    }

                    public Stop setQuotaUser(String quotaUser) {
                        return (Stop)super.setQuotaUser(quotaUser);
                    }

                    public Stop setUploadType(String uploadType) {
                        return (Stop)super.setUploadType(uploadType);
                    }

                    public Stop setUploadProtocol(String uploadProtocol) {
                        return (Stop)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Stop setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Stop set(String parameterName, Object value) {
                        return (Stop)super.set(parameterName, value);
                    }
                }

                public class Start
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:start";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Start(String name, StartInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Start set$Xgafv(String $Xgafv) {
                        return (Start)super.set$Xgafv($Xgafv);
                    }

                    public Start setAccessToken(String accessToken) {
                        return (Start)super.setAccessToken(accessToken);
                    }

                    public Start setAlt(String alt) {
                        return (Start)super.setAlt(alt);
                    }

                    public Start setCallback(String callback) {
                        return (Start)super.setCallback(callback);
                    }

                    public Start setFields(String fields) {
                        return (Start)super.setFields(fields);
                    }

                    public Start setKey(String key) {
                        return (Start)super.setKey(key);
                    }

                    public Start setOauthToken(String oauthToken) {
                        return (Start)super.setOauthToken(oauthToken);
                    }

                    public Start setPrettyPrint(Boolean prettyPrint) {
                        return (Start)super.setPrettyPrint(prettyPrint);
                    }

                    public Start setQuotaUser(String quotaUser) {
                        return (Start)super.setQuotaUser(quotaUser);
                    }

                    public Start setUploadType(String uploadType) {
                        return (Start)super.setUploadType(uploadType);
                    }

                    public Start setUploadProtocol(String uploadProtocol) {
                        return (Start)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Start setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Start set(String parameterName, Object value) {
                        return (Start)super.set(parameterName, value);
                    }
                }

                public class SetIamPolicy
                extends AIPlatformNotebooksRequest<Policy> {
                    private static final String REST_PATH = "v2/{+resource}:setIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;

                    protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public SetIamPolicy set$Xgafv(String $Xgafv) {
                        return (SetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public SetIamPolicy setAccessToken(String accessToken) {
                        return (SetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public SetIamPolicy setAlt(String alt) {
                        return (SetIamPolicy)super.setAlt(alt);
                    }

                    public SetIamPolicy setCallback(String callback) {
                        return (SetIamPolicy)super.setCallback(callback);
                    }

                    public SetIamPolicy setFields(String fields) {
                        return (SetIamPolicy)super.setFields(fields);
                    }

                    public SetIamPolicy setKey(String key) {
                        return (SetIamPolicy)super.setKey(key);
                    }

                    public SetIamPolicy setOauthToken(String oauthToken) {
                        return (SetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public SetIamPolicy setQuotaUser(String quotaUser) {
                        return (SetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public SetIamPolicy setUploadType(String uploadType) {
                        return (SetIamPolicy)super.setUploadType(uploadType);
                    }

                    public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public SetIamPolicy setResource(String resource) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    @Override
                    public SetIamPolicy set(String parameterName, Object value) {
                        return (SetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class Rollback
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:rollback";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Rollback(String name, RollbackInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Rollback set$Xgafv(String $Xgafv) {
                        return (Rollback)super.set$Xgafv($Xgafv);
                    }

                    public Rollback setAccessToken(String accessToken) {
                        return (Rollback)super.setAccessToken(accessToken);
                    }

                    public Rollback setAlt(String alt) {
                        return (Rollback)super.setAlt(alt);
                    }

                    public Rollback setCallback(String callback) {
                        return (Rollback)super.setCallback(callback);
                    }

                    public Rollback setFields(String fields) {
                        return (Rollback)super.setFields(fields);
                    }

                    public Rollback setKey(String key) {
                        return (Rollback)super.setKey(key);
                    }

                    public Rollback setOauthToken(String oauthToken) {
                        return (Rollback)super.setOauthToken(oauthToken);
                    }

                    public Rollback setPrettyPrint(Boolean prettyPrint) {
                        return (Rollback)super.setPrettyPrint(prettyPrint);
                    }

                    public Rollback setQuotaUser(String quotaUser) {
                        return (Rollback)super.setQuotaUser(quotaUser);
                    }

                    public Rollback setUploadType(String uploadType) {
                        return (Rollback)super.setUploadType(uploadType);
                    }

                    public Rollback setUploadProtocol(String uploadProtocol) {
                        return (Rollback)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Rollback setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Rollback set(String parameterName, Object value) {
                        return (Rollback)super.set(parameterName, value);
                    }
                }

                public class ResizeDisk
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+notebookInstance}:resizeDisk";
                    private final Pattern NOTEBOOK_INSTANCE_PATTERN;
                    @Key
                    private String notebookInstance;

                    protected ResizeDisk(String notebookInstance, ResizeDiskRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NOTEBOOK_INSTANCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.notebookInstance = (String)Preconditions.checkNotNull((Object)notebookInstance, (Object)"Required parameter notebookInstance must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(), (Object)"Parameter notebookInstance must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public ResizeDisk set$Xgafv(String $Xgafv) {
                        return (ResizeDisk)super.set$Xgafv($Xgafv);
                    }

                    public ResizeDisk setAccessToken(String accessToken) {
                        return (ResizeDisk)super.setAccessToken(accessToken);
                    }

                    public ResizeDisk setAlt(String alt) {
                        return (ResizeDisk)super.setAlt(alt);
                    }

                    public ResizeDisk setCallback(String callback) {
                        return (ResizeDisk)super.setCallback(callback);
                    }

                    public ResizeDisk setFields(String fields) {
                        return (ResizeDisk)super.setFields(fields);
                    }

                    public ResizeDisk setKey(String key) {
                        return (ResizeDisk)super.setKey(key);
                    }

                    public ResizeDisk setOauthToken(String oauthToken) {
                        return (ResizeDisk)super.setOauthToken(oauthToken);
                    }

                    public ResizeDisk setPrettyPrint(Boolean prettyPrint) {
                        return (ResizeDisk)super.setPrettyPrint(prettyPrint);
                    }

                    public ResizeDisk setQuotaUser(String quotaUser) {
                        return (ResizeDisk)super.setQuotaUser(quotaUser);
                    }

                    public ResizeDisk setUploadType(String uploadType) {
                        return (ResizeDisk)super.setUploadType(uploadType);
                    }

                    public ResizeDisk setUploadProtocol(String uploadProtocol) {
                        return (ResizeDisk)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getNotebookInstance() {
                        return this.notebookInstance;
                    }

                    public ResizeDisk setNotebookInstance(String notebookInstance) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(), (Object)"Parameter notebookInstance must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.notebookInstance = notebookInstance;
                        return this;
                    }

                    @Override
                    public ResizeDisk set(String parameterName, Object value) {
                        return (ResizeDisk)super.set(parameterName, value);
                    }
                }

                public class Reset
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:reset";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Reset(String name, ResetInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Reset set$Xgafv(String $Xgafv) {
                        return (Reset)super.set$Xgafv($Xgafv);
                    }

                    public Reset setAccessToken(String accessToken) {
                        return (Reset)super.setAccessToken(accessToken);
                    }

                    public Reset setAlt(String alt) {
                        return (Reset)super.setAlt(alt);
                    }

                    public Reset setCallback(String callback) {
                        return (Reset)super.setCallback(callback);
                    }

                    public Reset setFields(String fields) {
                        return (Reset)super.setFields(fields);
                    }

                    public Reset setKey(String key) {
                        return (Reset)super.setKey(key);
                    }

                    public Reset setOauthToken(String oauthToken) {
                        return (Reset)super.setOauthToken(oauthToken);
                    }

                    public Reset setPrettyPrint(Boolean prettyPrint) {
                        return (Reset)super.setPrettyPrint(prettyPrint);
                    }

                    public Reset setQuotaUser(String quotaUser) {
                        return (Reset)super.setQuotaUser(quotaUser);
                    }

                    public Reset setUploadType(String uploadType) {
                        return (Reset)super.setUploadType(uploadType);
                    }

                    public Reset setUploadProtocol(String uploadProtocol) {
                        return (Reset)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Reset setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Reset set(String parameterName, Object value) {
                        return (Reset)super.set(parameterName, value);
                    }
                }

                public class ReportInfoSystem
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:reportInfoSystem";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected ReportInfoSystem(String name, ReportInstanceInfoSystemRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public ReportInfoSystem set$Xgafv(String $Xgafv) {
                        return (ReportInfoSystem)super.set$Xgafv($Xgafv);
                    }

                    public ReportInfoSystem setAccessToken(String accessToken) {
                        return (ReportInfoSystem)super.setAccessToken(accessToken);
                    }

                    public ReportInfoSystem setAlt(String alt) {
                        return (ReportInfoSystem)super.setAlt(alt);
                    }

                    public ReportInfoSystem setCallback(String callback) {
                        return (ReportInfoSystem)super.setCallback(callback);
                    }

                    public ReportInfoSystem setFields(String fields) {
                        return (ReportInfoSystem)super.setFields(fields);
                    }

                    public ReportInfoSystem setKey(String key) {
                        return (ReportInfoSystem)super.setKey(key);
                    }

                    public ReportInfoSystem setOauthToken(String oauthToken) {
                        return (ReportInfoSystem)super.setOauthToken(oauthToken);
                    }

                    public ReportInfoSystem setPrettyPrint(Boolean prettyPrint) {
                        return (ReportInfoSystem)super.setPrettyPrint(prettyPrint);
                    }

                    public ReportInfoSystem setQuotaUser(String quotaUser) {
                        return (ReportInfoSystem)super.setQuotaUser(quotaUser);
                    }

                    public ReportInfoSystem setUploadType(String uploadType) {
                        return (ReportInfoSystem)super.setUploadType(uploadType);
                    }

                    public ReportInfoSystem setUploadProtocol(String uploadProtocol) {
                        return (ReportInfoSystem)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public ReportInfoSystem setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public ReportInfoSystem set(String parameterName, Object value) {
                        return (ReportInfoSystem)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String requestId;
                    @Key
                    private String updateMask;

                    protected Patch(String name, Instance content) {
                        super(AIPlatformNotebooks.this, "PATCH", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends AIPlatformNotebooksRequest<ListInstancesResponse> {
                    private static final String REST_PATH = "v2/{+parent}/instances";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String parent) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, ListInstancesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class GetIamPolicy
                extends AIPlatformNotebooksRequest<Policy> {
                    private static final String REST_PATH = "v2/{+resource}:getIamPolicy";
                    private final Pattern RESOURCE_PATTERN;
                    @Key
                    private String resource;
                    @Key(value="options.requestedPolicyVersion")
                    private Integer optionsRequestedPolicyVersion;

                    protected GetIamPolicy(String resource) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, Policy.class);
                        this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetIamPolicy set$Xgafv(String $Xgafv) {
                        return (GetIamPolicy)super.set$Xgafv($Xgafv);
                    }

                    public GetIamPolicy setAccessToken(String accessToken) {
                        return (GetIamPolicy)super.setAccessToken(accessToken);
                    }

                    public GetIamPolicy setAlt(String alt) {
                        return (GetIamPolicy)super.setAlt(alt);
                    }

                    public GetIamPolicy setCallback(String callback) {
                        return (GetIamPolicy)super.setCallback(callback);
                    }

                    public GetIamPolicy setFields(String fields) {
                        return (GetIamPolicy)super.setFields(fields);
                    }

                    public GetIamPolicy setKey(String key) {
                        return (GetIamPolicy)super.setKey(key);
                    }

                    public GetIamPolicy setOauthToken(String oauthToken) {
                        return (GetIamPolicy)super.setOauthToken(oauthToken);
                    }

                    public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                        return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
                    }

                    public GetIamPolicy setQuotaUser(String quotaUser) {
                        return (GetIamPolicy)super.setQuotaUser(quotaUser);
                    }

                    public GetIamPolicy setUploadType(String uploadType) {
                        return (GetIamPolicy)super.setUploadType(uploadType);
                    }

                    public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                        return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getResource() {
                        return this.resource;
                    }

                    public GetIamPolicy setResource(String resource) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.resource = resource;
                        return this;
                    }

                    public Integer getOptionsRequestedPolicyVersion() {
                        return this.optionsRequestedPolicyVersion;
                    }

                    public GetIamPolicy setOptionsRequestedPolicyVersion(Integer optionsRequestedPolicyVersion) {
                        this.optionsRequestedPolicyVersion = optionsRequestedPolicyVersion;
                        return this;
                    }

                    @Override
                    public GetIamPolicy set(String parameterName, Object value) {
                        return (GetIamPolicy)super.set(parameterName, value);
                    }
                }

                public class GetConfig
                extends AIPlatformNotebooksRequest<Config> {
                    private static final String REST_PATH = "v2/{+name}/instances:getConfig";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected GetConfig(String name) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, Config.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetConfig set$Xgafv(String $Xgafv) {
                        return (GetConfig)super.set$Xgafv($Xgafv);
                    }

                    public GetConfig setAccessToken(String accessToken) {
                        return (GetConfig)super.setAccessToken(accessToken);
                    }

                    public GetConfig setAlt(String alt) {
                        return (GetConfig)super.setAlt(alt);
                    }

                    public GetConfig setCallback(String callback) {
                        return (GetConfig)super.setCallback(callback);
                    }

                    public GetConfig setFields(String fields) {
                        return (GetConfig)super.setFields(fields);
                    }

                    public GetConfig setKey(String key) {
                        return (GetConfig)super.setKey(key);
                    }

                    public GetConfig setOauthToken(String oauthToken) {
                        return (GetConfig)super.setOauthToken(oauthToken);
                    }

                    public GetConfig setPrettyPrint(Boolean prettyPrint) {
                        return (GetConfig)super.setPrettyPrint(prettyPrint);
                    }

                    public GetConfig setQuotaUser(String quotaUser) {
                        return (GetConfig)super.setQuotaUser(quotaUser);
                    }

                    public GetConfig setUploadType(String uploadType) {
                        return (GetConfig)super.setUploadType(uploadType);
                    }

                    public GetConfig setUploadProtocol(String uploadProtocol) {
                        return (GetConfig)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GetConfig setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public GetConfig set(String parameterName, Object value) {
                        return (GetConfig)super.set(parameterName, value);
                    }
                }

                public class Get
                extends AIPlatformNotebooksRequest<Instance> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, Instance.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Diagnose
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}:diagnose";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Diagnose(String name, DiagnoseInstanceRequest content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Diagnose set$Xgafv(String $Xgafv) {
                        return (Diagnose)super.set$Xgafv($Xgafv);
                    }

                    public Diagnose setAccessToken(String accessToken) {
                        return (Diagnose)super.setAccessToken(accessToken);
                    }

                    public Diagnose setAlt(String alt) {
                        return (Diagnose)super.setAlt(alt);
                    }

                    public Diagnose setCallback(String callback) {
                        return (Diagnose)super.setCallback(callback);
                    }

                    public Diagnose setFields(String fields) {
                        return (Diagnose)super.setFields(fields);
                    }

                    public Diagnose setKey(String key) {
                        return (Diagnose)super.setKey(key);
                    }

                    public Diagnose setOauthToken(String oauthToken) {
                        return (Diagnose)super.setOauthToken(oauthToken);
                    }

                    public Diagnose setPrettyPrint(Boolean prettyPrint) {
                        return (Diagnose)super.setPrettyPrint(prettyPrint);
                    }

                    public Diagnose setQuotaUser(String quotaUser) {
                        return (Diagnose)super.setQuotaUser(quotaUser);
                    }

                    public Diagnose setUploadType(String uploadType) {
                        return (Diagnose)super.setUploadType(uploadType);
                    }

                    public Diagnose setUploadProtocol(String uploadProtocol) {
                        return (Diagnose)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Diagnose setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Diagnose set(String parameterName, Object value) {
                        return (Diagnose)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String requestId;

                    protected Delete(String name) {
                        super(AIPlatformNotebooks.this, "DELETE", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Delete setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends AIPlatformNotebooksRequest<Operation> {
                    private static final String REST_PATH = "v2/{+parent}/instances";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String instanceId;
                    @Key
                    private String requestId;

                    protected Create(String parent, Instance content) {
                        super(AIPlatformNotebooks.this, "POST", REST_PATH, (Object)content, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getInstanceId() {
                        return this.instanceId;
                    }

                    public Create setInstanceId(String instanceId) {
                        this.instanceId = instanceId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }

                public class CheckUpgradability
                extends AIPlatformNotebooksRequest<CheckInstanceUpgradabilityResponse> {
                    private static final String REST_PATH = "v2/{+notebookInstance}:checkUpgradability";
                    private final Pattern NOTEBOOK_INSTANCE_PATTERN;
                    @Key
                    private String notebookInstance;

                    protected CheckUpgradability(String notebookInstance) {
                        super(AIPlatformNotebooks.this, "GET", REST_PATH, null, CheckInstanceUpgradabilityResponse.class);
                        this.NOTEBOOK_INSTANCE_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        this.notebookInstance = (String)Preconditions.checkNotNull((Object)notebookInstance, (Object)"Required parameter notebookInstance must be specified.");
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(), (Object)"Parameter notebookInstance must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public CheckUpgradability set$Xgafv(String $Xgafv) {
                        return (CheckUpgradability)super.set$Xgafv($Xgafv);
                    }

                    public CheckUpgradability setAccessToken(String accessToken) {
                        return (CheckUpgradability)super.setAccessToken(accessToken);
                    }

                    public CheckUpgradability setAlt(String alt) {
                        return (CheckUpgradability)super.setAlt(alt);
                    }

                    public CheckUpgradability setCallback(String callback) {
                        return (CheckUpgradability)super.setCallback(callback);
                    }

                    public CheckUpgradability setFields(String fields) {
                        return (CheckUpgradability)super.setFields(fields);
                    }

                    public CheckUpgradability setKey(String key) {
                        return (CheckUpgradability)super.setKey(key);
                    }

                    public CheckUpgradability setOauthToken(String oauthToken) {
                        return (CheckUpgradability)super.setOauthToken(oauthToken);
                    }

                    public CheckUpgradability setPrettyPrint(Boolean prettyPrint) {
                        return (CheckUpgradability)super.setPrettyPrint(prettyPrint);
                    }

                    public CheckUpgradability setQuotaUser(String quotaUser) {
                        return (CheckUpgradability)super.setQuotaUser(quotaUser);
                    }

                    public CheckUpgradability setUploadType(String uploadType) {
                        return (CheckUpgradability)super.setUploadType(uploadType);
                    }

                    public CheckUpgradability setUploadProtocol(String uploadProtocol) {
                        return (CheckUpgradability)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getNotebookInstance() {
                        return this.notebookInstance;
                    }

                    public CheckUpgradability setNotebookInstance(String notebookInstance) {
                        if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NOTEBOOK_INSTANCE_PATTERN.matcher(notebookInstance).matches(), (Object)"Parameter notebookInstance must conform to the pattern ^projects/[^/]+/locations/[^/]+/instances/[^/]+$");
                        }
                        this.notebookInstance = notebookInstance;
                        return this;
                    }

                    @Override
                    public CheckUpgradability set(String parameterName, Object value) {
                        return (CheckUpgradability)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends AIPlatformNotebooksRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v2/{+name}/locations";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String filter;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String name) {
                    super(AIPlatformNotebooks.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String name) {
                    if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends AIPlatformNotebooksRequest<Location> {
                private static final String REST_PATH = "v2/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(AIPlatformNotebooks.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!AIPlatformNotebooks.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }
        }
    }
}

