/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-23 at 01:21:04 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.oauth2.model;

/**
 * Model definition for Tokeninfo.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google OAuth2 API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Tokeninfo extends com.google.api.client.json.GenericJson {

  /**
   * The access type granted with this token. It can be offline or online.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("access_type")
  private java.lang.String accessType;

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String audience;

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("email_verified")
  private java.lang.Boolean emailVerified;

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("expires_in")
  private java.lang.Integer expiresIn;

  /**
   * The issue time of the token, as number of seconds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("issued_at")
  private java.lang.Integer issuedAt;

  /**
   * To whom was the token issued to. In general the same as audience.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("issued_to")
  private java.lang.String issuedTo;

  /**
   * Who issued the token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String issuer;

  /**
   * Nonce of the id token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nonce;

  /**
   * The space separated list of scopes granted to this token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String scope;

  /**
   * The obfuscated user id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("user_id")
  private java.lang.String userId;

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("verified_email")
  private java.lang.Boolean verifiedEmail;

  /**
   * The access type granted with this token. It can be offline or online.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccessType() {
    return accessType;
  }

  /**
   * The access type granted with this token. It can be offline or online.
   * @param accessType accessType or {@code null} for none
   */
  public Tokeninfo setAccessType(java.lang.String accessType) {
    this.accessType = accessType;
    return this;
  }

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * @return value or {@code null} for none
   */
  public java.lang.String getAudience() {
    return audience;
  }

  /**
   * Who is the intended audience for this token. In general the same as issued_to.
   * @param audience audience or {@code null} for none
   */
  public Tokeninfo setAudience(java.lang.String audience) {
    this.audience = audience;
    return this;
  }

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The email address of the user. Present only if the email scope is present in the request.
   * @param email email or {@code null} for none
   */
  public Tokeninfo setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmailVerified() {
    return emailVerified;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * @param emailVerified emailVerified or {@code null} for none
   */
  public Tokeninfo setEmailVerified(java.lang.Boolean emailVerified) {
    this.emailVerified = emailVerified;
    return this;
  }

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getExpiresIn() {
    return expiresIn;
  }

  /**
   * The expiry time of the token, as number of seconds left until expiry.
   * @param expiresIn expiresIn or {@code null} for none
   */
  public Tokeninfo setExpiresIn(java.lang.Integer expiresIn) {
    this.expiresIn = expiresIn;
    return this;
  }

  /**
   * The issue time of the token, as number of seconds.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getIssuedAt() {
    return issuedAt;
  }

  /**
   * The issue time of the token, as number of seconds.
   * @param issuedAt issuedAt or {@code null} for none
   */
  public Tokeninfo setIssuedAt(java.lang.Integer issuedAt) {
    this.issuedAt = issuedAt;
    return this;
  }

  /**
   * To whom was the token issued to. In general the same as audience.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuedTo() {
    return issuedTo;
  }

  /**
   * To whom was the token issued to. In general the same as audience.
   * @param issuedTo issuedTo or {@code null} for none
   */
  public Tokeninfo setIssuedTo(java.lang.String issuedTo) {
    this.issuedTo = issuedTo;
    return this;
  }

  /**
   * Who issued the token.
   * @return value or {@code null} for none
   */
  public java.lang.String getIssuer() {
    return issuer;
  }

  /**
   * Who issued the token.
   * @param issuer issuer or {@code null} for none
   */
  public Tokeninfo setIssuer(java.lang.String issuer) {
    this.issuer = issuer;
    return this;
  }

  /**
   * Nonce of the id token.
   * @return value or {@code null} for none
   */
  public java.lang.String getNonce() {
    return nonce;
  }

  /**
   * Nonce of the id token.
   * @param nonce nonce or {@code null} for none
   */
  public Tokeninfo setNonce(java.lang.String nonce) {
    this.nonce = nonce;
    return this;
  }

  /**
   * The space separated list of scopes granted to this token.
   * @return value or {@code null} for none
   */
  public java.lang.String getScope() {
    return scope;
  }

  /**
   * The space separated list of scopes granted to this token.
   * @param scope scope or {@code null} for none
   */
  public Tokeninfo setScope(java.lang.String scope) {
    this.scope = scope;
    return this;
  }

  /**
   * The obfuscated user id.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserId() {
    return userId;
  }

  /**
   * The obfuscated user id.
   * @param userId userId or {@code null} for none
   */
  public Tokeninfo setUserId(java.lang.String userId) {
    this.userId = userId;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedEmail() {
    return verifiedEmail;
  }

  /**
   * Boolean flag which is true if the email address is verified. Present only if the email scope is
   * present in the request.
   * @param verifiedEmail verifiedEmail or {@code null} for none
   */
  public Tokeninfo setVerifiedEmail(java.lang.Boolean verifiedEmail) {
    this.verifiedEmail = verifiedEmail;
    return this;
  }

  @Override
  public Tokeninfo set(String fieldName, Object value) {
    return (Tokeninfo) super.set(fieldName, value);
  }

  @Override
  public Tokeninfo clone() {
    return (Tokeninfo) super.clone();
  }

}
