/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-10 at 12:11:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.oauth2.model;

/**
 * Model definition for Userinfoplus.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google OAuth2 API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Userinfoplus extends com.google.api.client.json.GenericJson {

  /**
   * The user's email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String email;

  /**
   * The user's last name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("family_name")
  private java.lang.String familyName;

  /**
   * The user's gender.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String gender;

  /**
   * The user's first name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("given_name")
  private java.lang.String givenName;

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String hd;

  /**
   * The obfuscated ID of the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * URL of the profile page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String link;

  /**
   * The user's preferred locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locale;

  /**
   * The user's full name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * URL of the user's picture image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String picture;

  /**
   * Boolean flag which is true if the email address is verified. Always verified because we only
   * return the user's primary email address.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("verified_email")
  private java.lang.Boolean verifiedEmail;

  /**
   * The user's email address.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmail() {
    return email;
  }

  /**
   * The user's email address.
   * @param email email or {@code null} for none
   */
  public Userinfoplus setEmail(java.lang.String email) {
    this.email = email;
    return this;
  }

  /**
   * The user's last name.
   * @return value or {@code null} for none
   */
  public java.lang.String getFamilyName() {
    return familyName;
  }

  /**
   * The user's last name.
   * @param familyName familyName or {@code null} for none
   */
  public Userinfoplus setFamilyName(java.lang.String familyName) {
    this.familyName = familyName;
    return this;
  }

  /**
   * The user's gender.
   * @return value or {@code null} for none
   */
  public java.lang.String getGender() {
    return gender;
  }

  /**
   * The user's gender.
   * @param gender gender or {@code null} for none
   */
  public Userinfoplus setGender(java.lang.String gender) {
    this.gender = gender;
    return this;
  }

  /**
   * The user's first name.
   * @return value or {@code null} for none
   */
  public java.lang.String getGivenName() {
    return givenName;
  }

  /**
   * The user's first name.
   * @param givenName givenName or {@code null} for none
   */
  public Userinfoplus setGivenName(java.lang.String givenName) {
    this.givenName = givenName;
    return this;
  }

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * @return value or {@code null} for none
   */
  public java.lang.String getHd() {
    return hd;
  }

  /**
   * The hosted domain e.g. example.com if the user is Google apps user.
   * @param hd hd or {@code null} for none
   */
  public Userinfoplus setHd(java.lang.String hd) {
    this.hd = hd;
    return this;
  }

  /**
   * The obfuscated ID of the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The obfuscated ID of the user.
   * @param id id or {@code null} for none
   */
  public Userinfoplus setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * URL of the profile page.
   * @return value or {@code null} for none
   */
  public java.lang.String getLink() {
    return link;
  }

  /**
   * URL of the profile page.
   * @param link link or {@code null} for none
   */
  public Userinfoplus setLink(java.lang.String link) {
    this.link = link;
    return this;
  }

  /**
   * The user's preferred locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocale() {
    return locale;
  }

  /**
   * The user's preferred locale.
   * @param locale locale or {@code null} for none
   */
  public Userinfoplus setLocale(java.lang.String locale) {
    this.locale = locale;
    return this;
  }

  /**
   * The user's full name.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The user's full name.
   * @param name name or {@code null} for none
   */
  public Userinfoplus setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * URL of the user's picture image.
   * @return value or {@code null} for none
   */
  public java.lang.String getPicture() {
    return picture;
  }

  /**
   * URL of the user's picture image.
   * @param picture picture or {@code null} for none
   */
  public Userinfoplus setPicture(java.lang.String picture) {
    this.picture = picture;
    return this;
  }

  /**
   * Boolean flag which is true if the email address is verified. Always verified because we only
   * return the user's primary email address.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getVerifiedEmail() {
    return verifiedEmail;
  }

  /**
   * Boolean flag which is true if the email address is verified. Always verified because we only
   * return the user's primary email address.
   * @param verifiedEmail verifiedEmail or {@code null} for none
   */
  public Userinfoplus setVerifiedEmail(java.lang.Boolean verifiedEmail) {
    this.verifiedEmail = verifiedEmail;
    return this;
  }

  /**
   * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
   *
   * <p>
   * Boolean properties can have four possible values:
   * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
   * or {@link Boolean#FALSE}.
   * </p>
   *
   * <p>
   * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
   * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
   * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
   * </p>
   *
   * <p>
   * Boolean flag which is true if the email address is verified. Always verified because we only return
 the user's primary email address.
   * </p>
   */
  public boolean isVerifiedEmail() {
    if (verifiedEmail == null || verifiedEmail == com.google.api.client.util.Data.NULL_BOOLEAN) {
      return true;
    }
    return verifiedEmail;
  }

  @Override
  public Userinfoplus set(String fieldName, Object value) {
    return (Userinfoplus) super.set(fieldName, value);
  }

  @Override
  public Userinfoplus clone() {
    return (Userinfoplus) super.clone();
  }

}
