/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's short biography.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Biography extends com.google.api.client.json.GenericJson {

  /**
   * The content type of the biography.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentType;

  /**
   * Metadata about the biography.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The short biography.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The content type of the biography.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentType() {
    return contentType;
  }

  /**
   * The content type of the biography.
   * @param contentType contentType or {@code null} for none
   */
  public Biography setContentType(java.lang.String contentType) {
    this.contentType = contentType;
    return this;
  }

  /**
   * Metadata about the biography.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the biography.
   * @param metadata metadata or {@code null} for none
   */
  public Biography setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The short biography.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The short biography.
   * @param value value or {@code null} for none
   */
  public Biography setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public Biography set(String fieldName, Object value) {
    return (Biography) super.set(fieldName, value);
  }

  @Override
  public Biography clone() {
    return (Biography) super.clone();
  }

}
