/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's birthday. At least one of the `date` and `text` fields are specified. The `date` and
 * `text` fields typically represent the same date, but are not guaranteed to.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Birthday extends com.google.api.client.json.GenericJson {

  /**
   * The date of the birthday.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date date;

  /**
   * Metadata about the birthday.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * A free-form string representing the user's birthday.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * The date of the birthday.
   * @return value or {@code null} for none
   */
  public Date getDate() {
    return date;
  }

  /**
   * The date of the birthday.
   * @param date date or {@code null} for none
   */
  public Birthday setDate(Date date) {
    this.date = date;
    return this;
  }

  /**
   * Metadata about the birthday.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the birthday.
   * @param metadata metadata or {@code null} for none
   */
  public Birthday setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * A free-form string representing the user's birthday.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * A free-form string representing the user's birthday.
   * @param text text or {@code null} for none
   */
  public Birthday setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public Birthday set(String fieldName, Object value) {
    return (Birthday) super.set(fieldName, value);
  }

  @Override
  public Birthday clone() {
    return (Birthday) super.clone();
  }

}
