/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's gender.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Gender extends com.google.api.client.json.GenericJson {

  /**
   * The read-only value of the gender translated and formatted in the viewer's account locale or
   * the `Accept-Language` HTTP header locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedValue;

  /**
   * Metadata about the gender.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The gender for the person. The gender can be custom or predefined. Possible values include, but
   * are not limited to, the following:
   *
   * * `male` * `female` * `other` * `unknown`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The read-only value of the gender translated and formatted in the viewer's account locale or
   * the `Accept-Language` HTTP header locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedValue() {
    return formattedValue;
  }

  /**
   * The read-only value of the gender translated and formatted in the viewer's account locale or
   * the `Accept-Language` HTTP header locale.
   * @param formattedValue formattedValue or {@code null} for none
   */
  public Gender setFormattedValue(java.lang.String formattedValue) {
    this.formattedValue = formattedValue;
    return this;
  }

  /**
   * Metadata about the gender.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the gender.
   * @param metadata metadata or {@code null} for none
   */
  public Gender setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The gender for the person. The gender can be custom or predefined. Possible values include, but
   * are not limited to, the following:
   *
   * * `male` * `female` * `other` * `unknown`
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The gender for the person. The gender can be custom or predefined. Possible values include, but
   * are not limited to, the following:
   *
   * * `male` * `female` * `other` * `unknown`
   * @param value value or {@code null} for none
   */
  public Gender setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public Gender set(String fieldName, Object value) {
    return (Gender) super.set(fieldName, value);
  }

  @Override
  public Gender clone() {
    return (Gender) super.clone();
  }

}
