/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's read-only membership in a group.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Membership extends com.google.api.client.json.GenericJson {

  /**
   * The contact group membership.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ContactGroupMembership contactGroupMembership;

  /**
   * The domain membership.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DomainMembership domainMembership;

  /**
   * Metadata about the membership.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The contact group membership.
   * @return value or {@code null} for none
   */
  public ContactGroupMembership getContactGroupMembership() {
    return contactGroupMembership;
  }

  /**
   * The contact group membership.
   * @param contactGroupMembership contactGroupMembership or {@code null} for none
   */
  public Membership setContactGroupMembership(ContactGroupMembership contactGroupMembership) {
    this.contactGroupMembership = contactGroupMembership;
    return this;
  }

  /**
   * The domain membership.
   * @return value or {@code null} for none
   */
  public DomainMembership getDomainMembership() {
    return domainMembership;
  }

  /**
   * The domain membership.
   * @param domainMembership domainMembership or {@code null} for none
   */
  public Membership setDomainMembership(DomainMembership domainMembership) {
    this.domainMembership = domainMembership;
    return this;
  }

  /**
   * Metadata about the membership.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the membership.
   * @param metadata metadata or {@code null} for none
   */
  public Membership setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  @Override
  public Membership set(String fieldName, Object value) {
    return (Membership) super.set(fieldName, value);
  }

  @Override
  public Membership clone() {
    return (Membership) super.clone();
  }

}
