/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * The read-only metadata about a person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PersonMetadata extends com.google.api.client.json.GenericJson {

  /**
   * True if the person resource has been deleted. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Resource names of people linked to this resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> linkedPeopleResourceNames;

  /**
   * **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType` instead)
   *
   * The type of the person object.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String objectType;

  /**
   * Any former resource names this person has had. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   *
   * The resource name may change when adding or removing fields that link a contact and profile
   * such as a verified email, verified phone number, or profile URL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> previousResourceNames;

  /**
   * The sources of data for the person.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Source> sources;

  static {
    // hack to force ProGuard to consider Source used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Source.class);
  }

  /**
   * True if the person resource has been deleted. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * True if the person resource has been deleted. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   * @param deleted deleted or {@code null} for none
   */
  public PersonMetadata setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Resource names of people linked to this resource.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getLinkedPeopleResourceNames() {
    return linkedPeopleResourceNames;
  }

  /**
   * Resource names of people linked to this resource.
   * @param linkedPeopleResourceNames linkedPeopleResourceNames or {@code null} for none
   */
  public PersonMetadata setLinkedPeopleResourceNames(java.util.List<java.lang.String> linkedPeopleResourceNames) {
    this.linkedPeopleResourceNames = linkedPeopleResourceNames;
    return this;
  }

  /**
   * **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType` instead)
   *
   * The type of the person object.
   * @return value or {@code null} for none
   */
  public java.lang.String getObjectType() {
    return objectType;
  }

  /**
   * **DEPRECATED** (Please use `person.metadata.sources.profileMetadata.objectType` instead)
   *
   * The type of the person object.
   * @param objectType objectType or {@code null} for none
   */
  public PersonMetadata setObjectType(java.lang.String objectType) {
    this.objectType = objectType;
    return this;
  }

  /**
   * Any former resource names this person has had. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   *
   * The resource name may change when adding or removing fields that link a contact and profile
   * such as a verified email, verified phone number, or profile URL.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPreviousResourceNames() {
    return previousResourceNames;
  }

  /**
   * Any former resource names this person has had. Populated only for
   * [`connections.list`](/people/api/rest/v1/people.connections/list) requests that include a sync
   * token.
   *
   * The resource name may change when adding or removing fields that link a contact and profile
   * such as a verified email, verified phone number, or profile URL.
   * @param previousResourceNames previousResourceNames or {@code null} for none
   */
  public PersonMetadata setPreviousResourceNames(java.util.List<java.lang.String> previousResourceNames) {
    this.previousResourceNames = previousResourceNames;
    return this;
  }

  /**
   * The sources of data for the person.
   * @return value or {@code null} for none
   */
  public java.util.List<Source> getSources() {
    return sources;
  }

  /**
   * The sources of data for the person.
   * @param sources sources or {@code null} for none
   */
  public PersonMetadata setSources(java.util.List<Source> sources) {
    this.sources = sources;
    return this;
  }

  @Override
  public PersonMetadata set(String fieldName, Object value) {
    return (PersonMetadata) super.set(fieldName, value);
  }

  @Override
  public PersonMetadata clone() {
    return (PersonMetadata) super.clone();
  }

}
