/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's phone number.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PhoneNumber extends com.google.api.client.json.GenericJson {

  /**
   * The read-only canonicalized [ITU-T
   * E.164](https://law.resource.org/pub/us/cfr/ibr/004/itu-t.E.164.1.2008.pdf) form of the phone
   * number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String canonicalForm;

  /**
   * The read-only type of the phone number translated and formatted in the viewer's account locale
   * or the `Accept-Language` HTTP header locale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formattedType;

  /**
   * Metadata about the phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The type of the phone number. The type can be custom or predefined. Possible values include,
   * but are not limited to, the following:
   *
   * * `home` * `work` * `mobile` * `homeFax` * `workFax` * `otherFax` * `pager` * `workMobile` *
   * `workPager` * `main` * `googleVoice` * `other`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The phone number.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * The read-only canonicalized [ITU-T
   * E.164](https://law.resource.org/pub/us/cfr/ibr/004/itu-t.E.164.1.2008.pdf) form of the phone
   * number.
   * @return value or {@code null} for none
   */
  public java.lang.String getCanonicalForm() {
    return canonicalForm;
  }

  /**
   * The read-only canonicalized [ITU-T
   * E.164](https://law.resource.org/pub/us/cfr/ibr/004/itu-t.E.164.1.2008.pdf) form of the phone
   * number.
   * @param canonicalForm canonicalForm or {@code null} for none
   */
  public PhoneNumber setCanonicalForm(java.lang.String canonicalForm) {
    this.canonicalForm = canonicalForm;
    return this;
  }

  /**
   * The read-only type of the phone number translated and formatted in the viewer's account locale
   * or the `Accept-Language` HTTP header locale.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormattedType() {
    return formattedType;
  }

  /**
   * The read-only type of the phone number translated and formatted in the viewer's account locale
   * or the `Accept-Language` HTTP header locale.
   * @param formattedType formattedType or {@code null} for none
   */
  public PhoneNumber setFormattedType(java.lang.String formattedType) {
    this.formattedType = formattedType;
    return this;
  }

  /**
   * Metadata about the phone number.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the phone number.
   * @param metadata metadata or {@code null} for none
   */
  public PhoneNumber setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The type of the phone number. The type can be custom or predefined. Possible values include,
   * but are not limited to, the following:
   *
   * * `home` * `work` * `mobile` * `homeFax` * `workFax` * `otherFax` * `pager` * `workMobile` *
   * `workPager` * `main` * `googleVoice` * `other`
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the phone number. The type can be custom or predefined. Possible values include,
   * but are not limited to, the following:
   *
   * * `home` * `work` * `mobile` * `homeFax` * `workFax` * `otherFax` * `pager` * `workMobile` *
   * `workPager` * `main` * `googleVoice` * `other`
   * @param type type or {@code null} for none
   */
  public PhoneNumber setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * The phone number.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * The phone number.
   * @param value value or {@code null} for none
   */
  public PhoneNumber setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public PhoneNumber set(String fieldName, Object value) {
    return (PhoneNumber) super.set(fieldName, value);
  }

  @Override
  public PhoneNumber clone() {
    return (PhoneNumber) super.clone();
  }

}
