/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2017-12-18 at 22:17:58 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.people.v1.model;

/**
 * A person's read-only photo. A picture shown next to the person's name to help others recognize
 * the person.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google People API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Photo extends com.google.api.client.json.GenericJson {

  /**
   * True if the photo is a default photo; false if the photo is a user-provided photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key("default")
  private java.lang.Boolean default__;

  /**
   * Metadata about the photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FieldMetadata metadata;

  /**
   * The URL of the photo. You can change the desired size by appending a query parameter `sz=`size
   * at the end of the url. Example: `https://lh3.googleusercontent.com/-T_wVWLlmg7w/AAAAAAAAAAI/AAA
   * AAAAABa8/00gzXvDBYqw/s100/photo.jpg?sz=50`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String url;

  /**
   * True if the photo is a default photo; false if the photo is a user-provided photo.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDefault() {
    return default__;
  }

  /**
   * True if the photo is a default photo; false if the photo is a user-provided photo.
   * @param default__ default__ or {@code null} for none
   */
  public Photo setDefault(java.lang.Boolean default__) {
    this.default__ = default__;
    return this;
  }

  /**
   * Metadata about the photo.
   * @return value or {@code null} for none
   */
  public FieldMetadata getMetadata() {
    return metadata;
  }

  /**
   * Metadata about the photo.
   * @param metadata metadata or {@code null} for none
   */
  public Photo setMetadata(FieldMetadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * The URL of the photo. You can change the desired size by appending a query parameter `sz=`size
   * at the end of the url. Example: `https://lh3.googleusercontent.com/-T_wVWLlmg7w/AAAAAAAAAAI/AAA
   * AAAAABa8/00gzXvDBYqw/s100/photo.jpg?sz=50`
   * @return value or {@code null} for none
   */
  public java.lang.String getUrl() {
    return url;
  }

  /**
   * The URL of the photo. You can change the desired size by appending a query parameter `sz=`size
   * at the end of the url. Example: `https://lh3.googleusercontent.com/-T_wVWLlmg7w/AAAAAAAAAAI/AAA
   * AAAAABa8/00gzXvDBYqw/s100/photo.jpg?sz=50`
   * @param url url or {@code null} for none
   */
  public Photo setUrl(java.lang.String url) {
    this.url = url;
    return this;
  }

  @Override
  public Photo set(String fieldName, Object value) {
    return (Photo) super.set(fieldName, value);
  }

  @Override
  public Photo clone() {
    return (Photo) super.clone();
  }

}
