/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1;

/**
 * Service definition for PeopleService (v1).
 *
 * <p>
 * Provides access to information about profiles and contacts.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/people/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link PeopleServiceRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class PeopleService extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the People API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://people.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://people.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public PeopleService(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  PeopleService(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the ContactGroups collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code PeopleService people = new PeopleService(...);}
   *   {@code PeopleService.ContactGroups.List request = people.contactGroups().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public ContactGroups contactGroups() {
    return new ContactGroups();
  }

  /**
   * The "contactGroups" collection of methods.
   */
  public class ContactGroups {

    /**
     * Get a list of contact groups owned by the authenticated user by specifying a list of contact
     * group resource names.
     *
     * Create a request for the method "contactGroups.batchGet".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public BatchGet batchGet() throws java.io.IOException {
      BatchGet result = new BatchGet();
      initialize(result);
      return result;
    }

    public class BatchGet extends PeopleServiceRequest<com.google.api.services.people.v1.model.BatchGetContactGroupsResponse> {

      private static final String REST_PATH = "v1/contactGroups:batchGet";

      /**
       * Get a list of contact groups owned by the authenticated user by specifying a list of contact
       * group resource names.
       *
       * Create a request for the method "contactGroups.batchGet".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation. <p>
       * {@link
       * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected BatchGet() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.BatchGetContactGroupsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public BatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (BatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchGet setAccessToken(java.lang.String accessToken) {
        return (BatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public BatchGet setAlt(java.lang.String alt) {
        return (BatchGet) super.setAlt(alt);
      }

      @Override
      public BatchGet setCallback(java.lang.String callback) {
        return (BatchGet) super.setCallback(callback);
      }

      @Override
      public BatchGet setFields(java.lang.String fields) {
        return (BatchGet) super.setFields(fields);
      }

      @Override
      public BatchGet setKey(java.lang.String key) {
        return (BatchGet) super.setKey(key);
      }

      @Override
      public BatchGet setOauthToken(java.lang.String oauthToken) {
        return (BatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchGet setQuotaUser(java.lang.String quotaUser) {
        return (BatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchGet setUploadType(java.lang.String uploadType) {
        return (BatchGet) super.setUploadType(uploadType);
      }

      @Override
      public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchGet) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      @com.google.api.client.util.Key
      private String groupFields;

      /** Optional. A field mask to restrict which fields on the group are returned. Defaults to `metadata`,
     `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields are: * clientData *
     groupType * memberCount * metadata * name
       */
      public String getGroupFields() {
        return groupFields;
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      public BatchGet setGroupFields(String groupFields) {
        this.groupFields = groupFields;
        return this;
      }

      /**
       * Optional. Specifies the maximum number of members to return for each group. Defaults to 0
       * if not set, which will return zero members.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxMembers;

      /** Optional. Specifies the maximum number of members to return for each group. Defaults to 0 if not
     set, which will return zero members.
       */
      public java.lang.Integer getMaxMembers() {
        return maxMembers;
      }

      /**
       * Optional. Specifies the maximum number of members to return for each group. Defaults to 0
       * if not set, which will return zero members.
       */
      public BatchGet setMaxMembers(java.lang.Integer maxMembers) {
        this.maxMembers = maxMembers;
        return this;
      }

      /**
       * Required. The resource names of the contact groups to get. There is a maximum of 200
       * resource names.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> resourceNames;

      /** Required. The resource names of the contact groups to get. There is a maximum of 200 resource
     names.
       */
      public java.util.List<java.lang.String> getResourceNames() {
        return resourceNames;
      }

      /**
       * Required. The resource names of the contact groups to get. There is a maximum of 200
       * resource names.
       */
      public BatchGet setResourceNames(java.util.List<java.lang.String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
      }

      @Override
      public BatchGet set(String parameterName, Object value) {
        return (BatchGet) super.set(parameterName, value);
      }
    }
    /**
     * Create a new contact group owned by the authenticated user. Created contact group names must be
     * unique to the users contact groups. Attempting to create a group with a duplicate name will
     * return a HTTP 409 error.
     *
     * Create a request for the method "contactGroups.create".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.people.v1.model.CreateContactGroupRequest}
     * @return the request
     */
    public Create create(com.google.api.services.people.v1.model.CreateContactGroupRequest content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends PeopleServiceRequest<com.google.api.services.people.v1.model.ContactGroup> {

      private static final String REST_PATH = "v1/contactGroups";

      /**
       * Create a new contact group owned by the authenticated user. Created contact group names must be
       * unique to the users contact groups. Attempting to create a group with a duplicate name will
       * return a HTTP 409 error.
       *
       * Create a request for the method "contactGroups.create".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.people.v1.model.CreateContactGroupRequest}
       * @since 1.13
       */
      protected Create(com.google.api.services.people.v1.model.CreateContactGroupRequest content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.ContactGroup.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Delete an existing contact group owned by the authenticated user by specifying a contact group
     * resource name.
     *
     * Create a request for the method "contactGroups.delete".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. The resource name of the contact group to delete.
     * @return the request
     */
    public Delete delete(java.lang.String resourceName) throws java.io.IOException {
      Delete result = new Delete(resourceName);
      initialize(result);
      return result;
    }

    public class Delete extends PeopleServiceRequest<com.google.api.services.people.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^contactGroups/[^/]+$");

      /**
       * Delete an existing contact group owned by the authenticated user by specifying a contact group
       * resource name.
       *
       * Create a request for the method "contactGroups.delete".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName Required. The resource name of the contact group to delete.
       * @since 1.13
       */
      protected Delete(java.lang.String resourceName) {
        super(PeopleService.this, "DELETE", REST_PATH, null, com.google.api.services.people.v1.model.Empty.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
      }

      @Override
      public Delete set$Xgafv(java.lang.String $Xgafv) {
        return (Delete) super.set$Xgafv($Xgafv);
      }

      @Override
      public Delete setAccessToken(java.lang.String accessToken) {
        return (Delete) super.setAccessToken(accessToken);
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setCallback(java.lang.String callback) {
        return (Delete) super.setCallback(callback);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUploadType(java.lang.String uploadType) {
        return (Delete) super.setUploadType(uploadType);
      }

      @Override
      public Delete setUploadProtocol(java.lang.String uploadProtocol) {
        return (Delete) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The resource name of the contact group to delete. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the contact group to delete.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. The resource name of the contact group to delete. */
      public Delete setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      /** Optional. Set to true to also delete the contacts in the specified group. */
      @com.google.api.client.util.Key
      private java.lang.Boolean deleteContacts;

      /** Optional. Set to true to also delete the contacts in the specified group.
       */
      public java.lang.Boolean getDeleteContacts() {
        return deleteContacts;
      }

      /** Optional. Set to true to also delete the contacts in the specified group. */
      public Delete setDeleteContacts(java.lang.Boolean deleteContacts) {
        this.deleteContacts = deleteContacts;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Get a specific contact group owned by the authenticated user by specifying a contact group
     * resource name.
     *
     * Create a request for the method "contactGroups.get".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. The resource name of the contact group to get.
     * @return the request
     */
    public Get get(java.lang.String resourceName) throws java.io.IOException {
      Get result = new Get(resourceName);
      initialize(result);
      return result;
    }

    public class Get extends PeopleServiceRequest<com.google.api.services.people.v1.model.ContactGroup> {

      private static final String REST_PATH = "v1/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^contactGroups/[^/]+$");

      /**
       * Get a specific contact group owned by the authenticated user by specifying a contact group
       * resource name.
       *
       * Create a request for the method "contactGroups.get".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName Required. The resource name of the contact group to get.
       * @since 1.13
       */
      protected Get(java.lang.String resourceName) {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.ContactGroup.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The resource name of the contact group to get. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the contact group to get.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. The resource name of the contact group to get. */
      public Get setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      @com.google.api.client.util.Key
      private String groupFields;

      /** Optional. A field mask to restrict which fields on the group are returned. Defaults to `metadata`,
     `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields are: * clientData *
     groupType * memberCount * metadata * name
       */
      public String getGroupFields() {
        return groupFields;
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      public Get setGroupFields(String groupFields) {
        this.groupFields = groupFields;
        return this;
      }

      /**
       * Optional. Specifies the maximum number of members to return. Defaults to 0 if not set,
       * which will return zero members.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer maxMembers;

      /** Optional. Specifies the maximum number of members to return. Defaults to 0 if not set, which will
     return zero members.
       */
      public java.lang.Integer getMaxMembers() {
        return maxMembers;
      }

      /**
       * Optional. Specifies the maximum number of members to return. Defaults to 0 if not set,
       * which will return zero members.
       */
      public Get setMaxMembers(java.lang.Integer maxMembers) {
        this.maxMembers = maxMembers;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * List all contact groups owned by the authenticated user. Members of the contact groups are not
     * populated.
     *
     * Create a request for the method "contactGroups.list".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends PeopleServiceRequest<com.google.api.services.people.v1.model.ListContactGroupsResponse> {

      private static final String REST_PATH = "v1/contactGroups";

      /**
       * List all contact groups owned by the authenticated user. Members of the contact groups are not
       * populated.
       *
       * Create a request for the method "contactGroups.list".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.ListContactGroupsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      @com.google.api.client.util.Key
      private String groupFields;

      /** Optional. A field mask to restrict which fields on the group are returned. Defaults to `metadata`,
     `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields are: * clientData *
     groupType * memberCount * metadata * name
       */
      public String getGroupFields() {
        return groupFields;
      }

      /**
       * Optional. A field mask to restrict which fields on the group are returned. Defaults to
       * `metadata`, `groupType`, `memberCount`, and `name` if not set or set to empty. Valid fields
       * are: * clientData * groupType * memberCount * metadata * name
       */
      public List setGroupFields(String groupFields) {
        this.groupFields = groupFields;
        return this;
      }

      /**
       * Optional. The maximum number of resources to return. Valid values are between 1 and 1000,
       * inclusive. Defaults to 30 if not set or set to 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The maximum number of resources to return. Valid values are between 1 and 1000,
     inclusive. Defaults to 30 if not set or set to 0.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The maximum number of resources to return. Valid values are between 1 and 1000,
       * inclusive. Defaults to 30 if not set or set to 0.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. The next_page_token value returned from a previous call to
       * [ListContactGroups](/people/api/rest/v1/contactgroups/list). Requests the next page of
       * resources.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. The next_page_token value returned from a previous call to
     [ListContactGroups](/people/api/rest/v1/contactgroups/list). Requests the next page of resources.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. The next_page_token value returned from a previous call to
       * [ListContactGroups](/people/api/rest/v1/contactgroups/list). Requests the next page of
       * resources.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. A sync token, returned by a previous call to `contactgroups.list`. Only resources
       * changed since the sync token was created will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Optional. A sync token, returned by a previous call to `contactgroups.list`. Only resources changed
     since the sync token was created will be returned.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Optional. A sync token, returned by a previous call to `contactgroups.list`. Only resources
       * changed since the sync token was created will be returned.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Update the name of an existing contact group owned by the authenticated user. Updated contact
     * group names must be unique to the users contact groups. Attempting to create a group with a
     * duplicate name will return a HTTP 409 error.
     *
     * Create a request for the method "contactGroups.update".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param resourceName The resource name for the contact group, assigned by the server. An ASCII string, in the form of
     *        `contactGroups/{contact_group_id}`.
     * @param content the {@link com.google.api.services.people.v1.model.UpdateContactGroupRequest}
     * @return the request
     */
    public Update update(java.lang.String resourceName, com.google.api.services.people.v1.model.UpdateContactGroupRequest content) throws java.io.IOException {
      Update result = new Update(resourceName, content);
      initialize(result);
      return result;
    }

    public class Update extends PeopleServiceRequest<com.google.api.services.people.v1.model.ContactGroup> {

      private static final String REST_PATH = "v1/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^contactGroups/[^/]+$");

      /**
       * Update the name of an existing contact group owned by the authenticated user. Updated contact
       * group names must be unique to the users contact groups. Attempting to create a group with a
       * duplicate name will return a HTTP 409 error.
       *
       * Create a request for the method "contactGroups.update".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName The resource name for the contact group, assigned by the server. An ASCII string, in the form of
     *        `contactGroups/{contact_group_id}`.
       * @param content the {@link com.google.api.services.people.v1.model.UpdateContactGroupRequest}
       * @since 1.13
       */
      protected Update(java.lang.String resourceName, com.google.api.services.people.v1.model.UpdateContactGroupRequest content) {
        super(PeopleService.this, "PUT", REST_PATH, content, com.google.api.services.people.v1.model.ContactGroup.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The resource name for the contact group, assigned by the server. An ASCII string, in the
       * form of `contactGroups/{contact_group_id}`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** The resource name for the contact group, assigned by the server. An ASCII string, in the form of
     `contactGroups/{contact_group_id}`.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /**
       * The resource name for the contact group, assigned by the server. An ASCII string, in the
       * form of `contactGroups/{contact_group_id}`.
       */
      public Update setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^contactGroups/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Members collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code PeopleService people = new PeopleService(...);}
     *   {@code PeopleService.Members.List request = people.members().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Members members() {
      return new Members();
    }

    /**
     * The "members" collection of methods.
     */
    public class Members {

      /**
       * Modify the members of a contact group owned by the authenticated user. The only system contact
       * groups that can have members added are `contactGroups/myContacts` and `contactGroups/starred`.
       * Other system contact groups are deprecated and can only have contacts removed.
       *
       * Create a request for the method "members.modify".
       *
       * This request holds the parameters needed by the people server.  After setting any optional
       * parameters, call the {@link Modify#execute()} method to invoke the remote operation.
       *
       * @param resourceName Required. The resource name of the contact group to modify.
       * @param content the {@link com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest}
       * @return the request
       */
      public Modify modify(java.lang.String resourceName, com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest content) throws java.io.IOException {
        Modify result = new Modify(resourceName, content);
        initialize(result);
        return result;
      }

      public class Modify extends PeopleServiceRequest<com.google.api.services.people.v1.model.ModifyContactGroupMembersResponse> {

        private static final String REST_PATH = "v1/{+resourceName}/members:modify";

        private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
            java.util.regex.Pattern.compile("^contactGroups/[^/]+$");

        /**
         * Modify the members of a contact group owned by the authenticated user. The only system contact
         * groups that can have members added are `contactGroups/myContacts` and `contactGroups/starred`.
         * Other system contact groups are deprecated and can only have contacts removed.
         *
         * Create a request for the method "members.modify".
         *
         * This request holds the parameters needed by the the people server.  After setting any optional
         * parameters, call the {@link Modify#execute()} method to invoke the remote operation. <p> {@link
         * Modify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resourceName Required. The resource name of the contact group to modify.
         * @param content the {@link com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest}
         * @since 1.13
         */
        protected Modify(java.lang.String resourceName, com.google.api.services.people.v1.model.ModifyContactGroupMembersRequest content) {
          super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.ModifyContactGroupMembersResponse.class);
          this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
                "Parameter resourceName must conform to the pattern " +
                "^contactGroups/[^/]+$");
          }
        }

        @Override
        public Modify set$Xgafv(java.lang.String $Xgafv) {
          return (Modify) super.set$Xgafv($Xgafv);
        }

        @Override
        public Modify setAccessToken(java.lang.String accessToken) {
          return (Modify) super.setAccessToken(accessToken);
        }

        @Override
        public Modify setAlt(java.lang.String alt) {
          return (Modify) super.setAlt(alt);
        }

        @Override
        public Modify setCallback(java.lang.String callback) {
          return (Modify) super.setCallback(callback);
        }

        @Override
        public Modify setFields(java.lang.String fields) {
          return (Modify) super.setFields(fields);
        }

        @Override
        public Modify setKey(java.lang.String key) {
          return (Modify) super.setKey(key);
        }

        @Override
        public Modify setOauthToken(java.lang.String oauthToken) {
          return (Modify) super.setOauthToken(oauthToken);
        }

        @Override
        public Modify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Modify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Modify setQuotaUser(java.lang.String quotaUser) {
          return (Modify) super.setQuotaUser(quotaUser);
        }

        @Override
        public Modify setUploadType(java.lang.String uploadType) {
          return (Modify) super.setUploadType(uploadType);
        }

        @Override
        public Modify setUploadProtocol(java.lang.String uploadProtocol) {
          return (Modify) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name of the contact group to modify. */
        @com.google.api.client.util.Key
        private java.lang.String resourceName;

        /** Required. The resource name of the contact group to modify.
         */
        public java.lang.String getResourceName() {
          return resourceName;
        }

        /** Required. The resource name of the contact group to modify. */
        public Modify setResourceName(java.lang.String resourceName) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
                "Parameter resourceName must conform to the pattern " +
                "^contactGroups/[^/]+$");
          }
          this.resourceName = resourceName;
          return this;
        }

        @Override
        public Modify set(String parameterName, Object value) {
          return (Modify) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the OtherContacts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code PeopleService people = new PeopleService(...);}
   *   {@code PeopleService.OtherContacts.List request = people.otherContacts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public OtherContacts otherContacts() {
    return new OtherContacts();
  }

  /**
   * The "otherContacts" collection of methods.
   */
  public class OtherContacts {

    /**
     * Copies an "Other contact" to a new contact in the user's "myContacts" group
     *
     * Create a request for the method "otherContacts.copyOtherContactToMyContactsGroup".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link CopyOtherContactToMyContactsGroup#execute()} method to invoke the
     * remote operation.
     *
     * @param resourceName Required. The resource name of the "Other contact" to copy.
     * @param content the {@link com.google.api.services.people.v1.model.CopyOtherContactToMyContactsGroupRequest}
     * @return the request
     */
    public CopyOtherContactToMyContactsGroup copyOtherContactToMyContactsGroup(java.lang.String resourceName, com.google.api.services.people.v1.model.CopyOtherContactToMyContactsGroupRequest content) throws java.io.IOException {
      CopyOtherContactToMyContactsGroup result = new CopyOtherContactToMyContactsGroup(resourceName, content);
      initialize(result);
      return result;
    }

    public class CopyOtherContactToMyContactsGroup extends PeopleServiceRequest<com.google.api.services.people.v1.model.Person> {

      private static final String REST_PATH = "v1/{+resourceName}:copyOtherContactToMyContactsGroup";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^otherContacts/[^/]+$");

      /**
       * Copies an "Other contact" to a new contact in the user's "myContacts" group
       *
       * Create a request for the method "otherContacts.copyOtherContactToMyContactsGroup".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link CopyOtherContactToMyContactsGroup#execute()} method to invoke the
       * remote operation. <p> {@link CopyOtherContactToMyContactsGroup#initialize(com.google.api.client
       * .googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param resourceName Required. The resource name of the "Other contact" to copy.
       * @param content the {@link com.google.api.services.people.v1.model.CopyOtherContactToMyContactsGroupRequest}
       * @since 1.13
       */
      protected CopyOtherContactToMyContactsGroup(java.lang.String resourceName, com.google.api.services.people.v1.model.CopyOtherContactToMyContactsGroupRequest content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.Person.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^otherContacts/[^/]+$");
        }
      }

      @Override
      public CopyOtherContactToMyContactsGroup set$Xgafv(java.lang.String $Xgafv) {
        return (CopyOtherContactToMyContactsGroup) super.set$Xgafv($Xgafv);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setAccessToken(java.lang.String accessToken) {
        return (CopyOtherContactToMyContactsGroup) super.setAccessToken(accessToken);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setAlt(java.lang.String alt) {
        return (CopyOtherContactToMyContactsGroup) super.setAlt(alt);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setCallback(java.lang.String callback) {
        return (CopyOtherContactToMyContactsGroup) super.setCallback(callback);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setFields(java.lang.String fields) {
        return (CopyOtherContactToMyContactsGroup) super.setFields(fields);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setKey(java.lang.String key) {
        return (CopyOtherContactToMyContactsGroup) super.setKey(key);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setOauthToken(java.lang.String oauthToken) {
        return (CopyOtherContactToMyContactsGroup) super.setOauthToken(oauthToken);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CopyOtherContactToMyContactsGroup) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setQuotaUser(java.lang.String quotaUser) {
        return (CopyOtherContactToMyContactsGroup) super.setQuotaUser(quotaUser);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setUploadType(java.lang.String uploadType) {
        return (CopyOtherContactToMyContactsGroup) super.setUploadType(uploadType);
      }

      @Override
      public CopyOtherContactToMyContactsGroup setUploadProtocol(java.lang.String uploadProtocol) {
        return (CopyOtherContactToMyContactsGroup) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The resource name of the "Other contact" to copy. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the "Other contact" to copy.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. The resource name of the "Other contact" to copy. */
      public CopyOtherContactToMyContactsGroup setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^otherContacts/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public CopyOtherContactToMyContactsGroup set(String parameterName, Object value) {
        return (CopyOtherContactToMyContactsGroup) super.set(parameterName, value);
      }
    }
    /**
     * List all "Other contacts", that is contacts that are not in a contact group. "Other contacts" are
     * typically auto created contacts from interactions. Sync tokens expire 7 days after the full sync.
     * A request with an expired sync token will result in a 410 error. In the case of such an error
     * clients should make a full sync request without a `sync_token`. The first page of a full sync
     * request has an additional quota. If the quota is exceeded, a 429 error will be returned. This
     * quota is fixed and can not be increased. When the `sync_token` is specified, resources deleted
     * since the last sync will be returned as a person with `PersonMetadata.deleted` set to true. When
     * the `page_token` or `sync_token` is specified, all other request parameters must match the first
     * call. Writes may have a propagation delay of several minutes for sync requests. Incremental syncs
     * are not intended for read-after-write use cases. See example usage at [List the user's other
     * contacts that have changed](/people/v1/other-
     * contacts#list_the_users_other_contacts_that_have_changed).
     *
     * Create a request for the method "otherContacts.list".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends PeopleServiceRequest<com.google.api.services.people.v1.model.ListOtherContactsResponse> {

      private static final String REST_PATH = "v1/otherContacts";

      /**
       * List all "Other contacts", that is contacts that are not in a contact group. "Other contacts"
       * are typically auto created contacts from interactions. Sync tokens expire 7 days after the full
       * sync. A request with an expired sync token will result in a 410 error. In the case of such an
       * error clients should make a full sync request without a `sync_token`. The first page of a full
       * sync request has an additional quota. If the quota is exceeded, a 429 error will be returned.
       * This quota is fixed and can not be increased. When the `sync_token` is specified, resources
       * deleted since the last sync will be returned as a person with `PersonMetadata.deleted` set to
       * true. When the `page_token` or `sync_token` is specified, all other request parameters must
       * match the first call. Writes may have a propagation delay of several minutes for sync requests.
       * Incremental syncs are not intended for read-after-write use cases. See example usage at [List
       * the user's other contacts that have changed](/people/v1/other-
       * contacts#list_the_users_other_contacts_that_have_changed).
       *
       * Create a request for the method "otherContacts.list".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.ListOtherContactsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. The number of "Other contacts" to include in the response. Valid values are
       * between 1 and 1000, inclusive. Defaults to 100 if not set or set to 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of "Other contacts" to include in the response. Valid values are between 1 and
     1000, inclusive. Defaults to 100 if not set or set to 0.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The number of "Other contacts" to include in the response. Valid values are
       * between 1 and 1000, inclusive. Defaults to 100 if not set or set to 0.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `otherContacts.list` must match the first call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A page token, received from a previous response `next_page_token`. Provide this to
     retrieve the subsequent page. When paginating, all other parameters provided to
     `otherContacts.list` must match the first call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `otherContacts.list` must match the first call that provided the page token.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. What values are valid depend on
       * what ReadSourceType is used. If READ_SOURCE_TYPE_CONTACT is used, valid values are: *
       * emailAddresses * metadata * names * phoneNumbers * photos If READ_SOURCE_TYPE_PROFILE is
       * used, valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. What values are valid depend on what ReadSourceType is
     used. If READ_SOURCE_TYPE_CONTACT is used, valid values are: * emailAddresses * metadata * names *
     phoneNumbers * photos If READ_SOURCE_TYPE_PROFILE is used, valid values are: * addresses *
     ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos * emailAddresses *
     events * externalIds * genders * imClients * interests * locales * locations * memberships *
     metadata * miscKeywords * names * nicknames * occupations * organizations * phoneNumbers * photos *
     relations * sipAddresses * skills * urls * userDefined
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. What values are valid depend on
       * what ReadSourceType is used. If READ_SOURCE_TYPE_CONTACT is used, valid values are: *
       * emailAddresses * metadata * names * phoneNumbers * photos If READ_SOURCE_TYPE_PROFILE is
       * used, valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      public List setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      /**
       * Optional. Whether the response should return `next_sync_token` on the last page of results.
       * It can be used to get incremental changes since the last request by setting it on the
       * request `sync_token`. More details about sync behavior at `otherContacts.list`.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean requestSyncToken;

      /** Optional. Whether the response should return `next_sync_token` on the last page of results. It can
     be used to get incremental changes since the last request by setting it on the request
     `sync_token`. More details about sync behavior at `otherContacts.list`.
       */
      public java.lang.Boolean getRequestSyncToken() {
        return requestSyncToken;
      }

      /**
       * Optional. Whether the response should return `next_sync_token` on the last page of results.
       * It can be used to get incremental changes since the last request by setting it on the
       * request `sync_token`. More details about sync behavior at `otherContacts.list`.
       */
      public List setRequestSyncToken(java.lang.Boolean requestSyncToken) {
        this.requestSyncToken = requestSyncToken;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if
       * not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if
       * not set.
       */
      public List setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      /**
       * Optional. A sync token, received from a previous response `next_sync_token` Provide this to
       * retrieve only the resources changed since the last request. When syncing, all other
       * parameters provided to `otherContacts.list` must match the first call that provided the
       * sync token. More details about sync behavior at `otherContacts.list`.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Optional. A sync token, received from a previous response `next_sync_token` Provide this to
     retrieve only the resources changed since the last request. When syncing, all other parameters
     provided to `otherContacts.list` must match the first call that provided the sync token. More
     details about sync behavior at `otherContacts.list`.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Optional. A sync token, received from a previous response `next_sync_token` Provide this to
       * retrieve only the resources changed since the last request. When syncing, all other
       * parameters provided to `otherContacts.list` must match the first call that provided the
       * sync token. More details about sync behavior at `otherContacts.list`.
       */
      public List setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Provides a list of contacts in the authenticated user's other contacts that matches the search
     * query. The query matches on a contact's `names`, `emailAddresses`, and `phoneNumbers` fields that
     * are from the OTHER_CONTACT source. **IMPORTANT**: Before searching, clients should send a warmup
     * request with an empty query to update the cache. See https://developers.google.com/people/v1
     * /other-contacts#search_the_users_other_contacts
     *
     * Create a request for the method "otherContacts.search".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Search search() throws java.io.IOException {
      Search result = new Search();
      initialize(result);
      return result;
    }

    public class Search extends PeopleServiceRequest<com.google.api.services.people.v1.model.SearchResponse> {

      private static final String REST_PATH = "v1/otherContacts:search";

      /**
       * Provides a list of contacts in the authenticated user's other contacts that matches the search
       * query. The query matches on a contact's `names`, `emailAddresses`, and `phoneNumbers` fields
       * that are from the OTHER_CONTACT source. **IMPORTANT**: Before searching, clients should send a
       * warmup request with an empty query to update the cache. See
       * https://developers.google.com/people/v1/other-contacts#search_the_users_other_contacts
       *
       * Create a request for the method "otherContacts.search".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Search#execute()} method to invoke the remote operation. <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Search() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.SearchResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0.
       * Values greater than 30 will be capped to 30.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0. Values
     greater than 30 will be capped to 30.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0.
       * Values greater than 30 will be capped to 30.
       */
      public Search setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Required. The plain-text query for the request. The query is used to match prefix phrases
       * of the fields on a person. For example, a person with name "foo name" matches queries such
       * as "f", "fo", "foo", "foo n", "nam", etc., but not "oo n".
       */
      @com.google.api.client.util.Key
      private java.lang.String query;

      /** Required. The plain-text query for the request. The query is used to match prefix phrases of the
     fields on a person. For example, a person with name "foo name" matches queries such as "f", "fo",
     "foo", "foo n", "nam", etc., but not "oo n".
       */
      public java.lang.String getQuery() {
        return query;
      }

      /**
       * Required. The plain-text query for the request. The query is used to match prefix phrases
       * of the fields on a person. For example, a person with name "foo name" matches queries such
       * as "f", "fo", "foo", "foo n", "nam", etc., but not "oo n".
       */
      public Search setQuery(java.lang.String query) {
        this.query = query;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * emailAddresses
       * * metadata * names * phoneNumbers
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * emailAddresses * metadata * names *
     phoneNumbers
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * emailAddresses
       * * metadata * names * phoneNumbers
       */
      public Search setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the People collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code PeopleService people = new PeopleService(...);}
   *   {@code PeopleService.People.List request = people.people().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public People people() {
    return new People();
  }

  /**
   * The "people" collection of methods.
   */
  public class People {

    /**
     * Create a batch of new contacts and return the PersonResponses for the newly created contacts.
     * Limited to 10 parallel requests per user.
     *
     * Create a request for the method "people.batchCreateContacts".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link BatchCreateContacts#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.people.v1.model.BatchCreateContactsRequest}
     * @return the request
     */
    public BatchCreateContacts batchCreateContacts(com.google.api.services.people.v1.model.BatchCreateContactsRequest content) throws java.io.IOException {
      BatchCreateContacts result = new BatchCreateContacts(content);
      initialize(result);
      return result;
    }

    public class BatchCreateContacts extends PeopleServiceRequest<com.google.api.services.people.v1.model.BatchCreateContactsResponse> {

      private static final String REST_PATH = "v1/people:batchCreateContacts";

      /**
       * Create a batch of new contacts and return the PersonResponses for the newly created contacts.
       * Limited to 10 parallel requests per user.
       *
       * Create a request for the method "people.batchCreateContacts".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link BatchCreateContacts#execute()} method to invoke the remote
       * operation. <p> {@link BatchCreateContacts#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.people.v1.model.BatchCreateContactsRequest}
       * @since 1.13
       */
      protected BatchCreateContacts(com.google.api.services.people.v1.model.BatchCreateContactsRequest content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.BatchCreateContactsResponse.class);
      }

      @Override
      public BatchCreateContacts set$Xgafv(java.lang.String $Xgafv) {
        return (BatchCreateContacts) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchCreateContacts setAccessToken(java.lang.String accessToken) {
        return (BatchCreateContacts) super.setAccessToken(accessToken);
      }

      @Override
      public BatchCreateContacts setAlt(java.lang.String alt) {
        return (BatchCreateContacts) super.setAlt(alt);
      }

      @Override
      public BatchCreateContacts setCallback(java.lang.String callback) {
        return (BatchCreateContacts) super.setCallback(callback);
      }

      @Override
      public BatchCreateContacts setFields(java.lang.String fields) {
        return (BatchCreateContacts) super.setFields(fields);
      }

      @Override
      public BatchCreateContacts setKey(java.lang.String key) {
        return (BatchCreateContacts) super.setKey(key);
      }

      @Override
      public BatchCreateContacts setOauthToken(java.lang.String oauthToken) {
        return (BatchCreateContacts) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchCreateContacts setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchCreateContacts) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchCreateContacts setQuotaUser(java.lang.String quotaUser) {
        return (BatchCreateContacts) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchCreateContacts setUploadType(java.lang.String uploadType) {
        return (BatchCreateContacts) super.setUploadType(uploadType);
      }

      @Override
      public BatchCreateContacts setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchCreateContacts) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public BatchCreateContacts set(String parameterName, Object value) {
        return (BatchCreateContacts) super.set(parameterName, value);
      }
    }
    /**
     * Delete a batch of contacts. Any non-contact data will not be deleted. Limited to 10 parallel
     * requests per user.
     *
     * Create a request for the method "people.batchDeleteContacts".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link BatchDeleteContacts#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.people.v1.model.BatchDeleteContactsRequest}
     * @return the request
     */
    public BatchDeleteContacts batchDeleteContacts(com.google.api.services.people.v1.model.BatchDeleteContactsRequest content) throws java.io.IOException {
      BatchDeleteContacts result = new BatchDeleteContacts(content);
      initialize(result);
      return result;
    }

    public class BatchDeleteContacts extends PeopleServiceRequest<com.google.api.services.people.v1.model.Empty> {

      private static final String REST_PATH = "v1/people:batchDeleteContacts";

      /**
       * Delete a batch of contacts. Any non-contact data will not be deleted. Limited to 10 parallel
       * requests per user.
       *
       * Create a request for the method "people.batchDeleteContacts".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link BatchDeleteContacts#execute()} method to invoke the remote
       * operation. <p> {@link BatchDeleteContacts#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.people.v1.model.BatchDeleteContactsRequest}
       * @since 1.13
       */
      protected BatchDeleteContacts(com.google.api.services.people.v1.model.BatchDeleteContactsRequest content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.Empty.class);
      }

      @Override
      public BatchDeleteContacts set$Xgafv(java.lang.String $Xgafv) {
        return (BatchDeleteContacts) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchDeleteContacts setAccessToken(java.lang.String accessToken) {
        return (BatchDeleteContacts) super.setAccessToken(accessToken);
      }

      @Override
      public BatchDeleteContacts setAlt(java.lang.String alt) {
        return (BatchDeleteContacts) super.setAlt(alt);
      }

      @Override
      public BatchDeleteContacts setCallback(java.lang.String callback) {
        return (BatchDeleteContacts) super.setCallback(callback);
      }

      @Override
      public BatchDeleteContacts setFields(java.lang.String fields) {
        return (BatchDeleteContacts) super.setFields(fields);
      }

      @Override
      public BatchDeleteContacts setKey(java.lang.String key) {
        return (BatchDeleteContacts) super.setKey(key);
      }

      @Override
      public BatchDeleteContacts setOauthToken(java.lang.String oauthToken) {
        return (BatchDeleteContacts) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchDeleteContacts setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchDeleteContacts) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchDeleteContacts setQuotaUser(java.lang.String quotaUser) {
        return (BatchDeleteContacts) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchDeleteContacts setUploadType(java.lang.String uploadType) {
        return (BatchDeleteContacts) super.setUploadType(uploadType);
      }

      @Override
      public BatchDeleteContacts setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchDeleteContacts) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public BatchDeleteContacts set(String parameterName, Object value) {
        return (BatchDeleteContacts) super.set(parameterName, value);
      }
    }
    /**
     * Update a batch of contacts and return a map of resource names to PersonResponses for the updated
     * contacts. Limited to 10 parallel requests per user.
     *
     * Create a request for the method "people.batchUpdateContacts".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link BatchUpdateContacts#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.people.v1.model.BatchUpdateContactsRequest}
     * @return the request
     */
    public BatchUpdateContacts batchUpdateContacts(com.google.api.services.people.v1.model.BatchUpdateContactsRequest content) throws java.io.IOException {
      BatchUpdateContacts result = new BatchUpdateContacts(content);
      initialize(result);
      return result;
    }

    public class BatchUpdateContacts extends PeopleServiceRequest<com.google.api.services.people.v1.model.BatchUpdateContactsResponse> {

      private static final String REST_PATH = "v1/people:batchUpdateContacts";

      /**
       * Update a batch of contacts and return a map of resource names to PersonResponses for the
       * updated contacts. Limited to 10 parallel requests per user.
       *
       * Create a request for the method "people.batchUpdateContacts".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link BatchUpdateContacts#execute()} method to invoke the remote
       * operation. <p> {@link BatchUpdateContacts#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.people.v1.model.BatchUpdateContactsRequest}
       * @since 1.13
       */
      protected BatchUpdateContacts(com.google.api.services.people.v1.model.BatchUpdateContactsRequest content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.BatchUpdateContactsResponse.class);
      }

      @Override
      public BatchUpdateContacts set$Xgafv(java.lang.String $Xgafv) {
        return (BatchUpdateContacts) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchUpdateContacts setAccessToken(java.lang.String accessToken) {
        return (BatchUpdateContacts) super.setAccessToken(accessToken);
      }

      @Override
      public BatchUpdateContacts setAlt(java.lang.String alt) {
        return (BatchUpdateContacts) super.setAlt(alt);
      }

      @Override
      public BatchUpdateContacts setCallback(java.lang.String callback) {
        return (BatchUpdateContacts) super.setCallback(callback);
      }

      @Override
      public BatchUpdateContacts setFields(java.lang.String fields) {
        return (BatchUpdateContacts) super.setFields(fields);
      }

      @Override
      public BatchUpdateContacts setKey(java.lang.String key) {
        return (BatchUpdateContacts) super.setKey(key);
      }

      @Override
      public BatchUpdateContacts setOauthToken(java.lang.String oauthToken) {
        return (BatchUpdateContacts) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchUpdateContacts setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchUpdateContacts) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchUpdateContacts setQuotaUser(java.lang.String quotaUser) {
        return (BatchUpdateContacts) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchUpdateContacts setUploadType(java.lang.String uploadType) {
        return (BatchUpdateContacts) super.setUploadType(uploadType);
      }

      @Override
      public BatchUpdateContacts setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchUpdateContacts) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public BatchUpdateContacts set(String parameterName, Object value) {
        return (BatchUpdateContacts) super.set(parameterName, value);
      }
    }
    /**
     * Create a new contact and return the person resource for that contact. The request returns a 400
     * error if more than one field is specified on a field that is a singleton for contact sources: *
     * biographies * birthdays * genders * names
     *
     * Create a request for the method "people.createContact".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link CreateContact#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.people.v1.model.Person}
     * @return the request
     */
    public CreateContact createContact(com.google.api.services.people.v1.model.Person content) throws java.io.IOException {
      CreateContact result = new CreateContact(content);
      initialize(result);
      return result;
    }

    public class CreateContact extends PeopleServiceRequest<com.google.api.services.people.v1.model.Person> {

      private static final String REST_PATH = "v1/people:createContact";

      /**
       * Create a new contact and return the person resource for that contact. The request returns a 400
       * error if more than one field is specified on a field that is a singleton for contact sources: *
       * biographies * birthdays * genders * names
       *
       * Create a request for the method "people.createContact".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link CreateContact#execute()} method to invoke the remote operation. <p>
       * {@link CreateContact#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param content the {@link com.google.api.services.people.v1.model.Person}
       * @since 1.13
       */
      protected CreateContact(com.google.api.services.people.v1.model.Person content) {
        super(PeopleService.this, "POST", REST_PATH, content, com.google.api.services.people.v1.model.Person.class);
      }

      @Override
      public CreateContact set$Xgafv(java.lang.String $Xgafv) {
        return (CreateContact) super.set$Xgafv($Xgafv);
      }

      @Override
      public CreateContact setAccessToken(java.lang.String accessToken) {
        return (CreateContact) super.setAccessToken(accessToken);
      }

      @Override
      public CreateContact setAlt(java.lang.String alt) {
        return (CreateContact) super.setAlt(alt);
      }

      @Override
      public CreateContact setCallback(java.lang.String callback) {
        return (CreateContact) super.setCallback(callback);
      }

      @Override
      public CreateContact setFields(java.lang.String fields) {
        return (CreateContact) super.setFields(fields);
      }

      @Override
      public CreateContact setKey(java.lang.String key) {
        return (CreateContact) super.setKey(key);
      }

      @Override
      public CreateContact setOauthToken(java.lang.String oauthToken) {
        return (CreateContact) super.setOauthToken(oauthToken);
      }

      @Override
      public CreateContact setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (CreateContact) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public CreateContact setQuotaUser(java.lang.String quotaUser) {
        return (CreateContact) super.setQuotaUser(quotaUser);
      }

      @Override
      public CreateContact setUploadType(java.lang.String uploadType) {
        return (CreateContact) super.setUploadType(uploadType);
      }

      @Override
      public CreateContact setUploadProtocol(java.lang.String uploadProtocol) {
        return (CreateContact) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Defaults to all fields if not set.
       * Valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String personFields;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Defaults to all fields if not set. Valid values are: *
     addresses * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
     emailAddresses * events * externalIds * genders * imClients * interests * locales * locations *
     memberships * metadata * miscKeywords * names * nicknames * occupations * organizations *
     phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
       */
      public String getPersonFields() {
        return personFields;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Defaults to all fields if not set.
       * Valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      public CreateContact setPersonFields(String personFields) {
        this.personFields = personFields;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
     READ_SOURCE_TYPE_PROFILE if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      public CreateContact setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public CreateContact set(String parameterName, Object value) {
        return (CreateContact) super.set(parameterName, value);
      }
    }
    /**
     * Delete a contact person. Any non-contact data will not be deleted.
     *
     * Create a request for the method "people.deleteContact".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link DeleteContact#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. The resource name of the contact to delete.
     * @return the request
     */
    public DeleteContact deleteContact(java.lang.String resourceName) throws java.io.IOException {
      DeleteContact result = new DeleteContact(resourceName);
      initialize(result);
      return result;
    }

    public class DeleteContact extends PeopleServiceRequest<com.google.api.services.people.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+resourceName}:deleteContact";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^people/[^/]+$");

      /**
       * Delete a contact person. Any non-contact data will not be deleted.
       *
       * Create a request for the method "people.deleteContact".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link DeleteContact#execute()} method to invoke the remote operation. <p>
       * {@link DeleteContact#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param resourceName Required. The resource name of the contact to delete.
       * @since 1.13
       */
      protected DeleteContact(java.lang.String resourceName) {
        super(PeopleService.this, "DELETE", REST_PATH, null, com.google.api.services.people.v1.model.Empty.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
      }

      @Override
      public DeleteContact set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteContact) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteContact setAccessToken(java.lang.String accessToken) {
        return (DeleteContact) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteContact setAlt(java.lang.String alt) {
        return (DeleteContact) super.setAlt(alt);
      }

      @Override
      public DeleteContact setCallback(java.lang.String callback) {
        return (DeleteContact) super.setCallback(callback);
      }

      @Override
      public DeleteContact setFields(java.lang.String fields) {
        return (DeleteContact) super.setFields(fields);
      }

      @Override
      public DeleteContact setKey(java.lang.String key) {
        return (DeleteContact) super.setKey(key);
      }

      @Override
      public DeleteContact setOauthToken(java.lang.String oauthToken) {
        return (DeleteContact) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteContact setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteContact) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteContact setQuotaUser(java.lang.String quotaUser) {
        return (DeleteContact) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteContact setUploadType(java.lang.String uploadType) {
        return (DeleteContact) super.setUploadType(uploadType);
      }

      @Override
      public DeleteContact setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteContact) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The resource name of the contact to delete. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the contact to delete.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. The resource name of the contact to delete. */
      public DeleteContact setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public DeleteContact set(String parameterName, Object value) {
        return (DeleteContact) super.set(parameterName, value);
      }
    }
    /**
     * Delete a contact's photo.
     *
     * Create a request for the method "people.deleteContactPhoto".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link DeleteContactPhoto#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. The resource name of the contact whose photo will be deleted.
     * @return the request
     */
    public DeleteContactPhoto deleteContactPhoto(java.lang.String resourceName) throws java.io.IOException {
      DeleteContactPhoto result = new DeleteContactPhoto(resourceName);
      initialize(result);
      return result;
    }

    public class DeleteContactPhoto extends PeopleServiceRequest<com.google.api.services.people.v1.model.DeleteContactPhotoResponse> {

      private static final String REST_PATH = "v1/{+resourceName}:deleteContactPhoto";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^people/[^/]+$");

      /**
       * Delete a contact's photo.
       *
       * Create a request for the method "people.deleteContactPhoto".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link DeleteContactPhoto#execute()} method to invoke the remote
       * operation. <p> {@link DeleteContactPhoto#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resourceName Required. The resource name of the contact whose photo will be deleted.
       * @since 1.13
       */
      protected DeleteContactPhoto(java.lang.String resourceName) {
        super(PeopleService.this, "DELETE", REST_PATH, null, com.google.api.services.people.v1.model.DeleteContactPhotoResponse.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
      }

      @Override
      public DeleteContactPhoto set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteContactPhoto) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteContactPhoto setAccessToken(java.lang.String accessToken) {
        return (DeleteContactPhoto) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteContactPhoto setAlt(java.lang.String alt) {
        return (DeleteContactPhoto) super.setAlt(alt);
      }

      @Override
      public DeleteContactPhoto setCallback(java.lang.String callback) {
        return (DeleteContactPhoto) super.setCallback(callback);
      }

      @Override
      public DeleteContactPhoto setFields(java.lang.String fields) {
        return (DeleteContactPhoto) super.setFields(fields);
      }

      @Override
      public DeleteContactPhoto setKey(java.lang.String key) {
        return (DeleteContactPhoto) super.setKey(key);
      }

      @Override
      public DeleteContactPhoto setOauthToken(java.lang.String oauthToken) {
        return (DeleteContactPhoto) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteContactPhoto setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteContactPhoto) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteContactPhoto setQuotaUser(java.lang.String quotaUser) {
        return (DeleteContactPhoto) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteContactPhoto setUploadType(java.lang.String uploadType) {
        return (DeleteContactPhoto) super.setUploadType(uploadType);
      }

      @Override
      public DeleteContactPhoto setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteContactPhoto) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The resource name of the contact whose photo will be deleted. */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the contact whose photo will be deleted.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. The resource name of the contact whose photo will be deleted. */
      public DeleteContactPhoto setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      /**
       * Optional. A field mask to restrict which fields on the person are returned. Multiple fields
       * can be specified by separating them with commas. Defaults to empty if not set, which will
       * skip the post mutate get. Valid values are: * addresses * ageRanges * biographies *
       * birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds
       * * genders * imClients * interests * locales * locations * memberships * metadata *
       * miscKeywords * names * nicknames * occupations * organizations * phoneNumbers * photos *
       * relations * sipAddresses * skills * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String personFields;

      /** Optional. A field mask to restrict which fields on the person are returned. Multiple fields can be
     specified by separating them with commas. Defaults to empty if not set, which will skip the post
     mutate get. Valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
     clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients * interests
     * locales * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
     organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
       */
      public String getPersonFields() {
        return personFields;
      }

      /**
       * Optional. A field mask to restrict which fields on the person are returned. Multiple fields
       * can be specified by separating them with commas. Defaults to empty if not set, which will
       * skip the post mutate get. Valid values are: * addresses * ageRanges * biographies *
       * birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds
       * * genders * imClients * interests * locales * locations * memberships * metadata *
       * miscKeywords * names * nicknames * occupations * organizations * phoneNumbers * photos *
       * relations * sipAddresses * skills * urls * userDefined
       */
      public DeleteContactPhoto setPersonFields(String personFields) {
        this.personFields = personFields;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
     READ_SOURCE_TYPE_PROFILE if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      public DeleteContactPhoto setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public DeleteContactPhoto set(String parameterName, Object value) {
        return (DeleteContactPhoto) super.set(parameterName, value);
      }
    }
    /**
     * Provides information about a person by specifying a resource name. Use `people/me` to indicate
     * the authenticated user. The request returns a 400 error if 'personFields' is not specified.
     *
     * Create a request for the method "people.get".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. The resource name of the person to provide information about. - To get information about
     *        the authenticated user, specify `people/me`. - To get information about a google account,
     *        specify `people/{account_id}`. - To get information about a contact, specify the resource
     *        name that identifies the contact as returned by `people.connections.list`.
     * @return the request
     */
    public Get get(java.lang.String resourceName) throws java.io.IOException {
      Get result = new Get(resourceName);
      initialize(result);
      return result;
    }

    public class Get extends PeopleServiceRequest<com.google.api.services.people.v1.model.Person> {

      private static final String REST_PATH = "v1/{+resourceName}";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^people/[^/]+$");

      /**
       * Provides information about a person by specifying a resource name. Use `people/me` to indicate
       * the authenticated user. The request returns a 400 error if 'personFields' is not specified.
       *
       * Create a request for the method "people.get".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param resourceName Required. The resource name of the person to provide information about. - To get information about
     *        the authenticated user, specify `people/me`. - To get information about a google account,
     *        specify `people/{account_id}`. - To get information about a contact, specify the resource
     *        name that identifies the contact as returned by `people.connections.list`.
       * @since 1.13
       */
      protected Get(java.lang.String resourceName) {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.Person.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. The resource name of the person to provide information about. - To get
       * information about the authenticated user, specify `people/me`. - To get information about a
       * google account, specify `people/{account_id}`. - To get information about a contact,
       * specify the resource name that identifies the contact as returned by
       * `people.connections.list`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. The resource name of the person to provide information about. - To get information about
     the authenticated user, specify `people/me`. - To get information about a google account, specify
     `people/{account_id}`. - To get information about a contact, specify the resource name that
     identifies the contact as returned by `people.connections.list`.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /**
       * Required. The resource name of the person to provide information about. - To get
       * information about the authenticated user, specify `people/me`. - To get information about a
       * google account, specify `people/{account_id}`. - To get information about a contact,
       * specify the resource name that identifies the contact as returned by
       * `people.connections.list`.
       */
      public Get setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on the person are returned. Multiple fields
       * can be specified by separating them with commas. Valid values are: * addresses * ageRanges
       * * biographies * birthdays * calendarUrls * clientData * coverPhotos * emailAddresses *
       * events * externalIds * genders * imClients * interests * locales * locations * memberships
       * * metadata * miscKeywords * names * nicknames * occupations * organizations * phoneNumbers
       * * photos * relations * sipAddresses * skills * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String personFields;

      /** Required. A field mask to restrict which fields on the person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
     birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
     genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
     * skills * urls * userDefined
       */
      public String getPersonFields() {
        return personFields;
      }

      /**
       * Required. A field mask to restrict which fields on the person are returned. Multiple fields
       * can be specified by separating them with commas. Valid values are: * addresses * ageRanges
       * * biographies * birthdays * calendarUrls * clientData * coverPhotos * emailAddresses *
       * events * externalIds * genders * imClients * interests * locales * locations * memberships
       * * metadata * miscKeywords * names * nicknames * occupations * organizations * phoneNumbers
       * * photos * relations * sipAddresses * skills * urls * userDefined
       */
      public Get setPersonFields(String personFields) {
        this.personFields = personFields;
        return this;
      }

      /**
       * Required. Comma-separated list of person fields to be included in the response. Each path
       * should start with `person.`: for example, `person.names` or `person.photos`.
       */
      @com.google.api.client.util.Key("requestMask.includeField")
      private String requestMaskIncludeField;

      /** Required. Comma-separated list of person fields to be included in the response. Each path should
     start with `person.`: for example, `person.names` or `person.photos`.
       */
      public String getRequestMaskIncludeField() {
        return requestMaskIncludeField;
      }

      /**
       * Required. Comma-separated list of person fields to be included in the response. Each path
       * should start with `person.`: for example, `person.names` or `person.photos`.
       */
      public Get setRequestMaskIncludeField(String requestMaskIncludeField) {
        this.requestMaskIncludeField = requestMaskIncludeField;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_PROFILE and
       * READ_SOURCE_TYPE_CONTACT if not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_PROFILE and
     READ_SOURCE_TYPE_CONTACT if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_PROFILE and
       * READ_SOURCE_TYPE_CONTACT if not set.
       */
      public Get setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Provides information about a list of specific people by specifying a list of requested resource
     * names. Use `people/me` to indicate the authenticated user. The request returns a 400 error if
     * 'personFields' is not specified.
     *
     * Create a request for the method "people.getBatchGet".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link GetBatchGet#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public GetBatchGet getBatchGet() throws java.io.IOException {
      GetBatchGet result = new GetBatchGet();
      initialize(result);
      return result;
    }

    public class GetBatchGet extends PeopleServiceRequest<com.google.api.services.people.v1.model.GetPeopleResponse> {

      private static final String REST_PATH = "v1/people:batchGet";

      /**
       * Provides information about a list of specific people by specifying a list of requested resource
       * names. Use `people/me` to indicate the authenticated user. The request returns a 400 error if
       * 'personFields' is not specified.
       *
       * Create a request for the method "people.getBatchGet".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link GetBatchGet#execute()} method to invoke the remote operation. <p>
       * {@link
       * GetBatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected GetBatchGet() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.GetPeopleResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetBatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (GetBatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetBatchGet setAccessToken(java.lang.String accessToken) {
        return (GetBatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public GetBatchGet setAlt(java.lang.String alt) {
        return (GetBatchGet) super.setAlt(alt);
      }

      @Override
      public GetBatchGet setCallback(java.lang.String callback) {
        return (GetBatchGet) super.setCallback(callback);
      }

      @Override
      public GetBatchGet setFields(java.lang.String fields) {
        return (GetBatchGet) super.setFields(fields);
      }

      @Override
      public GetBatchGet setKey(java.lang.String key) {
        return (GetBatchGet) super.setKey(key);
      }

      @Override
      public GetBatchGet setOauthToken(java.lang.String oauthToken) {
        return (GetBatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public GetBatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetBatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetBatchGet setQuotaUser(java.lang.String quotaUser) {
        return (GetBatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetBatchGet setUploadType(java.lang.String uploadType) {
        return (GetBatchGet) super.setUploadType(uploadType);
      }

      @Override
      public GetBatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetBatchGet) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      @com.google.api.client.util.Key
      private String personFields;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
     birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
     genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
     * skills * urls * userDefined
       */
      public String getPersonFields() {
        return personFields;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      public GetBatchGet setPersonFields(String personFields) {
        this.personFields = personFields;
        return this;
      }

      /**
       * Required. Comma-separated list of person fields to be included in the response. Each path
       * should start with `person.`: for example, `person.names` or `person.photos`.
       */
      @com.google.api.client.util.Key("requestMask.includeField")
      private String requestMaskIncludeField;

      /** Required. Comma-separated list of person fields to be included in the response. Each path should
     start with `person.`: for example, `person.names` or `person.photos`.
       */
      public String getRequestMaskIncludeField() {
        return requestMaskIncludeField;
      }

      /**
       * Required. Comma-separated list of person fields to be included in the response. Each path
       * should start with `person.`: for example, `person.names` or `person.photos`.
       */
      public GetBatchGet setRequestMaskIncludeField(String requestMaskIncludeField) {
        this.requestMaskIncludeField = requestMaskIncludeField;
        return this;
      }

      /**
       * Required. The resource names of the people to provide information about. It's repeatable.
       * The URL query parameter should be resourceNames==&... - To get information about the
       * authenticated user, specify `people/me`. - To get information about a google account,
       * specify `people/{account_id}`. - To get information about a contact, specify the resource
       * name that identifies the contact as returned by `people.connections.list`. There is a
       * maximum of 200 resource names.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> resourceNames;

      /** Required. The resource names of the people to provide information about. It's repeatable. The URL
     query parameter should be resourceNames==&... - To get information about the authenticated user,
     specify `people/me`. - To get information about a google account, specify `people/{account_id}`. -
     To get information about a contact, specify the resource name that identifies the contact as
     returned by `people.connections.list`. There is a maximum of 200 resource names.
       */
      public java.util.List<java.lang.String> getResourceNames() {
        return resourceNames;
      }

      /**
       * Required. The resource names of the people to provide information about. It's repeatable.
       * The URL query parameter should be resourceNames==&... - To get information about the
       * authenticated user, specify `people/me`. - To get information about a google account,
       * specify `people/{account_id}`. - To get information about a contact, specify the resource
       * name that identifies the contact as returned by `people.connections.list`. There is a
       * maximum of 200 resource names.
       */
      public GetBatchGet setResourceNames(java.util.List<java.lang.String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
     READ_SOURCE_TYPE_PROFILE if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      public GetBatchGet setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public GetBatchGet set(String parameterName, Object value) {
        return (GetBatchGet) super.set(parameterName, value);
      }
    }
    /**
     * Provides a list of domain profiles and domain contacts in the authenticated user's domain
     * directory. When the `sync_token` is specified, resources deleted since the last sync will be
     * returned as a person with `PersonMetadata.deleted` set to true. When the `page_token` or
     * `sync_token` is specified, all other request parameters must match the first call. Writes may
     * have a propagation delay of several minutes for sync requests. Incremental syncs are not intended
     * for read-after-write use cases. See example usage at [List the directory people that have
     * changed](/people/v1/directory#list_the_directory_people_that_have_changed).
     *
     * Create a request for the method "people.listDirectoryPeople".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link ListDirectoryPeople#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public ListDirectoryPeople listDirectoryPeople() throws java.io.IOException {
      ListDirectoryPeople result = new ListDirectoryPeople();
      initialize(result);
      return result;
    }

    public class ListDirectoryPeople extends PeopleServiceRequest<com.google.api.services.people.v1.model.ListDirectoryPeopleResponse> {

      private static final String REST_PATH = "v1/people:listDirectoryPeople";

      /**
       * Provides a list of domain profiles and domain contacts in the authenticated user's domain
       * directory. When the `sync_token` is specified, resources deleted since the last sync will be
       * returned as a person with `PersonMetadata.deleted` set to true. When the `page_token` or
       * `sync_token` is specified, all other request parameters must match the first call. Writes may
       * have a propagation delay of several minutes for sync requests. Incremental syncs are not
       * intended for read-after-write use cases. See example usage at [List the directory people that
       * have changed](/people/v1/directory#list_the_directory_people_that_have_changed).
       *
       * Create a request for the method "people.listDirectoryPeople".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link ListDirectoryPeople#execute()} method to invoke the remote
       * operation. <p> {@link ListDirectoryPeople#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected ListDirectoryPeople() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.ListDirectoryPeopleResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListDirectoryPeople set$Xgafv(java.lang.String $Xgafv) {
        return (ListDirectoryPeople) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListDirectoryPeople setAccessToken(java.lang.String accessToken) {
        return (ListDirectoryPeople) super.setAccessToken(accessToken);
      }

      @Override
      public ListDirectoryPeople setAlt(java.lang.String alt) {
        return (ListDirectoryPeople) super.setAlt(alt);
      }

      @Override
      public ListDirectoryPeople setCallback(java.lang.String callback) {
        return (ListDirectoryPeople) super.setCallback(callback);
      }

      @Override
      public ListDirectoryPeople setFields(java.lang.String fields) {
        return (ListDirectoryPeople) super.setFields(fields);
      }

      @Override
      public ListDirectoryPeople setKey(java.lang.String key) {
        return (ListDirectoryPeople) super.setKey(key);
      }

      @Override
      public ListDirectoryPeople setOauthToken(java.lang.String oauthToken) {
        return (ListDirectoryPeople) super.setOauthToken(oauthToken);
      }

      @Override
      public ListDirectoryPeople setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListDirectoryPeople) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListDirectoryPeople setQuotaUser(java.lang.String quotaUser) {
        return (ListDirectoryPeople) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListDirectoryPeople setUploadType(java.lang.String uploadType) {
        return (ListDirectoryPeople) super.setUploadType(uploadType);
      }

      @Override
      public ListDirectoryPeople setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListDirectoryPeople) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. Additional data to merge into the directory sources if they are connected through
       * verified join keys such as email addresses or phone numbers.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> mergeSources;

      /** Optional. Additional data to merge into the directory sources if they are connected through
     verified join keys such as email addresses or phone numbers.
       */
      public java.util.List<java.lang.String> getMergeSources() {
        return mergeSources;
      }

      /**
       * Optional. Additional data to merge into the directory sources if they are connected through
       * verified join keys such as email addresses or phone numbers.
       */
      public ListDirectoryPeople setMergeSources(java.util.List<java.lang.String> mergeSources) {
        this.mergeSources = mergeSources;
        return this;
      }

      /**
       * Optional. The number of people to include in the response. Valid values are between 1 and
       * 1000, inclusive. Defaults to 100 if not set or set to 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of people to include in the response. Valid values are between 1 and 1000,
     inclusive. Defaults to 100 if not set or set to 0.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The number of people to include in the response. Valid values are between 1 and
       * 1000, inclusive. Defaults to 100 if not set or set to 0.
       */
      public ListDirectoryPeople setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `people.listDirectoryPeople` must match the first call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A page token, received from a previous response `next_page_token`. Provide this to
     retrieve the subsequent page. When paginating, all other parameters provided to
     `people.listDirectoryPeople` must match the first call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `people.listDirectoryPeople` must match the first call that provided the page token.
       */
      public ListDirectoryPeople setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
     birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
     genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
     * skills * urls * userDefined
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      public ListDirectoryPeople setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      /**
       * Optional. Whether the response should return `next_sync_token`. It can be used to get
       * incremental changes since the last request by setting it on the request `sync_token`. More
       * details about sync behavior at `people.listDirectoryPeople`.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean requestSyncToken;

      /** Optional. Whether the response should return `next_sync_token`. It can be used to get incremental
     changes since the last request by setting it on the request `sync_token`. More details about sync
     behavior at `people.listDirectoryPeople`.
       */
      public java.lang.Boolean getRequestSyncToken() {
        return requestSyncToken;
      }

      /**
       * Optional. Whether the response should return `next_sync_token`. It can be used to get
       * incremental changes since the last request by setting it on the request `sync_token`. More
       * details about sync behavior at `people.listDirectoryPeople`.
       */
      public ListDirectoryPeople setRequestSyncToken(java.lang.Boolean requestSyncToken) {
        this.requestSyncToken = requestSyncToken;
        return this;
      }

      /** Required. Directory sources to return. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Required. Directory sources to return.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /** Required. Directory sources to return. */
      public ListDirectoryPeople setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      /**
       * Optional. A sync token, received from a previous response `next_sync_token` Provide this to
       * retrieve only the resources changed since the last request. When syncing, all other
       * parameters provided to `people.listDirectoryPeople` must match the first call that provided
       * the sync token. More details about sync behavior at `people.listDirectoryPeople`.
       */
      @com.google.api.client.util.Key
      private java.lang.String syncToken;

      /** Optional. A sync token, received from a previous response `next_sync_token` Provide this to
     retrieve only the resources changed since the last request. When syncing, all other parameters
     provided to `people.listDirectoryPeople` must match the first call that provided the sync token.
     More details about sync behavior at `people.listDirectoryPeople`.
       */
      public java.lang.String getSyncToken() {
        return syncToken;
      }

      /**
       * Optional. A sync token, received from a previous response `next_sync_token` Provide this to
       * retrieve only the resources changed since the last request. When syncing, all other
       * parameters provided to `people.listDirectoryPeople` must match the first call that provided
       * the sync token. More details about sync behavior at `people.listDirectoryPeople`.
       */
      public ListDirectoryPeople setSyncToken(java.lang.String syncToken) {
        this.syncToken = syncToken;
        return this;
      }

      @Override
      public ListDirectoryPeople set(String parameterName, Object value) {
        return (ListDirectoryPeople) super.set(parameterName, value);
      }
    }
    /**
     * Provides a list of contacts in the authenticated user's grouped contacts that matches the search
     * query. The query matches on a contact's `names`, `nickNames`, `emailAddresses`, `phoneNumbers`,
     * and `organizations` fields that are from the CONTACT source. **IMPORTANT**: Before searching,
     * clients should send a warmup request with an empty query to update the cache. See
     * https://developers.google.com/people/v1/contacts#search_the_users_contacts
     *
     * Create a request for the method "people.searchContacts".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link SearchContacts#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public SearchContacts searchContacts() throws java.io.IOException {
      SearchContacts result = new SearchContacts();
      initialize(result);
      return result;
    }

    public class SearchContacts extends PeopleServiceRequest<com.google.api.services.people.v1.model.SearchResponse> {

      private static final String REST_PATH = "v1/people:searchContacts";

      /**
       * Provides a list of contacts in the authenticated user's grouped contacts that matches the
       * search query. The query matches on a contact's `names`, `nickNames`, `emailAddresses`,
       * `phoneNumbers`, and `organizations` fields that are from the CONTACT source. **IMPORTANT**:
       * Before searching, clients should send a warmup request with an empty query to update the cache.
       * See https://developers.google.com/people/v1/contacts#search_the_users_contacts
       *
       * Create a request for the method "people.searchContacts".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link SearchContacts#execute()} method to invoke the remote operation.
       * <p> {@link SearchContacts#initialize(com.google.api.client.googleapis.services.AbstractGoogleCl
       * ientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @since 1.13
       */
      protected SearchContacts() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.SearchResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public SearchContacts set$Xgafv(java.lang.String $Xgafv) {
        return (SearchContacts) super.set$Xgafv($Xgafv);
      }

      @Override
      public SearchContacts setAccessToken(java.lang.String accessToken) {
        return (SearchContacts) super.setAccessToken(accessToken);
      }

      @Override
      public SearchContacts setAlt(java.lang.String alt) {
        return (SearchContacts) super.setAlt(alt);
      }

      @Override
      public SearchContacts setCallback(java.lang.String callback) {
        return (SearchContacts) super.setCallback(callback);
      }

      @Override
      public SearchContacts setFields(java.lang.String fields) {
        return (SearchContacts) super.setFields(fields);
      }

      @Override
      public SearchContacts setKey(java.lang.String key) {
        return (SearchContacts) super.setKey(key);
      }

      @Override
      public SearchContacts setOauthToken(java.lang.String oauthToken) {
        return (SearchContacts) super.setOauthToken(oauthToken);
      }

      @Override
      public SearchContacts setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SearchContacts) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SearchContacts setQuotaUser(java.lang.String quotaUser) {
        return (SearchContacts) super.setQuotaUser(quotaUser);
      }

      @Override
      public SearchContacts setUploadType(java.lang.String uploadType) {
        return (SearchContacts) super.setUploadType(uploadType);
      }

      @Override
      public SearchContacts setUploadProtocol(java.lang.String uploadProtocol) {
        return (SearchContacts) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0.
       * Values greater than 30 will be capped to 30.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0. Values
     greater than 30 will be capped to 30.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The number of results to return. Defaults to 10 if field is not set, or set to 0.
       * Values greater than 30 will be capped to 30.
       */
      public SearchContacts setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Required. The plain-text query for the request. The query is used to match prefix phrases
       * of the fields on a person. For example, a person with name "foo name" matches queries such
       * as "f", "fo", "foo", "foo n", "nam", etc., but not "oo n".
       */
      @com.google.api.client.util.Key
      private java.lang.String query;

      /** Required. The plain-text query for the request. The query is used to match prefix phrases of the
     fields on a person. For example, a person with name "foo name" matches queries such as "f", "fo",
     "foo", "foo n", "nam", etc., but not "oo n".
       */
      public java.lang.String getQuery() {
        return query;
      }

      /**
       * Required. The plain-text query for the request. The query is used to match prefix phrases
       * of the fields on a person. For example, a person with name "foo name" matches queries such
       * as "f", "fo", "foo", "foo n", "nam", etc., but not "oo n".
       */
      public SearchContacts setQuery(java.lang.String query) {
        this.query = query;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
     birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
     genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
     * skills * urls * userDefined
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      public SearchContacts setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if
       * not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT if
       * not set.
       */
      public SearchContacts setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public SearchContacts set(String parameterName, Object value) {
        return (SearchContacts) super.set(parameterName, value);
      }
    }
    /**
     * Provides a list of domain profiles and domain contacts in the authenticated user's domain
     * directory that match the search query.
     *
     * Create a request for the method "people.searchDirectoryPeople".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link SearchDirectoryPeople#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public SearchDirectoryPeople searchDirectoryPeople() throws java.io.IOException {
      SearchDirectoryPeople result = new SearchDirectoryPeople();
      initialize(result);
      return result;
    }

    public class SearchDirectoryPeople extends PeopleServiceRequest<com.google.api.services.people.v1.model.SearchDirectoryPeopleResponse> {

      private static final String REST_PATH = "v1/people:searchDirectoryPeople";

      /**
       * Provides a list of domain profiles and domain contacts in the authenticated user's domain
       * directory that match the search query.
       *
       * Create a request for the method "people.searchDirectoryPeople".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link SearchDirectoryPeople#execute()} method to invoke the remote
       * operation. <p> {@link SearchDirectoryPeople#initialize(com.google.api.client.googleapis.service
       * s.AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected SearchDirectoryPeople() {
        super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.SearchDirectoryPeopleResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public SearchDirectoryPeople set$Xgafv(java.lang.String $Xgafv) {
        return (SearchDirectoryPeople) super.set$Xgafv($Xgafv);
      }

      @Override
      public SearchDirectoryPeople setAccessToken(java.lang.String accessToken) {
        return (SearchDirectoryPeople) super.setAccessToken(accessToken);
      }

      @Override
      public SearchDirectoryPeople setAlt(java.lang.String alt) {
        return (SearchDirectoryPeople) super.setAlt(alt);
      }

      @Override
      public SearchDirectoryPeople setCallback(java.lang.String callback) {
        return (SearchDirectoryPeople) super.setCallback(callback);
      }

      @Override
      public SearchDirectoryPeople setFields(java.lang.String fields) {
        return (SearchDirectoryPeople) super.setFields(fields);
      }

      @Override
      public SearchDirectoryPeople setKey(java.lang.String key) {
        return (SearchDirectoryPeople) super.setKey(key);
      }

      @Override
      public SearchDirectoryPeople setOauthToken(java.lang.String oauthToken) {
        return (SearchDirectoryPeople) super.setOauthToken(oauthToken);
      }

      @Override
      public SearchDirectoryPeople setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (SearchDirectoryPeople) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public SearchDirectoryPeople setQuotaUser(java.lang.String quotaUser) {
        return (SearchDirectoryPeople) super.setQuotaUser(quotaUser);
      }

      @Override
      public SearchDirectoryPeople setUploadType(java.lang.String uploadType) {
        return (SearchDirectoryPeople) super.setUploadType(uploadType);
      }

      @Override
      public SearchDirectoryPeople setUploadProtocol(java.lang.String uploadProtocol) {
        return (SearchDirectoryPeople) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. Additional data to merge into the directory sources if they are connected through
       * verified join keys such as email addresses or phone numbers.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> mergeSources;

      /** Optional. Additional data to merge into the directory sources if they are connected through
     verified join keys such as email addresses or phone numbers.
       */
      public java.util.List<java.lang.String> getMergeSources() {
        return mergeSources;
      }

      /**
       * Optional. Additional data to merge into the directory sources if they are connected through
       * verified join keys such as email addresses or phone numbers.
       */
      public SearchDirectoryPeople setMergeSources(java.util.List<java.lang.String> mergeSources) {
        this.mergeSources = mergeSources;
        return this;
      }

      /**
       * Optional. The number of people to include in the response. Valid values are between 1 and
       * 500, inclusive. Defaults to 100 if not set or set to 0.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. The number of people to include in the response. Valid values are between 1 and 500,
     inclusive. Defaults to 100 if not set or set to 0.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. The number of people to include in the response. Valid values are between 1 and
       * 500, inclusive. Defaults to 100 if not set or set to 0.
       */
      public SearchDirectoryPeople setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `SearchDirectoryPeople` must match the first call that provided the page token.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. A page token, received from a previous response `next_page_token`. Provide this to
     retrieve the subsequent page. When paginating, all other parameters provided to
     `SearchDirectoryPeople` must match the first call that provided the page token.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. A page token, received from a previous response `next_page_token`. Provide this
       * to retrieve the subsequent page. When paginating, all other parameters provided to
       * `SearchDirectoryPeople` must match the first call that provided the page token.
       */
      public SearchDirectoryPeople setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Required. Prefix query that matches fields in the person. Does NOT use the read_mask for
       * determining what fields to match.
       */
      @com.google.api.client.util.Key
      private java.lang.String query;

      /** Required. Prefix query that matches fields in the person. Does NOT use the read_mask for
     determining what fields to match.
       */
      public java.lang.String getQuery() {
        return query;
      }

      /**
       * Required. Prefix query that matches fields in the person. Does NOT use the read_mask for
       * determining what fields to match.
       */
      public SearchDirectoryPeople setQuery(java.lang.String query) {
        this.query = query;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      @com.google.api.client.util.Key
      private String readMask;

      /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
     birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
     genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
     * skills * urls * userDefined
       */
      public String getReadMask() {
        return readMask;
      }

      /**
       * Required. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Valid values are: * addresses *
       * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
       * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
       * userDefined
       */
      public SearchDirectoryPeople setReadMask(String readMask) {
        this.readMask = readMask;
        return this;
      }

      /** Required. Directory sources to return. */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Required. Directory sources to return.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /** Required. Directory sources to return. */
      public SearchDirectoryPeople setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      @Override
      public SearchDirectoryPeople set(String parameterName, Object value) {
        return (SearchDirectoryPeople) super.set(parameterName, value);
      }
    }
    /**
     * Update contact data for an existing contact person. Any non-contact data will not be modified.
     * Any non-contact data in the person to update will be ignored. All fields specified in the
     * `update_mask` will be replaced. The server returns a 400 error if `person.metadata.sources` is
     * not specified for the contact to be updated or if there is no contact source. The server returns
     * a 400 error with reason `"failedPrecondition"` if `person.metadata.sources.etag` is different
     * than the contact's etag, which indicates the contact has changed since its data was read. Clients
     * should get the latest person and merge their updates into the latest person. The server returns a
     * 400 error if `memberships` are being updated and there are no contact group memberships specified
     * on the person. The server returns a 400 error if more than one field is specified on a field that
     * is a singleton for contact sources: * biographies * birthdays * genders * names
     *
     * Create a request for the method "people.updateContact".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link UpdateContact#execute()} method to invoke the remote operation.
     *
     * @param resourceName The resource name for the person, assigned by the server. An ASCII string with a max length of 27
     *        characters, in the form of `people/{person_id}`.
     * @param content the {@link com.google.api.services.people.v1.model.Person}
     * @return the request
     */
    public UpdateContact updateContact(java.lang.String resourceName, com.google.api.services.people.v1.model.Person content) throws java.io.IOException {
      UpdateContact result = new UpdateContact(resourceName, content);
      initialize(result);
      return result;
    }

    public class UpdateContact extends PeopleServiceRequest<com.google.api.services.people.v1.model.Person> {

      private static final String REST_PATH = "v1/{+resourceName}:updateContact";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^people/[^/]+$");

      /**
       * Update contact data for an existing contact person. Any non-contact data will not be modified.
       * Any non-contact data in the person to update will be ignored. All fields specified in the
       * `update_mask` will be replaced. The server returns a 400 error if `person.metadata.sources` is
       * not specified for the contact to be updated or if there is no contact source. The server
       * returns a 400 error with reason `"failedPrecondition"` if `person.metadata.sources.etag` is
       * different than the contact's etag, which indicates the contact has changed since its data was
       * read. Clients should get the latest person and merge their updates into the latest person. The
       * server returns a 400 error if `memberships` are being updated and there are no contact group
       * memberships specified on the person. The server returns a 400 error if more than one field is
       * specified on a field that is a singleton for contact sources: * biographies * birthdays *
       * genders * names
       *
       * Create a request for the method "people.updateContact".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link UpdateContact#execute()} method to invoke the remote operation. <p>
       * {@link UpdateContact#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientR
       * equest)} must be called to initialize this instance immediately after invoking the constructor.
       * </p>
       *
       * @param resourceName The resource name for the person, assigned by the server. An ASCII string with a max length of 27
     *        characters, in the form of `people/{person_id}`.
       * @param content the {@link com.google.api.services.people.v1.model.Person}
       * @since 1.13
       */
      protected UpdateContact(java.lang.String resourceName, com.google.api.services.people.v1.model.Person content) {
        super(PeopleService.this, "PATCH", REST_PATH, content, com.google.api.services.people.v1.model.Person.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
      }

      @Override
      public UpdateContact set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateContact) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateContact setAccessToken(java.lang.String accessToken) {
        return (UpdateContact) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateContact setAlt(java.lang.String alt) {
        return (UpdateContact) super.setAlt(alt);
      }

      @Override
      public UpdateContact setCallback(java.lang.String callback) {
        return (UpdateContact) super.setCallback(callback);
      }

      @Override
      public UpdateContact setFields(java.lang.String fields) {
        return (UpdateContact) super.setFields(fields);
      }

      @Override
      public UpdateContact setKey(java.lang.String key) {
        return (UpdateContact) super.setKey(key);
      }

      @Override
      public UpdateContact setOauthToken(java.lang.String oauthToken) {
        return (UpdateContact) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateContact setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateContact) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateContact setQuotaUser(java.lang.String quotaUser) {
        return (UpdateContact) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateContact setUploadType(java.lang.String uploadType) {
        return (UpdateContact) super.setUploadType(uploadType);
      }

      @Override
      public UpdateContact setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateContact) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The resource name for the person, assigned by the server. An ASCII string with a max length
       * of 27 characters, in the form of `people/{person_id}`.
       */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** The resource name for the person, assigned by the server. An ASCII string with a max length of 27
     characters, in the form of `people/{person_id}`.
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /**
       * The resource name for the person, assigned by the server. An ASCII string with a max length
       * of 27 characters, in the form of `people/{person_id}`.
       */
      public UpdateContact setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      /**
       * Optional. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Defaults to all fields if not set.
       * Valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String personFields;

      /** Optional. A field mask to restrict which fields on each person are returned. Multiple fields can be
     specified by separating them with commas. Defaults to all fields if not set. Valid values are: *
     addresses * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
     emailAddresses * events * externalIds * genders * imClients * interests * locales * locations *
     memberships * metadata * miscKeywords * names * nicknames * occupations * organizations *
     phoneNumbers * photos * relations * sipAddresses * skills * urls * userDefined
       */
      public String getPersonFields() {
        return personFields;
      }

      /**
       * Optional. A field mask to restrict which fields on each person are returned. Multiple
       * fields can be specified by separating them with commas. Defaults to all fields if not set.
       * Valid values are: * addresses * ageRanges * biographies * birthdays * calendarUrls *
       * clientData * coverPhotos * emailAddresses * events * externalIds * genders * imClients *
       * interests * locales * locations * memberships * metadata * miscKeywords * names * nicknames
       * * occupations * organizations * phoneNumbers * photos * relations * sipAddresses * skills *
       * urls * userDefined
       */
      public UpdateContact setPersonFields(String personFields) {
        this.personFields = personFields;
        return this;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> sources;

      /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
     READ_SOURCE_TYPE_PROFILE if not set.
       */
      public java.util.List<java.lang.String> getSources() {
        return sources;
      }

      /**
       * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       * READ_SOURCE_TYPE_PROFILE if not set.
       */
      public UpdateContact setSources(java.util.List<java.lang.String> sources) {
        this.sources = sources;
        return this;
      }

      /**
       * Required. A field mask to restrict which fields on the person are updated. Multiple fields
       * can be specified by separating them with commas. All updated fields will be replaced. Valid
       * values are: * addresses * biographies * birthdays * calendarUrls * clientData *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * miscKeywords * names * nicknames * occupations * organizations *
       * phoneNumbers * relations * sipAddresses * urls * userDefined
       */
      @com.google.api.client.util.Key
      private String updatePersonFields;

      /** Required. A field mask to restrict which fields on the person are updated. Multiple fields can be
     specified by separating them with commas. All updated fields will be replaced. Valid values are: *
     addresses * biographies * birthdays * calendarUrls * clientData * emailAddresses * events *
     externalIds * genders * imClients * interests * locales * locations * memberships * miscKeywords *
     names * nicknames * occupations * organizations * phoneNumbers * relations * sipAddresses * urls *
     userDefined
       */
      public String getUpdatePersonFields() {
        return updatePersonFields;
      }

      /**
       * Required. A field mask to restrict which fields on the person are updated. Multiple fields
       * can be specified by separating them with commas. All updated fields will be replaced. Valid
       * values are: * addresses * biographies * birthdays * calendarUrls * clientData *
       * emailAddresses * events * externalIds * genders * imClients * interests * locales *
       * locations * memberships * miscKeywords * names * nicknames * occupations * organizations *
       * phoneNumbers * relations * sipAddresses * urls * userDefined
       */
      public UpdateContact setUpdatePersonFields(String updatePersonFields) {
        this.updatePersonFields = updatePersonFields;
        return this;
      }

      @Override
      public UpdateContact set(String parameterName, Object value) {
        return (UpdateContact) super.set(parameterName, value);
      }
    }
    /**
     * Update a contact's photo.
     *
     * Create a request for the method "people.updateContactPhoto".
     *
     * This request holds the parameters needed by the people server.  After setting any optional
     * parameters, call the {@link UpdateContactPhoto#execute()} method to invoke the remote operation.
     *
     * @param resourceName Required. Person resource name
     * @param content the {@link com.google.api.services.people.v1.model.UpdateContactPhotoRequest}
     * @return the request
     */
    public UpdateContactPhoto updateContactPhoto(java.lang.String resourceName, com.google.api.services.people.v1.model.UpdateContactPhotoRequest content) throws java.io.IOException {
      UpdateContactPhoto result = new UpdateContactPhoto(resourceName, content);
      initialize(result);
      return result;
    }

    public class UpdateContactPhoto extends PeopleServiceRequest<com.google.api.services.people.v1.model.UpdateContactPhotoResponse> {

      private static final String REST_PATH = "v1/{+resourceName}:updateContactPhoto";

      private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
          java.util.regex.Pattern.compile("^people/[^/]+$");

      /**
       * Update a contact's photo.
       *
       * Create a request for the method "people.updateContactPhoto".
       *
       * This request holds the parameters needed by the the people server.  After setting any optional
       * parameters, call the {@link UpdateContactPhoto#execute()} method to invoke the remote
       * operation. <p> {@link UpdateContactPhoto#initialize(com.google.api.client.googleapis.services.A
       * bstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param resourceName Required. Person resource name
       * @param content the {@link com.google.api.services.people.v1.model.UpdateContactPhotoRequest}
       * @since 1.13
       */
      protected UpdateContactPhoto(java.lang.String resourceName, com.google.api.services.people.v1.model.UpdateContactPhotoRequest content) {
        super(PeopleService.this, "PATCH", REST_PATH, content, com.google.api.services.people.v1.model.UpdateContactPhotoResponse.class);
        this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
      }

      @Override
      public UpdateContactPhoto set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateContactPhoto) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateContactPhoto setAccessToken(java.lang.String accessToken) {
        return (UpdateContactPhoto) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateContactPhoto setAlt(java.lang.String alt) {
        return (UpdateContactPhoto) super.setAlt(alt);
      }

      @Override
      public UpdateContactPhoto setCallback(java.lang.String callback) {
        return (UpdateContactPhoto) super.setCallback(callback);
      }

      @Override
      public UpdateContactPhoto setFields(java.lang.String fields) {
        return (UpdateContactPhoto) super.setFields(fields);
      }

      @Override
      public UpdateContactPhoto setKey(java.lang.String key) {
        return (UpdateContactPhoto) super.setKey(key);
      }

      @Override
      public UpdateContactPhoto setOauthToken(java.lang.String oauthToken) {
        return (UpdateContactPhoto) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateContactPhoto setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateContactPhoto) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateContactPhoto setQuotaUser(java.lang.String quotaUser) {
        return (UpdateContactPhoto) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateContactPhoto setUploadType(java.lang.String uploadType) {
        return (UpdateContactPhoto) super.setUploadType(uploadType);
      }

      @Override
      public UpdateContactPhoto setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateContactPhoto) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. Person resource name */
      @com.google.api.client.util.Key
      private java.lang.String resourceName;

      /** Required. Person resource name
       */
      public java.lang.String getResourceName() {
        return resourceName;
      }

      /** Required. Person resource name */
      public UpdateContactPhoto setResourceName(java.lang.String resourceName) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
              "Parameter resourceName must conform to the pattern " +
              "^people/[^/]+$");
        }
        this.resourceName = resourceName;
        return this;
      }

      @Override
      public UpdateContactPhoto set(String parameterName, Object value) {
        return (UpdateContactPhoto) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Connections collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code PeopleService people = new PeopleService(...);}
     *   {@code PeopleService.Connections.List request = people.connections().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Connections connections() {
      return new Connections();
    }

    /**
     * The "connections" collection of methods.
     */
    public class Connections {

      /**
       * Provides a list of the authenticated user's contacts. Sync tokens expire 7 days after the full
       * sync. A request with an expired sync token will result in a 410 error. In the case of such an
       * error clients should make a full sync request without a `sync_token`. The first page of a full
       * sync request has an additional quota. If the quota is exceeded, a 429 error will be returned.
       * This quota is fixed and can not be increased. When the `sync_token` is specified, resources
       * deleted since the last sync will be returned as a person with `PersonMetadata.deleted` set to
       * true. When the `page_token` or `sync_token` is specified, all other request parameters must match
       * the first call. Writes may have a propagation delay of several minutes for sync requests.
       * Incremental syncs are not intended for read-after-write use cases. See example usage at [List the
       * user's contacts that have
       * changed](/people/v1/contacts#list_the_users_contacts_that_have_changed).
       *
       * Create a request for the method "connections.list".
       *
       * This request holds the parameters needed by the people server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param resourceName Required. The resource name to return connections for. Only `people/me` is valid.
       * @return the request
       */
      public List list(java.lang.String resourceName) throws java.io.IOException {
        List result = new List(resourceName);
        initialize(result);
        return result;
      }

      public class List extends PeopleServiceRequest<com.google.api.services.people.v1.model.ListConnectionsResponse> {

        private static final String REST_PATH = "v1/{+resourceName}/connections";

        private final java.util.regex.Pattern RESOURCE_NAME_PATTERN =
            java.util.regex.Pattern.compile("^people/[^/]+$");

        /**
         * Provides a list of the authenticated user's contacts. Sync tokens expire 7 days after the full
         * sync. A request with an expired sync token will result in a 410 error. In the case of such an
         * error clients should make a full sync request without a `sync_token`. The first page of a full
         * sync request has an additional quota. If the quota is exceeded, a 429 error will be returned.
         * This quota is fixed and can not be increased. When the `sync_token` is specified, resources
         * deleted since the last sync will be returned as a person with `PersonMetadata.deleted` set to
         * true. When the `page_token` or `sync_token` is specified, all other request parameters must
         * match the first call. Writes may have a propagation delay of several minutes for sync requests.
         * Incremental syncs are not intended for read-after-write use cases. See example usage at [List
         * the user's contacts that have
         * changed](/people/v1/contacts#list_the_users_contacts_that_have_changed).
         *
         * Create a request for the method "connections.list".
         *
         * This request holds the parameters needed by the the people server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param resourceName Required. The resource name to return connections for. Only `people/me` is valid.
         * @since 1.13
         */
        protected List(java.lang.String resourceName) {
          super(PeopleService.this, "GET", REST_PATH, null, com.google.api.services.people.v1.model.ListConnectionsResponse.class);
          this.resourceName = com.google.api.client.util.Preconditions.checkNotNull(resourceName, "Required parameter resourceName must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
                "Parameter resourceName must conform to the pattern " +
                "^people/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name to return connections for. Only `people/me` is valid. */
        @com.google.api.client.util.Key
        private java.lang.String resourceName;

        /** Required. The resource name to return connections for. Only `people/me` is valid.
         */
        public java.lang.String getResourceName() {
          return resourceName;
        }

        /** Required. The resource name to return connections for. Only `people/me` is valid. */
        public List setResourceName(java.lang.String resourceName) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(RESOURCE_NAME_PATTERN.matcher(resourceName).matches(),
                "Parameter resourceName must conform to the pattern " +
                "^people/[^/]+$");
          }
          this.resourceName = resourceName;
          return this;
        }

        /**
         * Optional. The number of connections to include in the response. Valid values are between
         * 1 and 1000, inclusive. Defaults to 100 if not set or set to 0.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** Optional. The number of connections to include in the response. Valid values are between 1 and
       1000, inclusive. Defaults to 100 if not set or set to 0.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * Optional. The number of connections to include in the response. Valid values are between
         * 1 and 1000, inclusive. Defaults to 100 if not set or set to 0.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * Optional. A page token, received from a previous response `next_page_token`. Provide this
         * to retrieve the subsequent page. When paginating, all other parameters provided to
         * `people.connections.list` must match the first call that provided the page token.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** Optional. A page token, received from a previous response `next_page_token`. Provide this to
       retrieve the subsequent page. When paginating, all other parameters provided to
       `people.connections.list` must match the first call that provided the page token.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * Optional. A page token, received from a previous response `next_page_token`. Provide this
         * to retrieve the subsequent page. When paginating, all other parameters provided to
         * `people.connections.list` must match the first call that provided the page token.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * Required. A field mask to restrict which fields on each person are returned. Multiple
         * fields can be specified by separating them with commas. Valid values are: * addresses *
         * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
         * emailAddresses * events * externalIds * genders * imClients * interests * locales *
         * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
         * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
         * userDefined
         */
        @com.google.api.client.util.Key
        private String personFields;

        /** Required. A field mask to restrict which fields on each person are returned. Multiple fields can be
       specified by separating them with commas. Valid values are: * addresses * ageRanges * biographies *
       birthdays * calendarUrls * clientData * coverPhotos * emailAddresses * events * externalIds *
       genders * imClients * interests * locales * locations * memberships * metadata * miscKeywords *
       names * nicknames * occupations * organizations * phoneNumbers * photos * relations * sipAddresses
       * skills * urls * userDefined
         */
        public String getPersonFields() {
          return personFields;
        }

        /**
         * Required. A field mask to restrict which fields on each person are returned. Multiple
         * fields can be specified by separating them with commas. Valid values are: * addresses *
         * ageRanges * biographies * birthdays * calendarUrls * clientData * coverPhotos *
         * emailAddresses * events * externalIds * genders * imClients * interests * locales *
         * locations * memberships * metadata * miscKeywords * names * nicknames * occupations *
         * organizations * phoneNumbers * photos * relations * sipAddresses * skills * urls *
         * userDefined
         */
        public List setPersonFields(String personFields) {
          this.personFields = personFields;
          return this;
        }

        /**
         * Required. Comma-separated list of person fields to be included in the response. Each path
         * should start with `person.`: for example, `person.names` or `person.photos`.
         */
        @com.google.api.client.util.Key("requestMask.includeField")
        private String requestMaskIncludeField;

        /** Required. Comma-separated list of person fields to be included in the response. Each path should
       start with `person.`: for example, `person.names` or `person.photos`.
         */
        public String getRequestMaskIncludeField() {
          return requestMaskIncludeField;
        }

        /**
         * Required. Comma-separated list of person fields to be included in the response. Each path
         * should start with `person.`: for example, `person.names` or `person.photos`.
         */
        public List setRequestMaskIncludeField(String requestMaskIncludeField) {
          this.requestMaskIncludeField = requestMaskIncludeField;
          return this;
        }

        /**
         * Optional. Whether the response should return `next_sync_token` on the last page of
         * results. It can be used to get incremental changes since the last request by setting it
         * on the request `sync_token`. More details about sync behavior at
         * `people.connections.list`.
         */
        @com.google.api.client.util.Key
        private java.lang.Boolean requestSyncToken;

        /** Optional. Whether the response should return `next_sync_token` on the last page of results. It can
       be used to get incremental changes since the last request by setting it on the request
       `sync_token`. More details about sync behavior at `people.connections.list`.
         */
        public java.lang.Boolean getRequestSyncToken() {
          return requestSyncToken;
        }

        /**
         * Optional. Whether the response should return `next_sync_token` on the last page of
         * results. It can be used to get incremental changes since the last request by setting it
         * on the request `sync_token`. More details about sync behavior at
         * `people.connections.list`.
         */
        public List setRequestSyncToken(java.lang.Boolean requestSyncToken) {
          this.requestSyncToken = requestSyncToken;
          return this;
        }

        /**
         * Optional. The order in which the connections should be sorted. Defaults to
         * `LAST_MODIFIED_ASCENDING`.
         */
        @com.google.api.client.util.Key
        private java.lang.String sortOrder;

        /** Optional. The order in which the connections should be sorted. Defaults to
       `LAST_MODIFIED_ASCENDING`.
         */
        public java.lang.String getSortOrder() {
          return sortOrder;
        }

        /**
         * Optional. The order in which the connections should be sorted. Defaults to
         * `LAST_MODIFIED_ASCENDING`.
         */
        public List setSortOrder(java.lang.String sortOrder) {
          this.sortOrder = sortOrder;
          return this;
        }

        /**
         * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
         * READ_SOURCE_TYPE_PROFILE if not set.
         */
        @com.google.api.client.util.Key
        private java.util.List<java.lang.String> sources;

        /** Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
       READ_SOURCE_TYPE_PROFILE if not set.
         */
        public java.util.List<java.lang.String> getSources() {
          return sources;
        }

        /**
         * Optional. A mask of what source types to return. Defaults to READ_SOURCE_TYPE_CONTACT and
         * READ_SOURCE_TYPE_PROFILE if not set.
         */
        public List setSources(java.util.List<java.lang.String> sources) {
          this.sources = sources;
          return this;
        }

        /**
         * Optional. A sync token, received from a previous response `next_sync_token` Provide this
         * to retrieve only the resources changed since the last request. When syncing, all other
         * parameters provided to `people.connections.list` must match the first call that provided
         * the sync token. More details about sync behavior at `people.connections.list`.
         */
        @com.google.api.client.util.Key
        private java.lang.String syncToken;

        /** Optional. A sync token, received from a previous response `next_sync_token` Provide this to
       retrieve only the resources changed since the last request. When syncing, all other parameters
       provided to `people.connections.list` must match the first call that provided the sync token. More
       details about sync behavior at `people.connections.list`.
         */
        public java.lang.String getSyncToken() {
          return syncToken;
        }

        /**
         * Optional. A sync token, received from a previous response `next_sync_token` Provide this
         * to retrieve only the resources changed since the last request. When syncing, all other
         * parameters provided to `people.connections.list` must match the first call that provided
         * the sync token. More details about sync behavior at `people.connections.list`.
         */
        public List setSyncToken(java.lang.String syncToken) {
          this.syncToken = syncToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link PeopleService}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link PeopleService}. */
    @Override
    public PeopleService build() {
      return new PeopleService(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link PeopleServiceRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setPeopleServiceRequestInitializer(
        PeopleServiceRequestInitializer peopleserviceRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(peopleserviceRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
