/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.people.v1;

/**
 * Available OAuth 2.0 scopes for use with the People API.
 *
 * @since 1.4
 */
public class PeopleServiceScopes {

  /** See, edit, download, and permanently delete your contacts. */
  public static final String CONTACTS = "https://www.googleapis.com/auth/contacts";

  /** See and download contact info automatically saved in your "Other contacts". */
  public static final String CONTACTS_OTHER_READONLY = "https://www.googleapis.com/auth/contacts.other.readonly";

  /** See and download your contacts. */
  public static final String CONTACTS_READONLY = "https://www.googleapis.com/auth/contacts.readonly";

  /** See and download your organization's GSuite directory. */
  public static final String DIRECTORY_READONLY = "https://www.googleapis.com/auth/directory.readonly";

  /** View your street addresses. */
  public static final String USER_ADDRESSES_READ = "https://www.googleapis.com/auth/user.addresses.read";

  /** See and download your exact date of birth. */
  public static final String USER_BIRTHDAY_READ = "https://www.googleapis.com/auth/user.birthday.read";

  /** See and download all of your Google Account email addresses. */
  public static final String USER_EMAILS_READ = "https://www.googleapis.com/auth/user.emails.read";

  /** See your gender. */
  public static final String USER_GENDER_READ = "https://www.googleapis.com/auth/user.gender.read";

  /** See your education, work history and org info. */
  public static final String USER_ORGANIZATION_READ = "https://www.googleapis.com/auth/user.organization.read";

  /** See and download your personal phone numbers. */
  public static final String USER_PHONENUMBERS_READ = "https://www.googleapis.com/auth/user.phonenumbers.read";

  /** See your primary Google Account email address. */
  public static final String USERINFO_EMAIL = "https://www.googleapis.com/auth/userinfo.email";

  /** See your personal info, including any personal info you've made publicly available. */
  public static final String USERINFO_PROFILE = "https://www.googleapis.com/auth/userinfo.profile";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(CONTACTS);
    set.add(CONTACTS_OTHER_READONLY);
    set.add(CONTACTS_READONLY);
    set.add(DIRECTORY_READONLY);
    set.add(USER_ADDRESSES_READ);
    set.add(USER_BIRTHDAY_READ);
    set.add(USER_EMAILS_READ);
    set.add(USER_GENDER_READ);
    set.add(USER_ORGANIZATION_READ);
    set.add(USER_PHONENUMBERS_READ);
    set.add(USERINFO_EMAIL);
    set.add(USERINFO_PROFILE);
    return java.util.Collections.unmodifiableSet(set);
  }

  private PeopleServiceScopes() {
  }
}
